/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.db.DBOutputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hive.storage.jdbc.DBRecordWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordWriter
implements FileSinkOperator.RecordWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRecordWriter.class);
    private final DBOutputFormat.DBRecordWriter dbRecordWriter;

    public JdbcRecordWriter(DBOutputFormat.DBRecordWriter writer) {
        this.dbRecordWriter = writer;
    }

    public void write(Writable w) throws IOException {
        this.dbRecordWriter.write((DBWritable)((DBRecordWritable)w), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean abort) throws IOException {
        if (abort) {
            Connection conn = this.dbRecordWriter.getConnection();
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                LOG.warn("Failed to perform rollback on connection", (Throwable)ex);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        } else {
            this.dbRecordWriter.close(null);
        }
    }
}

