/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.objects;

import java.util.List;
import org.apache.hive.hplsql.ColumnDefinition;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.objects.HplClass;
import org.apache.hive.hplsql.objects.MethodDictionary;
import org.apache.hive.hplsql.objects.MethodParams;
import org.apache.hive.hplsql.objects.Table;

public class TableClass
implements HplClass {
    private static final MethodDictionary<Table> methodDictionary = new MethodDictionary();
    private final String typeName;
    private final List<ColumnDefinition> columns;
    private final boolean rowType;

    private static Var wrap(Object result) {
        return result != null ? new Var((Long)result) : Var.Null;
    }

    public TableClass(String typeName, List<ColumnDefinition> columns, boolean rowType) {
        this.typeName = typeName;
        this.columns = columns;
        this.rowType = rowType;
    }

    public String typeName() {
        return this.typeName;
    }

    public List<ColumnDefinition> columns() {
        return this.columns;
    }

    @Override
    public Table newInstance() {
        return new Table(this);
    }

    @Override
    public MethodDictionary methodDictionary() {
        return methodDictionary;
    }

    public boolean rowType() {
        return this.rowType;
    }

    static {
        methodDictionary.put("first", (self, args) -> {
            MethodParams.Arity.NULLARY.check("first", args);
            return TableClass.wrap(self.firstKey());
        });
        methodDictionary.put("last", (self, args) -> {
            MethodParams.Arity.NULLARY.check("last", args);
            return TableClass.wrap(self.lastKey());
        });
        methodDictionary.put("next", (self, args) -> {
            Long key = new MethodParams("next", args, MethodParams.Arity.UNARY).longAt(0);
            return TableClass.wrap(self.nextKey(key));
        });
        methodDictionary.put("prior", (self, args) -> {
            Long key = new MethodParams("prior", args, MethodParams.Arity.UNARY).longAt(0);
            return TableClass.wrap(self.priorKey(key));
        });
        methodDictionary.put("count", (self, args) -> {
            MethodParams.Arity.NULLARY.check("count", args);
            return new Var(Long.valueOf(self.count()));
        });
        methodDictionary.put("exists", (self, args) -> {
            Long key = new MethodParams("exists", args, MethodParams.Arity.UNARY).longAt(0);
            return new Var(self.existsAt(key));
        });
        methodDictionary.put("delete", (self, args) -> {
            MethodParams.Arity.max(3).check("delete", args);
            if (args.isEmpty()) {
                self.removeAll();
            } else if (args.size() == 1) {
                self.removeAt(((Var)args.get((int)0)).value);
            } else {
                self.removeFromTo(((Var)args.get((int)0)).value, ((Var)args.get((int)1)).value);
            }
            return null;
        });
        methodDictionary.put("__GETITEM__", (self, args) -> {
            Long key = new MethodParams("__GETITEM__", args, MethodParams.Arity.UNARY).longAt(0);
            Row row = self.at(key);
            if (row == null) {
                return Var.Null;
            }
            if (self.hplClass().rowType()) {
                Var var = new Var();
                var.setType(Var.Type.ROW.name());
                var.setValue(row);
                return var;
            }
            return row.getValue(0);
        });
        methodDictionary.put("__SETITEM__", (self, args) -> {
            MethodParams params = new MethodParams("__SETITEM__", args, MethodParams.Arity.BINARY);
            long key = params.longAt(0);
            if (self.hplClass().rowType()) {
                self.put(key, params.rowAt(1));
            } else {
                Row row = new Row();
                row.addColumn(self.hplClass().columns().get(0).columnName(), self.hplClass().columns.get(0).columnTypeString(), (Var)args.get(1));
                self.put(key, row);
            }
            return Var.Null;
        });
    }
}

