/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAlterHandler
implements AlterHandler {
    protected Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveAlterHandler.class.getName());

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void alterTable(RawStore msdb, Warehouse wh, String catName, String dbname, String name, Table newt, EnvironmentContext environmentContext, IHMSHandler handler) throws InvalidOperationException, MetaException {
        Table oldt;
        Map<String, String> txnAlterTableEventResponses;
        List<MetaStoreEventListener> listeners;
        boolean success;
        block49: {
            boolean cascade;
            catName = StringUtils.normalizeIdentifier(catName);
            name = name.toLowerCase();
            dbname = dbname.toLowerCase();
            boolean bl = cascade = environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("CASCADE"));
            if (newt == null) {
                throw new InvalidOperationException("New table is null");
            }
            String newTblName = newt.getTableName().toLowerCase();
            String newDbName = newt.getDbName().toLowerCase();
            if (!MetaStoreUtils.validateName(newTblName, handler.getConf())) {
                throw new InvalidOperationException(newTblName + " is not a valid object name");
            }
            String validate = MetaStoreUtils.validateTblColumns(newt.getSd().getCols());
            if (validate != null) {
                throw new InvalidOperationException("Invalid column " + validate);
            }
            Path srcPath = null;
            Path destPath = null;
            FileSystem destFs = null;
            success = false;
            boolean dataWasMoved = false;
            boolean isPartitionedTable = false;
            List<TransactionalMetaStoreEventListener> transactionalListeners = handler.getTransactionalListeners();
            listeners = handler.getListeners();
            txnAlterTableEventResponses = Collections.emptyMap();
            try {
                boolean rename = false;
                if (!catName.equalsIgnoreCase(newt.getCatName())) {
                    throw new InvalidOperationException("Tables cannot be moved between catalogs, old catalog" + catName + ", new catalog " + newt.getCatName());
                }
                if (!newTblName.equals(name) || !newDbName.equals(dbname)) {
                    if (msdb.getTable(catName, newDbName, newTblName) != null) {
                        throw new InvalidOperationException("new table " + newDbName + "." + newTblName + " already exists");
                    }
                    rename = true;
                }
                msdb.openTransaction();
                oldt = msdb.getTable(catName, dbname, name);
                if (oldt == null) {
                    throw new InvalidOperationException("table " + Warehouse.getCatalogQualifiedTableName(catName, dbname, name) + " doesn't exist");
                }
                if (oldt.getPartitionKeysSize() != 0) {
                    isPartitionedTable = true;
                }
                if (MetastoreConf.getBoolVar(handler.getConf(), MetastoreConf.ConfVars.DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES) && !oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) {
                    this.checkColTypeChangeCompatible(oldt.getSd().getCols(), newt.getSd().getCols());
                }
                boolean partKeysPartiallyEqual = this.checkPartialPartKeysEqual(oldt.getPartitionKeys(), newt.getPartitionKeys());
                if (!oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) && !partKeysPartiallyEqual) {
                    throw new InvalidOperationException("partition keys can not be changed.");
                }
                if (rename && !oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) && (oldt.getSd().getLocation().compareTo(newt.getSd().getLocation()) == 0 || org.apache.commons.lang.StringUtils.isEmpty(newt.getSd().getLocation())) && !MetaStoreUtils.isExternalTable(oldt)) {
                    boolean tableInSpecifiedLoc;
                    Database olddb = msdb.getDatabase(catName, dbname);
                    srcPath = new Path(oldt.getSd().getLocation());
                    String oldtRelativePath = new Path(olddb.getLocationUri()).toUri().relativize(srcPath.toUri()).toString();
                    boolean bl2 = tableInSpecifiedLoc = !oldtRelativePath.equalsIgnoreCase(name) && !oldtRelativePath.equalsIgnoreCase(name + "/");
                    if (!tableInSpecifiedLoc) {
                        FileSystem srcFs = wh.getFs(srcPath);
                        Database db = msdb.getDatabase(catName, newDbName);
                        Path databasePath = this.constructRenamedPath(wh.getDatabasePath(db), srcPath);
                        destPath = new Path(databasePath, newTblName);
                        destFs = wh.getFs(destPath);
                        newt.getSd().setLocation(destPath.toString());
                        if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                            throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                        }
                        try {
                            if (destFs.exists(destPath)) {
                                throw new InvalidOperationException("New location for this table " + Warehouse.getCatalogQualifiedTableName(catName, newDbName, newTblName) + " already exists : " + destPath);
                            }
                            if (srcFs.exists(srcPath) && wh.renameDir(srcPath, destPath, ReplChangeManager.isSourceOfReplication(olddb))) {
                                dataWasMoved = true;
                            }
                        }
                        catch (IOException | MetaException e) {
                            LOG.error("Alter Table operation for " + dbname + "." + name + " failed.", (Throwable)e);
                            throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage(e) + "' See hive log file for details.");
                        }
                        if (!HiveMetaStore.isRenameAllowed(olddb, db)) {
                            LOG.error("Alter Table operation for " + Warehouse.getCatalogQualifiedTableName(catName, dbname, name) + "to new table = " + Warehouse.getCatalogQualifiedTableName(catName, newDbName, newTblName) + " failed ");
                            throw new MetaException("Alter table not allowed for table " + Warehouse.getCatalogQualifiedTableName(catName, dbname, name) + "to new table = " + Warehouse.getCatalogQualifiedTableName(catName, newDbName, newTblName));
                        }
                    }
                    if (isPartitionedTable) {
                        String oldTblLocPath = srcPath.toUri().getPath();
                        String newTblLocPath = dataWasMoved ? destPath.toUri().getPath() : null;
                        List<Partition> parts = msdb.getPartitions(catName, dbname, name, -1);
                        HashMap<Partition, ColumnStatistics> columnStatsNeedUpdated = new HashMap<Partition, ColumnStatistics>();
                        for (Partition partition : parts) {
                            String oldPartLoc = partition.getSd().getLocation();
                            if (dataWasMoved && oldPartLoc.contains(oldTblLocPath)) {
                                URI oldUri = new Path(oldPartLoc).toUri();
                                String newPath = oldUri.getPath().replace(oldTblLocPath, newTblLocPath);
                                Path newPartLocPath = new Path(oldUri.getScheme(), oldUri.getAuthority(), newPath);
                                partition.getSd().setLocation(newPartLocPath.toString());
                            }
                            partition.setDbName(newDbName);
                            partition.setTableName(newTblName);
                            ColumnStatistics colStats = this.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, partition.getValues(), partition.getSd().getCols(), oldt, partition, null);
                            if (colStats == null) continue;
                            columnStatsNeedUpdated.put(partition, colStats);
                        }
                        msdb.alterTable(catName, dbname, name, newt);
                        if (dataWasMoved) {
                            int partsToProcess = parts.size();
                            int n = MetastoreConf.getIntVar(handler.getConf(), MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
                            int batchStart = 0;
                            while (partsToProcess > 0) {
                                int batchEnd = Math.min(batchStart + n, parts.size());
                                List<Partition> partBatch = parts.subList(batchStart, batchEnd);
                                int partBatchSize = partBatch.size();
                                partsToProcess -= partBatchSize;
                                batchStart += partBatchSize;
                                ArrayList<List<String>> partValues = new ArrayList<List<String>>(partBatchSize);
                                for (Partition part : partBatch) {
                                    partValues.add(part.getValues());
                                }
                                msdb.alterPartitions(catName, newDbName, newTblName, partValues, partBatch);
                            }
                        }
                        for (Map.Entry entry : columnStatsNeedUpdated.entrySet()) {
                            ColumnStatistics newPartColStats = (ColumnStatistics)entry.getValue();
                            newPartColStats.getStatsDesc().setDbName(newDbName);
                            newPartColStats.getStatsDesc().setTableName(newTblName);
                            msdb.updatePartitionColumnStatistics(newPartColStats, ((Partition)entry.getKey()).getValues());
                        }
                    } else {
                        this.alterTableUpdateTableColumnStats(msdb, oldt, newt);
                    }
                } else {
                    if (MetaStoreUtils.requireCalStats(null, null, newt, environmentContext) && !isPartitionedTable) {
                        Database db = msdb.getDatabase(catName, newDbName);
                        MetaStoreUtils.updateTableStatsSlow(db, newt, wh, false, true, environmentContext);
                    }
                    if (isPartitionedTable) {
                        if (!MetaStoreUtils.areSameColumns(oldt.getSd().getCols(), newt.getSd().getCols())) {
                            List<Partition> parts2 = msdb.getPartitions(catName, dbname, name, -1);
                            for (Partition part : parts2) {
                                Partition oldPart = new Partition(part);
                                List<FieldSchema> oldCols = part.getSd().getCols();
                                part.getSd().setCols(newt.getSd().getCols());
                                ColumnStatistics colStats = this.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, part.getValues(), oldCols, oldt, part, null);
                                assert (colStats == null);
                                if (cascade) {
                                    msdb.alterPartition(catName, dbname, name, part.getValues(), part);
                                    continue;
                                }
                                oldPart.setParameters(part.getParameters());
                                msdb.alterPartition(catName, dbname, name, part.getValues(), oldPart);
                            }
                            msdb.alterTable(catName, dbname, name, newt);
                        } else {
                            LOG.warn("Alter table not cascaded to partitions.");
                            this.alterTableUpdateTableColumnStats(msdb, oldt, newt);
                        }
                    } else {
                        this.alterTableUpdateTableColumnStats(msdb, oldt, newt);
                    }
                }
                if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                    txnAlterTableEventResponses = MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(oldt, newt, false, true, handler), environmentContext);
                }
                if (success = msdb.commitTransaction()) break block49;
            }
            catch (InvalidObjectException e) {
                try {
                    LOG.debug("Failed to get object from Metastore ", (Throwable)e);
                    throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e.getMessage());
                    catch (InvalidInputException e2) {
                        LOG.debug("Accessing Metastore failed due to invalid input ", (Throwable)e2);
                        throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e2.getMessage());
                    }
                    catch (NoSuchObjectException e3) {
                        LOG.debug("Object not found in metastore ", (Throwable)e3);
                        throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist" + " Check metastore logs for detailed stack." + e3.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    LOG.error("Failed to alter table " + Warehouse.getCatalogQualifiedTableName(catName, dbname, name));
                    msdb.rollbackTransaction();
                    if (!dataWasMoved) throw throwable;
                    try {
                        if (!destFs.exists(destPath)) throw throwable;
                        if (destFs.rename(destPath, srcPath)) throw throwable;
                        LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                        throw throwable;
                    }
                    catch (IOException e4) {
                        LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                    }
                    throw throwable;
                }
            }
            LOG.error("Failed to alter table " + Warehouse.getCatalogQualifiedTableName(catName, dbname, name));
            msdb.rollbackTransaction();
            if (dataWasMoved) {
                try {
                    if (destFs.exists(destPath) && !destFs.rename(destPath, srcPath)) {
                        LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                }
            }
        }
        if (listeners.isEmpty()) return;
        MetaStoreListenerNotifier.notifyEvent(listeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(oldt, newt, false, success, handler), environmentContext, txnAlterTableEventResponses, msdb);
    }

    String getSimpleMessage(Exception ex) {
        if (ex instanceof MetaException) {
            String msg = ex.getMessage();
            if (msg == null || !msg.contains("\n")) {
                return msg;
            }
            return msg.substring(0, msg.indexOf(10));
        }
        return ex.getMessage();
    }

    @Override
    public Partition alterPartition(RawStore msdb, Warehouse wh, String dbname, String name, List<String> part_vals, Partition new_part, EnvironmentContext environmentContext) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        return this.alterPartition(msdb, wh, "hive", dbname, name, part_vals, new_part, environmentContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition alterPartition(RawStore msdb, Warehouse wh, String catName, String dbname, String name, List<String> part_vals, Partition new_part, EnvironmentContext environmentContext, IHMSHandler handler) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        Partition oldPart;
        block54: {
            boolean success = false;
            List<TransactionalMetaStoreEventListener> transactionalListeners = null;
            if (handler != null) {
                transactionalListeners = handler.getTransactionalListeners();
            }
            if (new_part.getParameters() == null || new_part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(new_part.getParameters().get("transient_lastDdlTime")) == 0) {
                new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            if (part_vals == null || part_vals.size() == 0) {
                Partition oldPart2;
                try {
                    msdb.openTransaction();
                    Table tbl = msdb.getTable(catName, dbname, name);
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to alter partition because table or database does not exist.");
                    }
                    oldPart2 = msdb.getPartition(catName, dbname, name, new_part.getValues());
                    if (MetaStoreUtils.requireCalStats(oldPart2, new_part, tbl, environmentContext)) {
                        if (MetaStoreUtils.isFastStatsSame(oldPart2, new_part)) {
                            MetaStoreUtils.updateBasicState(environmentContext, new_part.getParameters());
                        } else {
                            MetaStoreUtils.updatePartitionStatsFast(new_part, tbl, wh, false, true, environmentContext, false);
                        }
                    }
                    if (oldPart2.getSd() != null) {
                        this.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, new_part.getValues(), oldPart2.getSd().getCols(), tbl, new_part, null);
                    }
                    msdb.alterPartition(catName, dbname, name, new_part.getValues(), new_part);
                    if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart2, new_part, tbl, false, true, handler), environmentContext);
                    }
                    success = msdb.commitTransaction();
                }
                catch (InvalidObjectException e) {
                    LOG.warn("Alter failed", (Throwable)e);
                    throw new InvalidOperationException("alter is not possible: " + e.getMessage());
                }
                catch (NoSuchObjectException e) {
                    throw new InvalidOperationException("alter is not possible: " + e.getMessage());
                }
                finally {
                    if (!success) {
                        msdb.rollbackTransaction();
                    }
                }
                return oldPart2;
            }
            Path srcPath = null;
            Path destPath = null;
            FileSystem destFs = null;
            boolean dataWasMoved = false;
            try {
                Partition check_part;
                msdb.openTransaction();
                Table tbl = msdb.getTable("hive", dbname, name);
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to alter partition because table or database does not exist.");
                }
                try {
                    oldPart = msdb.getPartition(catName, dbname, name, part_vals);
                }
                catch (NoSuchObjectException e) {
                    throw new InvalidObjectException("Unable to rename partition because old partition does not exist");
                }
                try {
                    check_part = msdb.getPartition(catName, dbname, name, new_part.getValues());
                }
                catch (NoSuchObjectException e) {
                    check_part = null;
                }
                if (check_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + dbname + "." + name + "." + new_part.getValues());
                }
                if (!tbl.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                    Database db;
                    try {
                        db = msdb.getDatabase(catName, dbname);
                        destPath = wh.getPartitionPath(db, tbl, new_part.getValues());
                        destPath = this.constructRenamedPath(destPath, new Path(new_part.getSd().getLocation()));
                    }
                    catch (NoSuchObjectException e) {
                        LOG.debug("Didn't find object in metastore ", (Throwable)e);
                        throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist" + " Check metastore logs for detailed stack." + e.getMessage());
                    }
                    if (destPath != null) {
                        String newPartLoc = destPath.toString();
                        String oldPartLoc = oldPart.getSd().getLocation();
                        LOG.info("srcPath:" + oldPartLoc);
                        LOG.info("descPath:" + newPartLoc);
                        srcPath = new Path(oldPartLoc);
                        FileSystem srcFs = wh.getFs(srcPath);
                        destFs = wh.getFs(destPath);
                        if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                            throw new InvalidOperationException("New table location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported.");
                        }
                        try {
                            if (srcFs.exists(srcPath)) {
                                if (newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                                    throw new InvalidOperationException("New location for this table " + tbl.getDbName() + "." + tbl.getTableName() + " already exists : " + destPath);
                                }
                                Path destParentPath = destPath.getParent();
                                if (!wh.mkdirs(destParentPath)) {
                                    throw new MetaException("Unable to create path " + destParentPath);
                                }
                                wh.renameDir(srcPath, destPath, ReplChangeManager.isSourceOfReplication(db));
                                LOG.info("Partition directory rename from " + srcPath + " to " + destPath + " done.");
                                dataWasMoved = true;
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Cannot rename partition directory from " + srcPath + " to " + destPath, (Throwable)e);
                            throw new InvalidOperationException("Unable to access src or dest location for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + new_part.getValues());
                        }
                        catch (MetaException me) {
                            LOG.error("Cannot rename partition directory from " + srcPath + " to " + destPath, (Throwable)me);
                            throw me;
                        }
                        new_part.getSd().setLocation(newPartLoc);
                    }
                } else {
                    new_part.getSd().setLocation(oldPart.getSd().getLocation());
                }
                if (MetaStoreUtils.requireCalStats(oldPart, new_part, tbl, environmentContext)) {
                    MetaStoreUtils.updatePartitionStatsFast(new_part, tbl, wh, false, true, environmentContext, false);
                }
                String newPartName = Warehouse.makePartName(tbl.getPartitionKeys(), new_part.getValues());
                ColumnStatistics cs = this.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, oldPart.getValues(), oldPart.getSd().getCols(), tbl, new_part, null);
                msdb.alterPartition(catName, dbname, name, part_vals, new_part);
                if (cs != null) {
                    cs.getStatsDesc().setPartName(newPartName);
                    try {
                        msdb.updatePartitionColumnStatistics(cs, new_part.getValues());
                    }
                    catch (InvalidInputException iie) {
                        throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        // empty catch block
                    }
                }
                if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, new_part, tbl, false, true, handler), environmentContext);
                }
                if (success = msdb.commitTransaction()) break block54;
            }
            catch (Throwable throwable) {
                if (!success) {
                    LOG.error("Failed to rename a partition. Rollback transaction");
                    msdb.rollbackTransaction();
                    if (dataWasMoved) {
                        LOG.error("Revert the data move in renaming a partition.");
                        try {
                            if (destFs.exists(destPath)) {
                                wh.renameDir(destPath, srcPath, false);
                            }
                        }
                        catch (MetaException me) {
                            LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                        }
                        catch (IOException ioe) {
                            LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                        }
                    }
                }
                throw throwable;
            }
            LOG.error("Failed to rename a partition. Rollback transaction");
            msdb.rollbackTransaction();
            if (dataWasMoved) {
                LOG.error("Revert the data move in renaming a partition.");
                try {
                    if (destFs.exists(destPath)) {
                        wh.renameDir(destPath, srcPath, false);
                    }
                }
                catch (MetaException me) {
                    LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                }
                catch (IOException ioe) {
                    LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                }
            }
        }
        return oldPart;
    }

    @Override
    public List<Partition> alterPartitions(RawStore msdb, Warehouse wh, String dbname, String name, List<Partition> new_parts, EnvironmentContext environmentContext) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        return this.alterPartitions(msdb, wh, "hive", dbname, name, new_parts, environmentContext, null);
    }

    @Override
    public List<Partition> alterPartitions(RawStore msdb, Warehouse wh, String catName, String dbname, String name, List<Partition> new_parts, EnvironmentContext environmentContext, IHMSHandler handler) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        ArrayList<Partition> oldParts = new ArrayList<Partition>();
        ArrayList<List<String>> partValsList = new ArrayList<List<String>>();
        List<TransactionalMetaStoreEventListener> transactionalListeners = null;
        if (handler != null) {
            transactionalListeners = handler.getTransactionalListeners();
        }
        boolean success = false;
        try {
            msdb.openTransaction();
            Table tbl = msdb.getTable(catName, dbname, name);
            if (tbl == null) {
                throw new InvalidObjectException("Unable to alter partitions because table or database does not exist.");
            }
            for (Partition tmpPart : new_parts) {
                if (tmpPart.getParameters() == null || tmpPart.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(tmpPart.getParameters().get("transient_lastDdlTime")) == 0) {
                    tmpPart.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                }
                Partition oldTmpPart = msdb.getPartition(catName, dbname, name, tmpPart.getValues());
                oldParts.add(oldTmpPart);
                partValsList.add(tmpPart.getValues());
                if (MetaStoreUtils.requireCalStats(oldTmpPart, tmpPart, tbl, environmentContext)) {
                    if (MetaStoreUtils.isFastStatsSame(oldTmpPart, tmpPart)) {
                        MetaStoreUtils.updateBasicState(environmentContext, tmpPart.getParameters());
                    } else {
                        MetaStoreUtils.updatePartitionStatsFast(tmpPart, tbl, wh, false, true, environmentContext, false);
                    }
                }
                if (oldTmpPart.getSd() == null) continue;
                this.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, oldTmpPart.getValues(), oldTmpPart.getSd().getCols(), tbl, tmpPart, null);
            }
            msdb.alterPartitions(catName, dbname, name, partValsList, new_parts);
            Iterator oldPartsIt = oldParts.iterator();
            for (Partition newPart : new_parts) {
                if (!oldPartsIt.hasNext()) {
                    throw new InvalidOperationException("Missing old partition corresponding to new partition when invoking MetaStoreEventListener for alterPartitions event.");
                }
                Partition oldPart = (Partition)oldPartsIt.next();
                if (transactionalListeners == null || transactionalListeners.isEmpty()) continue;
                MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, newPart, tbl, false, true, handler));
            }
            success = msdb.commitTransaction();
        }
        catch (InvalidObjectException | NoSuchObjectException e) {
            throw new InvalidOperationException("Alter partition operation failed: " + e);
        }
        finally {
            if (!success) {
                msdb.rollbackTransaction();
            }
        }
        return oldParts;
    }

    private boolean checkPartialPartKeysEqual(List<FieldSchema> oldPartKeys, List<FieldSchema> newPartKeys) {
        if (newPartKeys == null || oldPartKeys == null) {
            return oldPartKeys == newPartKeys;
        }
        if (oldPartKeys.size() != newPartKeys.size()) {
            return false;
        }
        Iterator<FieldSchema> oldPartKeysIter = oldPartKeys.iterator();
        Iterator<FieldSchema> newPartKeysIter = newPartKeys.iterator();
        while (oldPartKeysIter.hasNext()) {
            FieldSchema oldFs = oldPartKeysIter.next();
            FieldSchema newFs = newPartKeysIter.next();
            if (oldFs.getName().equals(newFs.getName())) continue;
            return false;
        }
        return true;
    }

    private Path constructRenamedPath(Path defaultNewPath, Path currentPath) {
        URI currentUri = currentPath.toUri();
        return new Path(currentUri.getScheme(), currentUri.getAuthority(), defaultNewPath.toUri().getPath());
    }

    @VisibleForTesting
    void alterTableUpdateTableColumnStats(RawStore msdb, Table oldTable, Table newTable) throws MetaException, InvalidObjectException {
        String catName = StringUtils.normalizeIdentifier(oldTable.isSetCatName() ? oldTable.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf));
        String dbName = oldTable.getDbName().toLowerCase();
        String tableName = StringUtils.normalizeIdentifier(oldTable.getTableName());
        String newDbName = newTable.getDbName().toLowerCase();
        String newTableName = StringUtils.normalizeIdentifier(newTable.getTableName());
        try {
            List<FieldSchema> oldCols = oldTable.getSd().getCols();
            List<FieldSchema> newCols = newTable.getSd().getCols();
            ArrayList<ColumnStatisticsObj> newStatsObjs = new ArrayList<ColumnStatisticsObj>();
            ColumnStatistics colStats = null;
            boolean updateColumnStats = true;
            if (newDbName.equals(dbName) && newTableName.equals(tableName) && MetaStoreUtils.columnsIncludedByNameType(oldCols, newCols)) {
                updateColumnStats = false;
            }
            if (updateColumnStats) {
                ArrayList<String> oldColNames = new ArrayList<String>(oldCols.size());
                for (FieldSchema oldCol : oldCols) {
                    oldColNames.add(oldCol.getName());
                }
                colStats = msdb.getTableColumnStatistics(catName, dbName, tableName, oldColNames);
                if (colStats == null) {
                    updateColumnStats = false;
                } else {
                    List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
                    if (statsObjs != null) {
                        ArrayList<String> deletedCols = new ArrayList<String>();
                        for (ColumnStatisticsObj statsObj : statsObjs) {
                            boolean found = false;
                            for (FieldSchema newCol : newCols) {
                                if (!statsObj.getColName().equalsIgnoreCase(newCol.getName()) || !statsObj.getColType().equalsIgnoreCase(newCol.getType())) continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                if (newDbName.equals(dbName) && newTableName.equals(tableName)) continue;
                                msdb.deleteTableColumnStatistics(catName, dbName, tableName, statsObj.getColName());
                                newStatsObjs.add(statsObj);
                                deletedCols.add(statsObj.getColName());
                                continue;
                            }
                            msdb.deleteTableColumnStatistics(catName, dbName, tableName, statsObj.getColName());
                            deletedCols.add(statsObj.getColName());
                        }
                        StatsSetupConst.removeColumnStatsState(newTable.getParameters(), deletedCols);
                    }
                }
            }
            msdb.alterTable(catName, dbName, tableName, newTable);
            if (updateColumnStats && !newStatsObjs.isEmpty()) {
                ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
                statsDesc.setDbName(newDbName);
                statsDesc.setTableName(newTableName);
                colStats.setStatsObj(newStatsObjs);
                msdb.updateTableColumnStatistics(colStats);
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug("Could not find db entry." + nsoe);
        }
        catch (InvalidInputException e) {
            throw new InvalidObjectException("Invalid inputs to update table column stats: " + e);
        }
    }

    private ColumnStatistics updateOrGetPartitionColumnStats(RawStore msdb, String catName, String dbname, String tblname, List<String> partVals, List<FieldSchema> oldCols, Table table, Partition part, List<FieldSchema> newCols) throws MetaException, InvalidObjectException {
        ColumnStatistics newPartsColStats = null;
        try {
            boolean rename;
            if (newCols == null) {
                newCols = part.getSd() == null ? new ArrayList() : part.getSd().getCols();
            }
            String oldPartName = Warehouse.makePartName(table.getPartitionKeys(), partVals);
            String newPartName = Warehouse.makePartName(table.getPartitionKeys(), part.getValues());
            boolean bl = rename = !part.getDbName().equals(dbname) || !part.getTableName().equals(tblname) || !oldPartName.equals(newPartName);
            if (!rename && MetaStoreUtils.columnsIncludedByNameType(oldCols, newCols)) {
                return newPartsColStats;
            }
            ArrayList<String> oldColNames = new ArrayList<String>(oldCols.size());
            for (FieldSchema oldCol : oldCols) {
                oldColNames.add(oldCol.getName());
            }
            ArrayList<String> oldPartNames = Lists.newArrayList(oldPartName);
            List<ColumnStatistics> partsColStats = msdb.getPartitionColumnStatistics(catName, dbname, tblname, oldPartNames, oldColNames);
            assert (partsColStats.size() <= 1);
            for (ColumnStatistics partColStats : partsColStats) {
                ArrayList<ColumnStatisticsObj> newStatsObjs = new ArrayList<ColumnStatisticsObj>();
                List<ColumnStatisticsObj> statsObjs = partColStats.getStatsObj();
                ArrayList<String> deletedCols = new ArrayList<String>();
                for (ColumnStatisticsObj statsObj : statsObjs) {
                    boolean found = false;
                    for (FieldSchema newCol : newCols) {
                        if (!statsObj.getColName().equalsIgnoreCase(newCol.getName()) || !statsObj.getColType().equalsIgnoreCase(newCol.getType())) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        if (!rename) continue;
                        msdb.deletePartitionColumnStatistics(catName, dbname, tblname, partColStats.getStatsDesc().getPartName(), partVals, statsObj.getColName());
                        newStatsObjs.add(statsObj);
                        continue;
                    }
                    msdb.deletePartitionColumnStatistics(catName, dbname, tblname, partColStats.getStatsDesc().getPartName(), partVals, statsObj.getColName());
                    deletedCols.add(statsObj.getColName());
                }
                StatsSetupConst.removeColumnStatsState(part.getParameters(), deletedCols);
                if (newStatsObjs.isEmpty()) continue;
                partColStats.setStatsObj(newStatsObjs);
                newPartsColStats = partColStats;
            }
        }
        catch (NoSuchObjectException oldPartName) {
        }
        catch (InvalidInputException iie) {
            throw new InvalidObjectException("Invalid input to delete partition column stats." + iie);
        }
        return newPartsColStats;
    }

    private void checkColTypeChangeCompatible(List<FieldSchema> oldCols, List<FieldSchema> newCols) throws InvalidOperationException {
        ArrayList<String> incompatibleCols = new ArrayList<String>();
        int maxCols = Math.min(oldCols.size(), newCols.size());
        for (int i = 0; i < maxCols; ++i) {
            if (ColumnType.areColTypesCompatible(ColumnType.getTypeName(oldCols.get(i).getType()), ColumnType.getTypeName(newCols.get(i).getType()))) continue;
            incompatibleCols.add(newCols.get(i).getName());
        }
        if (!incompatibleCols.isEmpty()) {
            throw new InvalidOperationException("The following columns have types incompatible with the existing columns in their respective positions :\n" + org.apache.commons.lang.StringUtils.join(incompatibleCols, ','));
        }
    }
}

