/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="op", value="a op b - Returns the result of operation")
public abstract class GenericUDFBaseCompare
extends GenericUDFBaseBinary {
    protected transient ObjectInspector[] argumentOIs;
    protected transient GenericUDFUtils.ReturnObjectInspectorResolver conversionHelper = null;
    protected ObjectInspector compareOI;
    protected CompareType compareType;
    protected transient ObjectInspectorConverters.Converter converter0;
    protected transient ObjectInspectorConverters.Converter converter1;
    protected transient StringObjectInspector soi0;
    protected transient StringObjectInspector soi1;
    protected transient IntObjectInspector ioi0;
    protected transient IntObjectInspector ioi1;
    protected transient LongObjectInspector loi0;
    protected transient LongObjectInspector loi1;
    protected transient ByteObjectInspector byoi0;
    protected transient ByteObjectInspector byoi1;
    protected transient BooleanObjectInspector boi0;
    protected transient BooleanObjectInspector boi1;
    protected final BooleanWritable result = new BooleanWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException(this.opName + " requires two arguments.");
        }
        this.argumentOIs = arguments;
        for (int i = 0; i < arguments.length; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of " + this.opName + "  is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        if (TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[0]).equals(TypeInfoFactory.stringTypeInfo) && TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[1]).equals(TypeInfoFactory.stringTypeInfo)) {
            this.soi0 = (StringObjectInspector)arguments[0];
            this.soi1 = (StringObjectInspector)arguments[1];
            this.compareType = this.soi0.preferWritable() || this.soi1.preferWritable() ? CompareType.COMPARE_TEXT : CompareType.COMPARE_STRING;
        } else if (TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[0]).equals(TypeInfoFactory.intTypeInfo) && TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[1]).equals(TypeInfoFactory.intTypeInfo)) {
            this.compareType = CompareType.COMPARE_INT;
            this.ioi0 = (IntObjectInspector)arguments[0];
            this.ioi1 = (IntObjectInspector)arguments[1];
        } else if (TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[0]).equals(TypeInfoFactory.longTypeInfo) && TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[1]).equals(TypeInfoFactory.longTypeInfo)) {
            this.compareType = CompareType.COMPARE_LONG;
            this.loi0 = (LongObjectInspector)arguments[0];
            this.loi1 = (LongObjectInspector)arguments[1];
        } else if (TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[0]).equals(TypeInfoFactory.byteTypeInfo) && TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[1]).equals(TypeInfoFactory.byteTypeInfo)) {
            this.compareType = CompareType.COMPARE_BYTE;
            this.byoi0 = (ByteObjectInspector)arguments[0];
            this.byoi1 = (ByteObjectInspector)arguments[1];
        } else if (TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[0]).equals(TypeInfoFactory.booleanTypeInfo) && TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[1]).equals(TypeInfoFactory.booleanTypeInfo)) {
            this.compareType = CompareType.COMPARE_BOOL;
            this.boi0 = (BooleanObjectInspector)arguments[0];
            this.boi1 = (BooleanObjectInspector)arguments[1];
        } else {
            TypeInfo oiTypeInfo1;
            TypeInfo oiTypeInfo0 = TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[0]);
            if (oiTypeInfo0 == (oiTypeInfo1 = TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[1])) || TypeInfoUtils.doPrimitiveCategoriesMatch(oiTypeInfo0, oiTypeInfo1)) {
                this.compareType = CompareType.SAME_TYPE;
            } else {
                this.compareType = CompareType.NEED_CONVERT;
                TypeInfo compareType = FunctionRegistry.getCommonClassForComparison(oiTypeInfo0, oiTypeInfo1);
                this.compareOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(compareType == null ? TypeInfoFactory.doubleTypeInfo : compareType);
                this.converter0 = ObjectInspectorConverters.getConverter(arguments[0], this.compareOI);
                this.converter1 = ObjectInspectorConverters.getConverter(arguments[1], this.compareOI);
            }
        }
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    public Integer compare(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        Object o1 = arguments[1].get();
        if (o1 == null) {
            return null;
        }
        if (this.compareType == CompareType.NEED_CONVERT) {
            Object converted_o0 = this.converter0.convert(o0);
            if (converted_o0 == null) {
                return null;
            }
            Object converted_o1 = this.converter1.convert(o1);
            if (converted_o1 == null) {
                return null;
            }
            return ObjectInspectorUtils.compare(converted_o0, this.compareOI, converted_o1, this.compareOI);
        }
        return ObjectInspectorUtils.compare(o0, this.argumentOIs[0], o1, this.argumentOIs[1]);
    }

    public static enum CompareType {
        COMPARE_STRING,
        COMPARE_TEXT,
        COMPARE_INT,
        COMPARE_LONG,
        COMPARE_BYTE,
        COMPARE_BOOL,
        SAME_TYPE,
        NEED_CONVERT;

    }
}

