/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hive.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveProjectFilterPullUpConstantsRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveProjectFilterPullUpConstantsRule.class);
    public static final HiveProjectFilterPullUpConstantsRule INSTANCE = new HiveProjectFilterPullUpConstantsRule(HiveProject.class, HiveFilter.class, HiveRelFactories.HIVE_BUILDER);

    public HiveProjectFilterPullUpConstantsRule(Class<? extends Project> projectClass, Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory) {
        super(HiveProjectFilterPullUpConstantsRule.operand(projectClass, HiveProjectFilterPullUpConstantsRule.operand(filterClass, HiveProjectFilterPullUpConstantsRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(1);
        RexNode condition = filterRel.getCondition();
        if (!HiveCalciteUtil.isDeterministic(condition)) {
            return false;
        }
        return super.matches(call);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Filter filter = (Filter)call.rel(1);
        RelBuilder builder = call.builder();
        List<RexNode> projects = project.getChildExps();
        List<RexNode> newProjects = HiveProjectFilterPullUpConstantsRule.rewriteProjects(projects, filter.getCondition(), builder);
        if (newProjects == null) {
            return;
        }
        RelNode newProjRel = builder.push(filter).project(newProjects, project.getRowType().getFieldNames()).build();
        call.transformTo(newProjRel);
    }

    private static List<RexNode> rewriteProjects(List<RexNode> projects, RexNode newPushedCondition, RelBuilder relBuilder) {
        List<RexNode> conjunctions = RelOptUtil.conjunctions(newPushedCondition);
        HashMap<String, RexNode> conditions = new HashMap<String, RexNode>();
        for (RexNode conjunction : conjunctions) {
            if (!(conjunction instanceof RexCall)) continue;
            RexCall conjCall = (RexCall)conjunction;
            switch (conjCall.getOperator().getKind()) {
                case EQUALS: {
                    if (!RexUtil.isConstant((RexNode)conjCall.operands.get(0)) && RexUtil.isConstant((RexNode)conjCall.operands.get(1))) {
                        conditions.put(((RexNode)conjCall.operands.get(0)).toString(), (RexNode)conjCall.operands.get(1));
                        break;
                    }
                    if (RexUtil.isConstant((RexNode)conjCall.operands.get(1)) || !RexUtil.isConstant((RexNode)conjCall.operands.get(0))) break;
                    conditions.put(((RexNode)conjCall.operands.get(1)).toString(), (RexNode)conjCall.operands.get(0));
                    break;
                }
                case IS_NULL: {
                    conditions.put(((RexNode)conjCall.operands.get(0)).toString(), relBuilder.getRexBuilder().makeNullLiteral(((RexNode)conjCall.operands.get(0)).getType().getSqlTypeName()));
                }
            }
        }
        RexReplacer replacer = new RexReplacer(relBuilder.getRexBuilder(), conditions);
        ArrayList<RexNode> newProjects = Lists.newArrayList(projects);
        replacer.mutate(newProjects);
        if (replacer.replaced) {
            return newProjects;
        }
        return null;
    }

    protected static class RexReplacer
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final Map<String, RexNode> replacements;
        private boolean replaced;

        RexReplacer(RexBuilder rexBuilder, Map<String, RexNode> replacements) {
            this.rexBuilder = rexBuilder;
            this.replacements = replacements;
            this.replaced = false;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RexNode node = this.visit(inputRef);
            if (node == null) {
                return super.visitInputRef(inputRef);
            }
            this.replaced = true;
            return node;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode node = this.visit(call);
            if (node != null) {
                this.replaced = true;
                return node;
            }
            return super.visitCall(call);
        }

        private RexNode visit(RexNode call) {
            RexNode replacement = this.replacements.get(call.toString());
            if (replacement == null) {
                return null;
            }
            if (replacement.getType().equals(call.getType())) {
                return replacement;
            }
            return this.rexBuilder.makeCast(call.getType(), replacement, true);
        }
    }
}

