/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveSortProjectTransposeRule
extends RelOptRule {
    public static final HiveSortProjectTransposeRule INSTANCE = new HiveSortProjectTransposeRule();

    private HiveSortProjectTransposeRule() {
        super(HiveSortProjectTransposeRule.operand(HiveSortLimit.class, HiveSortProjectTransposeRule.operand(HiveProject.class, HiveSortProjectTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    protected HiveSortProjectTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        return HiveCalciteUtil.limitRelNode(sortLimit);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        HiveSortLimit sort = (HiveSortLimit)call.rel(0);
        HiveProject project = (HiveProject)call.rel(1);
        Mappings.TargetMapping map = RelOptUtil.permutation(project.getProjects(), project.getInput().getRowType());
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            if (map.getTargetOpt(fc.getFieldIndex()) >= 0) continue;
            return;
        }
        RelCollation newCollation = RelCollationTraitDef.INSTANCE.canonize(RexUtil.apply(map, sort.getCollation()));
        HiveSortLimit newSort = sort.copy(sort.getTraitSet().replace(newCollation), project.getInput(), newCollation, sort.offset, sort.fetch);
        RelNode newProject = project.copy(sort.getTraitSet(), ImmutableList.of(newSort));
        call.transformTo(newProject);
    }
}

