/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.hooks.MetricsQueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements CommandProcessor {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private Runnable shutdownRunner = null;
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private final HiveConf conf;
    private final boolean isParallelEnabled;
    private DataInput resStream;
    private Context ctx;
    private DriverContext driverCxt;
    private QueryPlan plan;
    private Schema schema;
    private String errorMessage;
    private String SQLState;
    private Throwable downstreamError;
    private FetchTask fetchTask;
    List<HiveLock> hiveLocks = new ArrayList<HiveLock>();
    private Set<FileSinkDesc> acidSinks;
    private boolean acidInQuery;
    private int maxthreads;
    private int tryCount = Integer.MAX_VALUE;
    private String userName;
    private String operationId;
    private final QueryDisplay queryDisplay = new QueryDisplay();
    private LockedDriverState lDrvState = new LockedDriverState();
    private QueryState queryState;
    private List<QueryLifeTimeHook> queryHooks;
    private static final ReentrantLock globalCompileLock = new ReentrantLock();

    private boolean checkConcurrency() {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (!supportConcurrency) {
            LOG.info("Concurrency mode is disabled, not creating a lock manager");
            return false;
        }
        return true;
    }

    @Override
    public void init() {
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info("Returning cluster status: " + cs.toString());
        return cs;
    }

    public Schema getSchema() {
        return this.schema;
    }

    private static Schema getSchema(BaseSemanticAnalyzer sem, HiveConf conf) {
        Schema schema = null;
        if (sem != null) {
            if (sem.getResultSchema() != null) {
                List<FieldSchema> lst = sem.getResultSchema();
                schema = new Schema(lst, null);
            } else if (sem.getFetchTask() != null) {
                FetchTask ft = sem.getFetchTask();
                TableDesc td = ft.getTblDesc();
                if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    LOG.info("No returning schema.");
                } else {
                    String tableName = "result";
                    List<FieldSchema> lst = null;
                    try {
                        lst = MetaStoreUtils.getFieldsFromDeserializer(tableName, td.getDeserializer(conf));
                    }
                    catch (Exception e) {
                        LOG.warn("Error getting schema: " + StringUtils.stringifyException((Throwable)e));
                    }
                    if (lst != null) {
                        schema = new Schema(lst, null);
                    }
                }
            }
        }
        if (schema == null) {
            schema = new Schema();
        }
        LOG.info("Returning Hive schema: " + schema);
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List<FieldSchema> lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(MetaStoreUtils.typeToThriftType(f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info("Returning Thrift schema: " + schema);
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public Driver() {
        this(new QueryState(SessionState.get() != null ? SessionState.get().getConf() : new HiveConf()), null);
    }

    public Driver(HiveConf conf) {
        this(new QueryState(conf), null);
    }

    public Driver(HiveConf conf, Context ctx) {
        this(new QueryState(conf), null);
        this.ctx = ctx;
    }

    public Driver(HiveConf conf, String userName) {
        this(new QueryState(conf), userName);
    }

    public Driver(QueryState queryState, String userName) {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.isParallelEnabled = this.conf != null && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION);
        this.userName = userName;
    }

    public int compile(String command) {
        return this.compile(command, true);
    }

    public int compile(String command, boolean resetTaskIds) {
        return this.compile(command, resetTaskIds, false);
    }

    /*
     * Exception decompiling
     */
    public int compile(String command, boolean resetTaskIds, boolean deferClose) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [30[CATCHBLOCK], 33[CATCHBLOCK], 8[TRYBLOCK]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int handleInterruption(String msg) {
        this.SQLState = "HY008";
        this.errorMessage = "FAILED: command has been interrupted: " + msg;
        console.printError(this.errorMessage);
        return 1000;
    }

    private boolean isInterrupted() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private List<QueryLifeTimeHook> loadQueryHooks() throws Exception {
        List<QueryLifeTimeHook> propertyDefinedHoooks;
        ArrayList<QueryLifeTimeHook> hooks = new ArrayList<QueryLifeTimeHook>();
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED)) {
            hooks.add(new MetricsQueryLifeTimeHook());
        }
        if ((propertyDefinedHoooks = this.getHooks(HiveConf.ConfVars.HIVE_QUERY_LIFETIME_HOOKS, QueryLifeTimeHook.class)) != null) {
            Iterables.addAll(hooks, propertyDefinedHoooks);
        }
        return hooks;
    }

    private ImmutableMap<String, Long> dumpMetaCallTimingWithoutEx(String phase) {
        try {
            return Hive.get().dumpAndClearMetaCallTiming(phase);
        }
        catch (HiveException he) {
            LOG.warn("Caught exception attempting to write metadata call information " + he, he);
            return null;
        }
    }

    private String getExplainOutput(BaseSemanticAnalyzer sem, QueryPlan plan, ASTNode astTree) throws IOException {
        String ret = null;
        ExplainTask task = new ExplainTask();
        task.initialize(this.queryState, plan, null, this.ctx.getOpContext());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            List<Task<?>> rootTasks = sem.getAllRootTasks();
            task.getJSONPlan(ps, rootTasks, sem.getFetchTask(), false, true, true);
            ret = baos.toString();
        }
        catch (Exception e) {
            LOG.warn("Exception generating explain output: " + e, e);
        }
        return ret;
    }

    public static void doAuthorization(HiveOperation op, BaseSemanticAnalyzer sem, String command) throws HiveException, AuthorizationException {
        Object isa;
        SessionState ss = SessionState.get();
        Hive db = sem.getDb();
        HashSet<ReadEntity> additionalInputs = new HashSet<ReadEntity>();
        for (Entity entity : sem.getInputs()) {
            if (entity.getType() != Entity.Type.PARTITION) continue;
            additionalInputs.add(new ReadEntity(entity.getTable()));
        }
        HashSet<WriteEntity> additionalOutputs = new HashSet<WriteEntity>();
        for (WriteEntity e : sem.getOutputs()) {
            if (e.getType() != Entity.Type.PARTITION) continue;
            additionalOutputs.add(new WriteEntity(e.getTable(), e.getWriteType()));
        }
        Sets.SetView<ReadEntity> setView = Sets.union(sem.getInputs(), additionalInputs);
        Sets.SetView<WriteEntity> outputs = Sets.union(sem.getOutputs(), additionalOutputs);
        if (ss.isAuthorizationModeV2()) {
            ColumnAccessInfo colAccessInfo = sem.getColumnAccessInfo();
            Map<String, List<String>> selectTab2Cols = colAccessInfo != null ? colAccessInfo.getTableToColumnAccessMap() : null;
            Map<String, List<String>> updateTab2Cols = sem.getUpdateColumnAccessInfo() != null ? sem.getUpdateColumnAccessInfo().getTableToColumnAccessMap() : null;
            Driver.doAuthorizationV2(ss, op, setView, outputs, command, selectTab2Cols, updateTab2Cols);
            return;
        }
        if (op == null) {
            throw new HiveException("Operation should not be null");
        }
        HiveAuthorizationProvider authorizer = ss.getAuthorizer();
        if (op.equals((Object)HiveOperation.CREATEDATABASE)) {
            authorizer.authorize(op.getInputRequiredPrivileges(), op.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.CREATETABLE)) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.IMPORT) && !((ImportSemanticAnalyzer)(isa = (ImportSemanticAnalyzer)sem)).existsTable()) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        }
        if (outputs != null && outputs.size() > 0) {
            for (WriteEntity write : outputs) {
                Partition part;
                if (write.isDummy() || write.isPathType()) continue;
                if (write.getType() == Entity.Type.DATABASE) {
                    if (op.equals((Object)HiveOperation.IMPORT)) continue;
                    authorizer.authorize(write.getDatabase(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getType() == Entity.Type.PARTITION && (part = db.getPartition(write.getTable(), write.getPartition().getSpec(), false)) != null) {
                    authorizer.authorize(write.getPartition(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getTable() == null) continue;
                authorizer.authorize(write.getTable(), null, op.getOutputRequiredPrivileges());
            }
        }
        if (setView != null && setView.size() > 0) {
            HashMap<Table, List<String>> tab2Cols = new HashMap<Table, List<String>>();
            HashMap<Partition, List<String>> part2Cols = new HashMap<Partition, List<String>>();
            HashMap<String, Boolean> tableUsePartLevelAuth = new HashMap<String, Boolean>();
            for (ReadEntity read : setView) {
                boolean usePartLevelPriv;
                String tblName;
                if (read.isDummy() || read.isPathType() || read.getType() == Entity.Type.DATABASE) continue;
                Table tbl = read.getTable();
                if (read.getPartition() == null && (tbl == null || !tbl.isPartitioned()) || tableUsePartLevelAuth.get(tblName = tbl.getTableName()) != null) continue;
                boolean bl = usePartLevelPriv = tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE") != null && "TRUE".equalsIgnoreCase(tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"));
                if (usePartLevelPriv) {
                    tableUsePartLevelAuth.put(tblName, Boolean.TRUE);
                    continue;
                }
                tableUsePartLevelAuth.put(tblName, Boolean.FALSE);
            }
            Driver.getTablePartitionUsedColumns(op, sem, tab2Cols, part2Cols, tableUsePartLevelAuth);
            HashSet<String> tableAuthChecked = new HashSet<String>();
            for (ReadEntity read : setView) {
                Partition partition;
                if (read.isDummy() || read.isPathType() || !read.isDirect()) continue;
                if (read.getType() == Entity.Type.DATABASE) {
                    authorizer.authorize(read.getDatabase(), op.getInputRequiredPrivileges(), null);
                    continue;
                }
                Table tbl = read.getTable();
                if (tbl.isView() && sem instanceof SemanticAnalyzer) {
                    tab2Cols.put(tbl, sem.getColumnAccessInfo().getTableToColumnAccessMap().get(tbl.getCompleteName()));
                }
                if (read.getPartition() != null && Boolean.TRUE.equals(tableUsePartLevelAuth.get((tbl = (partition = read.getPartition()).getTable()).getTableName()))) {
                    List cols = (List)part2Cols.get(partition);
                    if (cols != null && cols.size() > 0) {
                        authorizer.authorize(partition.getTable(), partition, cols, op.getInputRequiredPrivileges(), null);
                        continue;
                    }
                    authorizer.authorize(partition, op.getInputRequiredPrivileges(), null);
                    continue;
                }
                if (tbl == null || tableAuthChecked.contains(tbl.getTableName()) || Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) continue;
                List cols = (List)tab2Cols.get(tbl);
                if (cols != null && cols.size() > 0) {
                    authorizer.authorize(tbl, null, cols, op.getInputRequiredPrivileges(), null);
                } else {
                    authorizer.authorize(tbl, op.getInputRequiredPrivileges(), null);
                }
                tableAuthChecked.add(tbl.getTableName());
            }
        }
    }

    private static void getTablePartitionUsedColumns(HiveOperation op, BaseSemanticAnalyzer sem, Map<Table, List<String>> tab2Cols, Map<Partition, List<String>> part2Cols, Map<String, Boolean> tableUsePartLevelAuth) throws HiveException {
        if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.QUERY)) {
            SemanticAnalyzer querySem = (SemanticAnalyzer)sem;
            ParseContext parseCtx = querySem.getParseContext();
            for (Map.Entry<String, TableScanOperator> topOpMap : querySem.getParseContext().getTopOps().entrySet()) {
                TableScanOperator tableScanOp = topOpMap.getValue();
                if (tableScanOp.isInsideView()) continue;
                Table tbl = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata();
                List<Integer> neededColumnIds = tableScanOp.getNeededColumnIDs();
                List<FieldSchema> columns = tbl.getCols();
                ArrayList<String> cols = new ArrayList<String>();
                for (int i = 0; i < neededColumnIds.size(); ++i) {
                    cols.add(columns.get(neededColumnIds.get(i)).getName());
                }
                if (tbl.isPartitioned() && Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) {
                    String alias_id = topOpMap.getKey();
                    PrunedPartitionList partsList = PartitionPruner.prune(tableScanOp, parseCtx, alias_id);
                    Set<Partition> parts = partsList.getPartitions();
                    for (Partition part : parts) {
                        List<String> existingCols = part2Cols.get(part);
                        if (existingCols == null) {
                            existingCols = new ArrayList<String>();
                        }
                        existingCols.addAll(cols);
                        part2Cols.put(part, existingCols);
                    }
                    continue;
                }
                List<String> existingCols = tab2Cols.get(tbl);
                if (existingCols == null) {
                    existingCols = new ArrayList<String>();
                }
                existingCols.addAll(cols);
                tab2Cols.put(tbl, existingCols);
            }
        }
    }

    private static void doAuthorizationV2(SessionState ss, HiveOperation op, Set<ReadEntity> inputs, Set<WriteEntity> outputs, String command, Map<String, List<String>> tab2cols, Map<String, List<String>> updateTab2Cols) throws HiveException {
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        authzContextBuilder.setCommandString(command);
        HiveOperationType hiveOpType = Driver.getHiveOperationType(op);
        List<HivePrivilegeObject> inputsHObjs = Driver.getHivePrivObjects(inputs, tab2cols);
        List<HivePrivilegeObject> outputHObjs = Driver.getHivePrivObjects(outputs, updateTab2Cols);
        ss.getAuthorizerV2().checkPrivileges(hiveOpType, inputsHObjs, outputHObjs, authzContextBuilder.build());
    }

    private static List<HivePrivilegeObject> getHivePrivObjects(Set<? extends Entity> privObjects, Map<String, List<String>> tableName2Cols) {
        ArrayList<HivePrivilegeObject> hivePrivobjs = new ArrayList<HivePrivilegeObject>();
        if (privObjects == null) {
            return hivePrivobjs;
        }
        block7: for (Entity entity : privObjects) {
            HivePrivilegeObject.HivePrivilegeObjectType privObjType = AuthorizationUtils.getHivePrivilegeObjectType(entity.getType());
            if (entity.isDummy() || entity instanceof ReadEntity && !((ReadEntity)entity).isDirect() || entity instanceof WriteEntity && ((WriteEntity)entity).isTempURI()) continue;
            String dbname = null;
            String objName = null;
            List<String> partKeys = null;
            List<String> columns = null;
            switch (entity.getType()) {
                case DATABASE: {
                    dbname = entity.getDatabase().getName();
                    break;
                }
                case TABLE: {
                    dbname = entity.getTable().getDbName();
                    objName = entity.getTable().getTableName();
                    columns = tableName2Cols == null ? null : tableName2Cols.get(Table.getCompleteName(dbname, objName));
                    break;
                }
                case DFS_DIR: 
                case LOCAL_DIR: {
                    objName = entity.getD().toString();
                    break;
                }
                case FUNCTION: {
                    if (entity.getDatabase() != null) {
                        dbname = entity.getDatabase().getName();
                    }
                    objName = entity.getFunctionName();
                    break;
                }
                case DUMMYPARTITION: 
                case PARTITION: {
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected object type");
                }
            }
            HivePrivilegeObject.HivePrivObjectActionType actionType = AuthorizationUtils.getActionType(entity);
            HivePrivilegeObject hPrivObject = new HivePrivilegeObject(privObjType, dbname, objName, partKeys, columns, actionType, null);
            hivePrivobjs.add(hPrivObject);
        }
        return hivePrivobjs;
    }

    private static HiveOperationType getHiveOperationType(HiveOperation op) {
        return HiveOperationType.valueOf(op.name());
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    private void recordValidTxns() throws LockException {
        HiveTxnManager txnMgr = SessionState.get().getTxnMgr();
        ValidTxnList txns = txnMgr.getValidTxns();
        String txnStr = txns.toString();
        this.conf.set("hive.txn.valid.txns", txnStr);
        if (this.plan.getFetchTask() != null) {
            this.plan.getFetchTask().setValidTxnList(txnStr);
        }
        LOG.debug("Encoding valid txns info " + txnStr + " txnid:" + txnMgr.getCurrentTxnId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireLocksAndOpenTxn(boolean startTxnImplicitly) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "acquireReadWriteLocks");
        SessionState ss = SessionState.get();
        HiveTxnManager txnMgr = ss.getTxnMgr();
        if (startTxnImplicitly) assert (!txnMgr.getAutoCommit());
        try {
            String userFromUGI;
            try {
                userFromUGI = this.conf.getUser();
            }
            catch (IOException e) {
                this.errorMessage = "FAILED: Error in determining user while acquiring locks: " + e.getMessage();
                this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                this.downstreamError = e;
                console.printError(this.errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
                int n = 10;
                perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
                return n;
            }
            boolean initiatingTransaction = false;
            boolean readOnlyQueryInAutoCommit = false;
            if (txnMgr.getAutoCommit() && this.haveAcidWrite() || this.plan.getOperation() == HiveOperation.START_TRANSACTION || !txnMgr.getAutoCommit() && startTxnImplicitly) {
                if (txnMgr.isTxnOpen()) {
                    throw new RuntimeException("Already have an open transaction txnid:" + txnMgr.getCurrentTxnId());
                }
                txnMgr.openTxn(this.ctx, userFromUGI);
                initiatingTransaction = true;
            } else {
                boolean bl = readOnlyQueryInAutoCommit = txnMgr.getAutoCommit() && this.plan.getOperation() == HiveOperation.QUERY && !this.haveAcidWrite();
            }
            if (this.haveAcidWrite()) {
                for (FileSinkDesc desc : this.acidSinks) {
                    desc.setTransactionId(txnMgr.getCurrentTxnId());
                    desc.setStatementId(txnMgr.getWriteIdAndIncrement());
                }
            }
            txnMgr.acquireLocks(this.plan, this.ctx, userFromUGI, this.lDrvState);
            if (initiatingTransaction || readOnlyQueryInAutoCommit && this.acidInQuery) {
                this.recordValidTxns();
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
            int n = 10;
            return n;
        }
        finally {
            perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
        }
    }

    private boolean haveAcidWrite() {
        return this.acidSinks != null && !this.acidSinks.isEmpty();
    }

    private void releaseLocksAndCommitOrRollback(boolean commit, HiveTxnManager txnManager) throws LockException {
        HiveTxnManager txnMgr;
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "releaseLocks");
        if (txnManager == null) {
            SessionState ss = SessionState.get();
            txnMgr = ss.getTxnMgr();
        } else {
            txnMgr = txnManager;
        }
        if (txnMgr.isTxnOpen()) {
            if (commit) {
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN)) {
                    txnMgr.rollbackTxn();
                } else {
                    txnMgr.commitTxn();
                }
            } else {
                txnMgr.rollbackTxn();
            }
        } else {
            if (this.ctx != null && this.ctx.getHiveLocks() != null) {
                this.hiveLocks.addAll(this.ctx.getHiveLocks());
            }
            txnMgr.releaseLocks(this.hiveLocks);
        }
        this.hiveLocks.clear();
        if (this.ctx != null) {
            this.ctx.setHiveLocks(null);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "releaseLocks");
    }

    private void releaseResources() {
        this.releasePlan();
        this.releaseDriverContext();
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().clear();
        }
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandNeedRetryException {
        return this.run(command, false);
    }

    public CommandProcessorResponse run() throws CommandNeedRetryException {
        return this.run(null, true);
    }

    public CommandProcessorResponse run(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        CommandProcessorResponse cpr = this.runInternal(command, alreadyCompiled);
        if (cpr.getResponseCode() == 0) {
            return cpr;
        }
        SessionState ss = SessionState.get();
        if (ss == null) {
            return cpr;
        }
        MetaDataFormatter mdf = MetaDataFormatUtils.getFormatter(ss.getConf());
        if (!(mdf instanceof JsonMetaDataFormatter)) {
            return cpr;
        }
        try {
            if (this.downstreamError == null) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState);
                return cpr;
            }
            ErrorMsg canonicalErr = ErrorMsg.getErrorMsg(cpr.getResponseCode());
            if (canonicalErr != null && canonicalErr != ErrorMsg.GENERIC_ERROR) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState, null);
                return cpr;
            }
            if (this.downstreamError instanceof HiveException) {
                HiveException rc = (HiveException)this.downstreamError;
                mdf.error(ss.out, this.errorMessage, rc.getCanonicalErrorMsg().getErrorCode(), this.SQLState, rc.getCanonicalErrorMsg() == ErrorMsg.GENERIC_ERROR ? StringUtils.stringifyException((Throwable)rc) : null);
            } else {
                ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg(this.downstreamError.getMessage());
                mdf.error(ss.out, this.errorMessage, canonicalMsg.getErrorCode(), this.SQLState, StringUtils.stringifyException((Throwable)this.downstreamError));
            }
        }
        catch (HiveException ex) {
            console.printError("Unable to JSON-encode the error", StringUtils.stringifyException((Throwable)ex));
        }
        return cpr;
    }

    public CommandProcessorResponse compileAndRespond(String command) {
        return this.createProcessorResponse(this.compileInternal(command, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compileInternal(String command, boolean deferClose) {
        int ret;
        ReentrantLock compileLock;
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            metrics.incrementCounter("waiting_compile_ops", 1L);
        }
        if ((compileLock = this.tryAcquireCompileLock(this.isParallelEnabled, command)) == null) {
            return ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode();
        }
        try {
            if (metrics != null) {
                metrics.decrementCounter("waiting_compile_ops", 1L);
            }
            ret = this.compile(command, true, deferClose);
        }
        finally {
            compileLock.unlock();
        }
        if (ret != 0) {
            try {
                this.releaseLocksAndCommitOrRollback(false, null);
            }
            catch (LockException e) {
                LOG.warn("Exception in releasing locks. " + StringUtils.stringifyException((Throwable)e));
            }
        }
        PerfLogger perfLogger = SessionState.getPerfLogger();
        this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.COMPILATION, perfLogger.getStartTimes());
        this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.COMPILATION, perfLogger.getEndTimes());
        return ret;
    }

    private ReentrantLock tryAcquireCompileLock(boolean isParallelEnabled, String command) {
        OperationLog ol;
        ReentrantLock compileLock;
        block12: {
            compileLock = isParallelEnabled ? SessionState.get().getCompileLock() : globalCompileLock;
            long maxCompileLockWaitTime = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, TimeUnit.SECONDS);
            String lockAcquiredMsg = "Acquired the compile lock.";
            try {
                if (compileLock.tryLock(0L, TimeUnit.SECONDS)) {
                    LOG.debug("Acquired the compile lock.");
                    return compileLock;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interrupted Exception ignored", e);
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting to acquire compile lock: " + command);
            }
            if ((ol = OperationLog.getCurrentOperationLog()) != null) {
                ol.writeOperationLog(OperationLog.LoggingLevel.EXECUTION, "Waiting to acquire compile lock.\n");
            }
            if (maxCompileLockWaitTime > 0L) {
                try {
                    if (!compileLock.tryLock(maxCompileLockWaitTime, TimeUnit.SECONDS)) {
                        this.errorMessage = ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCodedMsg();
                        LOG.error(this.errorMessage + ": " + command);
                        return null;
                    }
                    break block12;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Interrupted Exception ignored", e);
                    }
                    return null;
                }
            }
            compileLock.lock();
        }
        LOG.debug("Acquired the compile lock.");
        if (ol != null) {
            ol.writeOperationLog(OperationLog.LoggingLevel.EXECUTION, "Acquired the compile lock.\n");
        }
        return compileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private CommandProcessorResponse runInternal(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        block115: {
            block106: {
                block101: {
                    block114: {
                        block102: {
                            block98: {
                                block113: {
                                    block99: {
                                        block96: {
                                            block93: {
                                                block112: {
                                                    block94: {
                                                        block90: {
                                                            block111: {
                                                                block91: {
                                                                    block87: {
                                                                        block110: {
                                                                            block88: {
                                                                                block84: {
                                                                                    block109: {
                                                                                        block85: {
                                                                                            this.errorMessage = null;
                                                                                            this.SQLState = null;
                                                                                            this.downstreamError = null;
                                                                                            this.lDrvState.stateLock.lock();
                                                                                            try {
                                                                                                if (!alreadyCompiled) ** GOTO lbl14
                                                                                                if (this.lDrvState.driverState == DriverState.COMPILED) {
                                                                                                    this.lDrvState.driverState = DriverState.EXECUTING;
                                                                                                } else {
                                                                                                    this.errorMessage = "FAILED: Precompiled query has been cancelled or closed.";
                                                                                                    Driver.console.printError(this.errorMessage);
                                                                                                    var3_3 = this.createProcessorResponse(12);
                                                                                                    return var3_3;
lbl14:
                                                                                                    // 1 sources

                                                                                                    this.lDrvState.driverState = DriverState.COMPILING;
                                                                                                }
                                                                                            }
                                                                                            finally {
                                                                                                this.lDrvState.stateLock.unlock();
                                                                                            }
                                                                                            isFinishedWithError = true;
                                                                                            hookContext = new HiveDriverRunHookContextImpl(this.conf, alreadyCompiled != false ? this.ctx.getCmd() : command);
                                                                                            try {
                                                                                                driverRunHooks = this.getHooks(HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, HiveDriverRunHook.class);
                                                                                                for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                                                                                                    driverRunHook.preDriverRun(hookContext);
                                                                                                }
                                                                                            }
                                                                                            catch (Exception e) {
                                                                                                this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                                                                                                this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                                                                                                this.downstreamError = e;
                                                                                                Driver.console.printError(this.errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
                                                                                                driverRunHook = this.createProcessorResponse(12);
                                                                                                if (this.isInterrupted()) {
                                                                                                    this.closeInProcess(true);
                                                                                                } else {
                                                                                                    this.releaseResources();
                                                                                                }
                                                                                                this.lDrvState.stateLock.lock();
                                                                                                try {
                                                                                                    this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                                                                                                }
                                                                                                finally {
                                                                                                    this.lDrvState.stateLock.unlock();
                                                                                                }
                                                                                                return driverRunHook;
                                                                                            }
                                                                                            perfLogger = null;
                                                                                            if (alreadyCompiled) break block84;
                                                                                            ret = this.compileInternal(command, true);
                                                                                            perfLogger = SessionState.getPerfLogger();
                                                                                            if (ret == 0) ** GOTO lbl76
                                                                                            var8_16 = this.createProcessorResponse(ret);
                                                                                            if (!this.isInterrupted()) break block85;
                                                                                            this.closeInProcess(true);
                                                                                            break block109;
                                                                                        }
                                                                                        this.releaseResources();
                                                                                    }
                                                                                    this.lDrvState.stateLock.lock();
                                                                                    try {
                                                                                        this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                                                                                    }
                                                                                    finally {
                                                                                        this.lDrvState.stateLock.unlock();
                                                                                    }
                                                                                    return var8_16;
                                                                                }
                                                                                perfLogger = SessionState.getPerfLogger();
                                                                                this.plan.setQueryStartTime(perfLogger.getStartTime("Driver.run"));
lbl76:
                                                                                // 2 sources

                                                                                txnManager = SessionState.get().getTxnMgr();
                                                                                this.ctx.setHiveTxnManager(txnManager);
                                                                                startTxnImplicitly = false;
                                                                                if (!txnManager.isTxnOpen() || this.plan.getOperation().isAllowedInTransaction()) break block87;
                                                                                if (!Driver.$assertionsDisabled && txnManager.getAutoCommit()) {
                                                                                    throw new AssertionError((Object)"didn't expect AC=true");
                                                                                }
                                                                                var10_20 = this.rollback(new CommandProcessorResponse(12, ErrorMsg.OP_NOT_ALLOWED_IN_TXN, null, new String[]{this.plan.getOperationName(), Long.toString(txnManager.getCurrentTxnId())}));
                                                                                if (!this.isInterrupted()) break block88;
                                                                                this.closeInProcess(true);
                                                                                break block110;
                                                                            }
                                                                            this.releaseResources();
                                                                        }
                                                                        this.lDrvState.stateLock.lock();
                                                                        try {
                                                                            this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                                                                        }
                                                                        finally {
                                                                            this.lDrvState.stateLock.unlock();
                                                                        }
                                                                        return var10_20;
                                                                    }
                                                                    if (txnManager.isTxnOpen() || !this.plan.getOperation().isRequiresOpenTransaction()) break block90;
                                                                    var10_21 = this.rollback(new CommandProcessorResponse(12, ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN, null, new String[]{this.plan.getOperationName()}));
                                                                    if (!this.isInterrupted()) break block91;
                                                                    this.closeInProcess(true);
                                                                    break block111;
                                                                }
                                                                this.releaseResources();
                                                            }
                                                            this.lDrvState.stateLock.lock();
                                                            try {
                                                                this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                                                            }
                                                            finally {
                                                                this.lDrvState.stateLock.unlock();
                                                            }
                                                            return var10_21;
                                                        }
                                                        if (!txnManager.isTxnOpen() && this.plan.getOperation() == HiveOperation.QUERY && !txnManager.getAutoCommit()) {
                                                            startTxnImplicitly = true;
                                                        }
                                                        if (!txnManager.getAutoCommit() || this.plan.getOperation() != HiveOperation.START_TRANSACTION) break block93;
                                                        var10_22 = this.rollback(new CommandProcessorResponse(12, ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT, null, new String[]{this.plan.getOperationName()}));
                                                        if (!this.isInterrupted()) break block94;
                                                        this.closeInProcess(true);
                                                        break block112;
                                                    }
                                                    this.releaseResources();
                                                }
                                                this.lDrvState.stateLock.lock();
                                                try {
                                                    this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                                                }
                                                finally {
                                                    this.lDrvState.stateLock.unlock();
                                                }
                                                return var10_22;
                                            }
                                            if (this.plan.getOperation() != HiveOperation.SET_AUTOCOMMIT) break block96;
                                            try {
                                                if (this.plan.getAutoCommitValue().booleanValue() && !txnManager.getAutoCommit()) {
                                                    this.releaseLocksAndCommitOrRollback(true, null);
                                                    txnManager.setAutoCommit(true);
                                                } else if (!this.plan.getAutoCommitValue().booleanValue() && txnManager.getAutoCommit()) {
                                                    txnManager.setAutoCommit(false);
                                                }
                                            }
                                            catch (LockException e) {
                                                var11_30 = this.handleHiveException(e, 12);
                                                if (this.isInterrupted()) {
                                                    this.closeInProcess(true);
                                                } else {
                                                    this.releaseResources();
                                                }
                                                this.lDrvState.stateLock.lock();
                                                try {
                                                    this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                                                }
                                                finally {
                                                    this.lDrvState.stateLock.unlock();
                                                }
                                                return var11_30;
                                            }
                                        }
                                        if (!this.requiresLock() || (ret = this.isInterrupted() != false ? this.handleInterruption("at acquiring the lock.") : this.acquireLocksAndOpenTxn(startTxnImplicitly)) == 0) break block98;
                                        e = this.rollback(this.createProcessorResponse(ret));
                                        if (!this.isInterrupted()) break block99;
                                        this.closeInProcess(true);
                                        break block113;
                                    }
                                    this.releaseResources();
                                }
                                this.lDrvState.stateLock.lock();
                                try {
                                    this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                                }
                                finally {
                                    this.lDrvState.stateLock.unlock();
                                }
                                return e;
                            }
                            ret = this.execute(true);
                            if (ret == 0) break block101;
                            e = this.rollback(this.createProcessorResponse(ret));
                            if (!this.isInterrupted()) break block102;
                            this.closeInProcess(true);
                            break block114;
                        }
                        this.releaseResources();
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                    return e;
                }
                try {
                    if (txnManager.getAutoCommit() || this.plan.getOperation() == HiveOperation.COMMIT) {
                        this.releaseLocksAndCommitOrRollback(true, null);
                    } else if (this.plan.getOperation() == HiveOperation.ROLLBACK) {
                        this.releaseLocksAndCommitOrRollback(false, null);
                    }
                }
                catch (LockException e) {
                    var11_31 = this.handleHiveException(e, 12);
                    if (this.isInterrupted()) {
                        this.closeInProcess(true);
                    } else {
                        this.releaseResources();
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                    return var11_31;
                }
                try {
                    perfLogger.PerfLogEnd(Driver.CLASS_NAME, "Driver.run");
                    this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.EXECUTION, perfLogger.getStartTimes());
                    this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.EXECUTION, perfLogger.getEndTimes());
                    try {
                        for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                            driverRunHook.postDriverRun(hookContext);
                        }
                    }
                    catch (Exception e) {
                        this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                        this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                        this.downstreamError = e;
                        Driver.console.printError(this.errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
                        var11_33 = this.createProcessorResponse(12);
                        if (this.isInterrupted()) {
                            this.closeInProcess(true);
                        } else {
                            this.releaseResources();
                        }
                        this.lDrvState.stateLock.lock();
                        try {
                            this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                        }
                        finally {
                            this.lDrvState.stateLock.unlock();
                        }
                        return var11_33;
                    }
                }
                catch (Throwable var20_42) {
                    if (this.isInterrupted()) {
                        this.closeInProcess(true);
                    } else {
                        this.releaseResources();
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                    throw var20_42;
                }
                isFinishedWithError = false;
                var10_27 = this.createProcessorResponse(ret);
                if (!this.isInterrupted()) break block106;
                this.closeInProcess(true);
                break block115;
            }
            this.releaseResources();
        }
        this.lDrvState.stateLock.lock();
        try {
            this.lDrvState.driverState = this.lDrvState.driverState == DriverState.INTERRUPT ? DriverState.ERROR : (isFinishedWithError != false ? DriverState.ERROR : DriverState.EXECUTED);
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        return var10_27;
    }

    private CommandProcessorResponse rollback(CommandProcessorResponse cpr) {
        try {
            this.releaseLocksAndCommitOrRollback(false, null);
        }
        catch (LockException e) {
            LOG.error("rollback() FAILED: " + cpr);
            this.handleHiveException(e, 12, "Additional info in hive.log at \"rollback() FAILED\"");
        }
        return cpr;
    }

    private CommandProcessorResponse handleHiveException(HiveException e, int ret) {
        return this.handleHiveException(e, ret, null);
    }

    private CommandProcessorResponse handleHiveException(HiveException e, int ret, String rootMsg) {
        this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
        if (rootMsg != null) {
            this.errorMessage = this.errorMessage + "\n" + rootMsg;
        }
        this.SQLState = e.getCanonicalErrorMsg() != null ? e.getCanonicalErrorMsg().getSQLState() : ErrorMsg.findSQLState(e.getMessage());
        this.downstreamError = e;
        console.printError(this.errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
        return this.createProcessorResponse(ret);
    }

    private boolean requiresLock() {
        if (!this.checkConcurrency()) {
            return false;
        }
        if (this.isExplicitLockOperation()) {
            return false;
        }
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY)) {
            return true;
        }
        LinkedList<Task<? extends Serializable>> taskQueue = new LinkedList<Task<? extends Serializable>>();
        taskQueue.addAll(this.plan.getRootTasks());
        while (taskQueue.peek() != null) {
            Task tsk = (Task)taskQueue.remove();
            if (tsk.requireLock()) {
                return true;
            }
            if (tsk instanceof ConditionalTask) {
                taskQueue.addAll(((ConditionalTask)tsk).getListTasks());
            }
            if (tsk.getChildTasks() == null) continue;
            taskQueue.addAll(tsk.getChildTasks());
        }
        return false;
    }

    private boolean isExplicitLockOperation() {
        HiveOperation currentOpt = this.plan.getOperation();
        if (currentOpt != null) {
            switch (currentOpt) {
                case LOCKDB: 
                case UNLOCKDB: 
                case LOCKTABLE: 
                case UNLOCKTABLE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private CommandProcessorResponse createProcessorResponse(int ret) {
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
        this.queryDisplay.setErrorMessage(this.errorMessage);
        return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState, this.downstreamError);
    }

    private List<Hook> getHooks(HiveConf.ConfVars hookConfVar) throws Exception {
        return this.getHooks(hookConfVar, Hook.class);
    }

    private <T extends Hook> List<T> getHooks(HiveConf.ConfVars hookConfVar, Class<T> clazz) throws Exception {
        try {
            return HookUtils.getHooks(this.conf, hookConfVar, clazz);
        }
        catch (ClassNotFoundException e) {
            console.printError(hookConfVar.varname + " Class not found:" + e.getMessage());
            throw e;
        }
    }

    public int execute() throws CommandNeedRetryException {
        return this.execute(false);
    }

    /*
     * Exception decompiling
     */
    public int execute(boolean deferClose) throws CommandNeedRetryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 61[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void releasePlan(QueryPlan plan) {
        this.lDrvState.stateLock.lock();
        try {
            if (plan != null) {
                plan.setDone();
                if (SessionState.get() != null) {
                    try {
                        SessionState.get().getHiveHistory().logPlanProgress(plan);
                    }
                    catch (Exception e) {
                        LOG.warn("Could not log query plan progress", e);
                    }
                }
            }
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private void setQueryDisplays(List<Task<? extends Serializable>> tasks) {
        if (tasks != null) {
            for (Task<? extends Serializable> task : tasks) {
                task.setQueryDisplay(this.queryDisplay);
                this.setQueryDisplays(task.getDependentTasks());
            }
        }
    }

    private void logMrWarning(int mrJobs) {
        if (mrJobs <= 0 || !"mr".equals(HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            return;
        }
        String warning = HiveConf.generateMrDeprecationWarning();
        LOG.warn(warning);
        warning = "WARNING: " + warning;
        console.printInfo(warning);
        OperationLog ol = OperationLog.getCurrentOperationLog();
        if (ol != null) {
            ol.writeOperationLog(OperationLog.LoggingLevel.EXECUTION, warning + "\n");
        }
    }

    private void setErrorMsgAndDetail(int exitVal, Throwable downstreamError, Task tsk) {
        this.downstreamError = downstreamError;
        this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
        if (downstreamError != null) {
            this.errorMessage = this.errorMessage + ". " + downstreamError.getMessage();
        } else {
            ErrorMsg em = ErrorMsg.getErrorMsg(exitVal);
            if (em != null) {
                this.errorMessage = this.errorMessage + ". " + em.getMsg();
            }
        }
    }

    private void invokeFailureHooks(PerfLogger perfLogger, HookContext hookContext, String errorMessage, Throwable exception) throws Exception {
        hookContext.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
        hookContext.setErrorMessage(errorMessage);
        hookContext.setException(exception);
        for (Hook ofh : this.getHooks(HiveConf.ConfVars.ONFAILUREHOOKS)) {
            perfLogger.PerfLogBegin(CLASS_NAME, "FailureHook." + ofh.getClass().getName());
            ((ExecuteWithHookContext)ofh).run(hookContext);
            perfLogger.PerfLogEnd(CLASS_NAME, "FailureHook." + ofh.getClass().getName());
        }
    }

    private TaskRunner launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, String jobname, int jobs, DriverContext cxt) throws HiveException {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask() && !(tsk instanceof ConditionalTask)) {
            if (noName) {
                this.conf.set("mapreduce.job.name", jobname + "(" + tsk.getId() + ")");
            }
            this.conf.set("mapreduce.workflow.node.name", tsk.getId());
            Utilities.setWorkflowAdjacencies(this.conf, this.plan);
            cxt.incCurJobNo(1);
            console.printInfo("Launching Job " + cxt.getCurJobNo() + " out of " + jobs);
        }
        tsk.initialize(this.queryState, this.plan, cxt, this.ctx.getOpContext());
        TaskResult tskRes = new TaskResult();
        TaskRunner tskRun = new TaskRunner(tsk, tskRes);
        cxt.launching(tskRun);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.isMapRedTask()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting task [" + tsk + "] in parallel");
            }
            tskRun.setOperationLog(OperationLog.getCurrentOperationLog());
            tskRun.start();
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting task [" + tsk + "] in serial mode");
            }
            tskRun.runSequential();
        }
        return tskRun;
    }

    public boolean isFetchingTable() {
        return this.fetchTask != null;
    }

    public boolean getResults(List res) throws IOException, CommandNeedRetryException {
        if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.CLOSED) {
            throw new IOException("FAILED: query has been cancelled, closed, or destroyed.");
        }
        if (this.isFetchingTable()) {
            if (((FetchWork)this.fetchTask.getWork()).isUsingThriftJDBCBinarySerDe()) {
                this.maxRows = 1;
            }
            this.fetchTask.setMaxRows(this.maxRows);
            return this.fetchTask.fetch(res);
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getLength() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getLength(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
                row = null;
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                return false;
            }
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    public void resetFetch() throws IOException {
        if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.CLOSED) {
            throw new IOException("FAILED: driver has been cancelled, closed or destroyed.");
        }
        if (this.isFetchingTable()) {
            try {
                this.fetchTask.clearFetch();
            }
            catch (Exception e) {
                throw new IOException("Error closing the current fetch task", e);
            }
            this.fetchTask.initialize(this.queryState, null, null, this.ctx.getOpContext());
        } else {
            this.ctx.resetStream();
            this.resStream = null;
        }
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    private void releaseDriverContext() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.driverCxt != null) {
                this.driverCxt.shutdown();
                this.driverCxt = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while shutting down the task runner", e);
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private void releasePlan() {
        try {
            if (this.plan != null) {
                this.fetchTask = this.plan.getFetchTask();
                if (this.fetchTask != null) {
                    this.fetchTask.setDriverContext(null);
                    this.fetchTask.setQueryPlan(null);
                }
            }
            this.plan = null;
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the Fetch task", e);
        }
    }

    private void releaseContext() {
        try {
            if (this.ctx != null) {
                this.ctx.clear();
                if (this.ctx.getHiveLocks() != null) {
                    this.hiveLocks.addAll(this.ctx.getHiveLocks());
                    this.ctx.setHiveLocks(null);
                }
                this.ctx = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the context ", e);
        }
    }

    private void releaseResStream() {
        try {
            if (this.resStream != null) {
                ((FSDataInputStream)this.resStream).close();
                this.resStream = null;
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while closing the resStream ", e);
        }
    }

    private void releaseFetchTask() {
        try {
            if (this.fetchTask != null) {
                this.fetchTask.clearFetch();
                this.fetchTask = null;
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while clearing the FetchTask ", e);
        }
    }

    private int closeInProcess(boolean destroyed) {
        this.releaseDriverContext();
        this.releasePlan();
        this.releaseFetchTask();
        this.releaseResStream();
        this.releaseContext();
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().clear();
        }
        if (destroyed) {
            if (!this.hiveLocks.isEmpty()) {
                try {
                    this.releaseLocksAndCommitOrRollback(false, null);
                }
                catch (LockException e) {
                    LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
                }
            }
            ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
        }
        return 0;
    }

    public int close() {
        this.lDrvState.stateLock.lock();
        try {
            this.releaseDriverContext();
            if (this.lDrvState.driverState == DriverState.COMPILING || this.lDrvState.driverState == DriverState.EXECUTING || this.lDrvState.driverState == DriverState.INTERRUPT) {
                this.lDrvState.driverState = DriverState.INTERRUPT;
                int n = 0;
                return n;
            }
            this.releasePlan();
            this.releaseFetchTask();
            this.releaseResStream();
            this.releaseContext();
            this.lDrvState.driverState = DriverState.CLOSED;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().clear();
        }
        return 0;
    }

    public void destroy() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.INTERRUPT) {
                return;
            }
            this.lDrvState.driverState = DriverState.DESTROYED;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        if (!this.hiveLocks.isEmpty()) {
            try {
                this.releaseLocksAndCommitOrRollback(false, null);
            }
            catch (LockException e) {
                LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
            }
        }
        ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    public QueryDisplay getQueryDisplay() {
        return this.queryDisplay;
    }

    public void setOperationId(String opId) {
        this.operationId = opId;
    }

    public void resetQueryState() {
        this.releaseResources();
        this.queryState = new QueryState(this.queryState.getConf());
    }

    public static class LockedDriverState {
        public final ReentrantLock stateLock = new ReentrantLock();
        public DriverState driverState = DriverState.INITIALIZED;
    }

    public static enum DriverState {
        INITIALIZED,
        COMPILING,
        COMPILED,
        EXECUTING,
        EXECUTED,
        INTERRUPT,
        CLOSED,
        DESTROYED,
        ERROR;

    }
}

