/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.hadoop.hive.llap.security.SecretManager;
import org.apache.hadoop.hive.llap.security.SigningSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapSignerImpl
implements LlapSigner {
    private static final Logger LOG = LoggerFactory.getLogger(LlapSignerImpl.class);
    private final SigningSecretManager secretManager;

    public LlapSignerImpl(Configuration conf, String clusterId) {
        assert (UserGroupInformation.isSecurityEnabled());
        this.secretManager = SecretManager.createSecretManager(conf, clusterId);
    }

    @VisibleForTesting
    public LlapSignerImpl(SigningSecretManager sm) {
        this.secretManager = sm;
    }

    @Override
    public LlapSigner.SignedMessage serializeAndSign(LlapSigner.Signable message) throws IOException {
        LlapSigner.SignedMessage result = new LlapSigner.SignedMessage();
        DelegationKey key = this.secretManager.getCurrentKey();
        message.setSignInfo(key.getKeyId());
        result.message = message.serialize();
        result.signature = this.secretManager.signWithKey(result.message, key);
        return result;
    }

    @Override
    public void checkSignature(byte[] message, byte[] signature, int keyId) throws SecurityException {
        byte[] expectedSignature = this.secretManager.signWithKey(message, keyId);
        if (Arrays.equals(signature, expectedSignature)) {
            return;
        }
        throw new SecurityException("Message signature does not match");
    }

    @Override
    public void close() {
        try {
            this.secretManager.close();
        }
        catch (Exception ex) {
            LOG.error("Error closing the signer", ex);
        }
    }
}

