/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.pretty;

import com.google.common.base.Throwables;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.pretty.SqlFormatOptions;
import org.apache.calcite.sql.util.SqlBuilder;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteLogger;
import org.slf4j.LoggerFactory;

public class SqlPrettyWriter
implements SqlWriter {
    protected static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger("org.apache.calcite.sql.pretty.SqlPrettyWriter"));
    private static final Bean DEFAULT_BEAN = new SqlPrettyWriter(SqlDialect.DUMMY).getBean();
    protected static final String NL = System.getProperty("line.separator");
    private final SqlDialect dialect;
    private final StringWriter sw = new StringWriter();
    protected final PrintWriter pw;
    private final Deque<FrameImpl> listStack = new ArrayDeque<FrameImpl>();
    protected FrameImpl frame;
    private boolean needWhitespace;
    protected String nextWhitespace;
    protected boolean alwaysUseParentheses;
    private boolean keywordsLowerCase;
    private Bean bean;
    private boolean quoteAllIdentifiers;
    private int indentation;
    private boolean clauseStartsLine;
    private boolean selectListItemsOnSeparateLines;
    private boolean selectListExtraIndentFlag;
    private int currentIndent;
    private boolean windowDeclListNewline;
    private boolean updateSetListNewline;
    private boolean windowNewline;
    private SqlWriter.SubqueryStyle subqueryStyle;
    private boolean whereListItemsOnSeparateLines;
    private boolean caseClausesOnNewLines;
    private int lineLength;
    private int charCount;

    public SqlPrettyWriter(SqlDialect dialect, boolean alwaysUseParentheses, PrintWriter pw) {
        if (pw == null) {
            pw = new PrintWriter(this.sw);
        }
        this.pw = pw;
        this.dialect = dialect;
        this.alwaysUseParentheses = alwaysUseParentheses;
        this.resetSettings();
        this.reset();
    }

    public SqlPrettyWriter(SqlDialect dialect, boolean alwaysUseParentheses) {
        this(dialect, alwaysUseParentheses, null);
    }

    public SqlPrettyWriter(SqlDialect dialect) {
        this(dialect, true);
    }

    public void setCaseClausesOnNewLines(boolean caseClausesOnNewLines) {
        this.caseClausesOnNewLines = caseClausesOnNewLines;
    }

    public void setSubqueryStyle(SqlWriter.SubqueryStyle subqueryStyle) {
        this.subqueryStyle = subqueryStyle;
    }

    public void setWindowNewline(boolean windowNewline) {
        this.windowNewline = windowNewline;
    }

    public void setWindowDeclListNewline(boolean windowDeclListNewline) {
        this.windowDeclListNewline = windowDeclListNewline;
    }

    @Override
    public int getIndentation() {
        return this.indentation;
    }

    @Override
    public boolean isAlwaysUseParentheses() {
        return this.alwaysUseParentheses;
    }

    @Override
    public boolean inQuery() {
        return this.frame == null || this.frame.frameType == SqlWriter.FrameTypeEnum.ORDER_BY || this.frame.frameType == SqlWriter.FrameTypeEnum.WITH || this.frame.frameType == SqlWriter.FrameTypeEnum.SETOP;
    }

    @Override
    public boolean isQuoteAllIdentifiers() {
        return this.quoteAllIdentifiers;
    }

    @Override
    public boolean isClauseStartsLine() {
        return this.clauseStartsLine;
    }

    @Override
    public boolean isSelectListItemsOnSeparateLines() {
        return this.selectListItemsOnSeparateLines;
    }

    public boolean isWhereListItemsOnSeparateLines() {
        return this.whereListItemsOnSeparateLines;
    }

    public boolean isSelectListExtraIndentFlag() {
        return this.selectListExtraIndentFlag;
    }

    @Override
    public boolean isKeywordsLowerCase() {
        return this.keywordsLowerCase;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    @Override
    public void resetSettings() {
        this.reset();
        this.indentation = 4;
        this.clauseStartsLine = true;
        this.selectListItemsOnSeparateLines = false;
        this.selectListExtraIndentFlag = true;
        this.keywordsLowerCase = false;
        this.quoteAllIdentifiers = true;
        this.windowDeclListNewline = true;
        this.updateSetListNewline = true;
        this.windowNewline = false;
        this.subqueryStyle = SqlWriter.SubqueryStyle.HYDE;
        this.alwaysUseParentheses = false;
        this.whereListItemsOnSeparateLines = false;
        this.lineLength = 0;
        this.charCount = 0;
    }

    @Override
    public void reset() {
        this.pw.flush();
        this.sw.getBuffer().setLength(0);
        this.setNeedWhitespace(false);
        this.nextWhitespace = " ";
    }

    private Bean getBean() {
        if (this.bean == null) {
            this.bean = new Bean(this);
        }
        return this.bean;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public void describe(PrintWriter pw, boolean omitDefaults) {
        Bean properties = this.getBean();
        String[] propertyNames = properties.getPropertyNames();
        int count = 0;
        for (String key : propertyNames) {
            Object defaultValue;
            Object value = this.bean.get(key);
            if (Objects.equals(value, defaultValue = DEFAULT_BEAN.get(key))) continue;
            if (count++ > 0) {
                pw.print(",");
            }
            pw.print(key + "=" + value);
        }
    }

    public void setSettings(Properties properties) {
        String[] propertyNames;
        this.resetSettings();
        Bean bean = this.getBean();
        for (String propertyName : propertyNames = bean.getPropertyNames()) {
            String value = properties.getProperty(propertyName);
            if (value == null) continue;
            bean.set(propertyName, value);
        }
    }

    public void setClauseStartsLine(boolean clauseStartsLine) {
        this.clauseStartsLine = clauseStartsLine;
    }

    public void setSelectListItemsOnSeparateLines(boolean b) {
        this.selectListItemsOnSeparateLines = b;
    }

    public void setSelectListExtraIndentFlag(boolean b) {
        this.selectListExtraIndentFlag = b;
    }

    public void setKeywordsLowerCase(boolean b) {
        this.keywordsLowerCase = b;
    }

    public void setWhereListItemsOnSeparateLines(boolean b) {
        this.whereListItemsOnSeparateLines = b;
    }

    public void setAlwaysUseParentheses(boolean b) {
        this.alwaysUseParentheses = b;
    }

    @Override
    public void newlineAndIndent() {
        this.pw.println();
        this.charCount = 0;
        this.indent(this.currentIndent);
        this.setNeedWhitespace(false);
    }

    void indent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("negative indent " + indent);
        }
        Spaces.append(this.pw, indent);
        this.charCount += indent;
    }

    public void setQuoteAllIdentifiers(boolean b) {
        this.quoteAllIdentifiers = b;
    }

    protected FrameImpl createListFrame(SqlWriter.FrameType frameType, String keyword, String open, String close) {
        int indentation = this.getIndentation();
        if (frameType instanceof SqlWriter.FrameTypeEnum) {
            SqlWriter.FrameTypeEnum frameTypeEnum = (SqlWriter.FrameTypeEnum)frameType;
            switch (frameTypeEnum) {
                case WINDOW_DECL_LIST: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, false, indentation, this.windowDeclListNewline, false, false);
                }
                case UPDATE_SET_LIST: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, this.updateSetListNewline, indentation, false, false, false);
                }
                case SELECT_LIST: {
                    return new FrameImpl(frameType, keyword, open, close, this.selectListExtraIndentFlag ? indentation : 0, this.selectListItemsOnSeparateLines, false, indentation, this.selectListItemsOnSeparateLines, false, false);
                }
                case ORDER_BY_LIST: 
                case GROUP_BY_LIST: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, this.selectListItemsOnSeparateLines, false, indentation, this.selectListItemsOnSeparateLines, false, false);
                }
                case SUB_QUERY: {
                    switch (this.subqueryStyle) {
                        case BLACK: {
                            open = Spaces.padRight("(", indentation);
                            return new FrameImpl(frameType, keyword, open, close, 0, false, true, indentation, false, false, false){

                                protected void _before() {
                                    SqlPrettyWriter.this.newlineAndIndent();
                                }
                            };
                        }
                        case HYDE: {
                            return new FrameImpl(frameType, keyword, open, close, 0, false, true, 0, false, false, false){

                                protected void _before() {
                                    SqlPrettyWriter.this.nextWhitespace = NL;
                                }
                            };
                        }
                    }
                    throw Util.unexpected(this.subqueryStyle);
                }
                case ORDER_BY: 
                case OFFSET: 
                case FETCH: {
                    return new FrameImpl(frameType, keyword, open, close, 0, false, true, 0, false, false, false);
                }
                case SELECT: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, this.isClauseStartsLine(), 0, false, false, false);
                }
                case SETOP: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, this.isClauseStartsLine(), 0, this.isClauseStartsLine(), false, false);
                }
                case WINDOW: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, this.windowNewline, 0, false, false, false);
                }
                case FUN_CALL: {
                    this.setNeedWhitespace(false);
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, false, indentation, false, false, false);
                }
                case IDENTIFIER: 
                case SIMPLE: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, false, indentation, false, false, false);
                }
                case WHERE_LIST: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, this.whereListItemsOnSeparateLines, 0, false, false, false);
                }
                case FROM_LIST: 
                case JOIN: {
                    return new FrameImpl(frameType, keyword, open, close, indentation, false, this.isClauseStartsLine(), 0, this.isClauseStartsLine(), false, false){

                        @Override
                        protected void sep(boolean printFirst, String sep) {
                            boolean newlineAfter;
                            boolean newlineBefore = this.newlineBeforeSep && !sep.equals(",");
                            boolean bl = newlineAfter = this.newlineAfterSep && sep.equals(",");
                            if (this.itemCount > 0 || printFirst) {
                                if (newlineBefore && this.itemCount > 0) {
                                    SqlPrettyWriter.this.pw.println();
                                    SqlPrettyWriter.this.charCount = 0;
                                    SqlPrettyWriter.this.indent(SqlPrettyWriter.this.currentIndent + this.sepIndent);
                                    SqlPrettyWriter.this.setNeedWhitespace(false);
                                }
                                SqlPrettyWriter.this.keyword(sep);
                                SqlPrettyWriter.this.nextWhitespace = newlineAfter ? NL : " ";
                            }
                            ++this.itemCount;
                        }
                    };
                }
            }
        }
        boolean newlineAfterOpen = false;
        boolean newlineBeforeSep = false;
        boolean newlineBeforeClose = false;
        int sepIndent = indentation;
        if (frameType.getName().equals("CASE") && this.caseClausesOnNewLines) {
            newlineAfterOpen = true;
            newlineBeforeSep = true;
            newlineBeforeClose = true;
            sepIndent = 0;
        }
        return new FrameImpl(frameType, keyword, open, close, indentation, newlineAfterOpen, newlineBeforeSep, sepIndent, false, newlineBeforeClose, false);
    }

    protected SqlWriter.Frame startList(SqlWriter.FrameType frameType, String keyword, String open, String close) {
        assert (frameType != null);
        if (this.frame != null) {
            ++this.frame.itemCount;
            if (frameType.needsIndent()) {
                this.currentIndent += this.frame.extraIndent;
            }
            assert (!this.listStack.contains(this.frame));
            this.listStack.push(this.frame);
        }
        this.frame = this.createListFrame(frameType, keyword, open, close);
        this.frame.before();
        return this.frame;
    }

    @Override
    public void endList(SqlWriter.Frame frame) {
        FrameImpl endedFrame = (FrameImpl)frame;
        Util.pre(frame == this.frame, "Frame " + endedFrame.frameType + " does not match current frame " + this.frame.frameType);
        if (this.frame == null) {
            throw new RuntimeException("No list started");
        }
        if (this.frame.open.equals("(") && !this.frame.close.equals(")")) {
            throw new RuntimeException("Expected ')'");
        }
        if (this.frame.newlineBeforeClose) {
            this.newlineAndIndent();
        }
        this.keyword(this.frame.close);
        if (this.frame.newlineAfterClose) {
            this.newlineAndIndent();
        }
        if (this.listStack.isEmpty()) {
            this.frame = null;
            assert (this.currentIndent == 0) : this.currentIndent;
        } else {
            this.frame = this.listStack.pop();
            if (endedFrame.frameType.needsIndent()) {
                this.currentIndent -= this.frame.extraIndent;
            }
        }
    }

    public String format(SqlNode node) {
        assert (this.frame == null);
        node.unparse(this, 0, 0);
        assert (this.frame == null);
        return this.toString();
    }

    public String toString() {
        this.pw.flush();
        return this.sw.toString();
    }

    @Override
    public SqlString toSqlString() {
        return new SqlBuilder(this.dialect, this.toString()).toSqlString();
    }

    @Override
    public SqlDialect getDialect() {
        return this.dialect;
    }

    @Override
    public void literal(String s) {
        this.print(s);
        this.setNeedWhitespace(true);
    }

    @Override
    public void keyword(String s) {
        this.maybeWhitespace(s);
        this.pw.print(this.isKeywordsLowerCase() ? s.toLowerCase() : s.toUpperCase());
        this.charCount += s.length();
        if (!s.equals("")) {
            this.setNeedWhitespace(SqlPrettyWriter.needWhitespaceAfter(s));
        }
    }

    private void maybeWhitespace(String s) {
        if (this.tooLong(s) || this.needWhitespace && SqlPrettyWriter.needWhitespaceBefore(s)) {
            this.whiteSpace();
        }
    }

    private static boolean needWhitespaceBefore(String s) {
        return !s.equals(",") && !s.equals(".") && !s.equals(")") && !s.equals("[") && !s.equals("]") && !s.equals("");
    }

    private static boolean needWhitespaceAfter(String s) {
        return !s.equals("(") && !s.equals("[") && !s.equals(".");
    }

    protected void whiteSpace() {
        if (this.needWhitespace) {
            if (this.nextWhitespace.equals(NL)) {
                this.newlineAndIndent();
            } else {
                this.pw.print(this.nextWhitespace);
                this.charCount += this.nextWhitespace.length();
            }
            this.nextWhitespace = " ";
            this.setNeedWhitespace(false);
        }
    }

    protected boolean tooLong(String s) {
        boolean result;
        boolean bl = result = this.lineLength > 0 && this.charCount > this.currentIndent && this.charCount + s.length() >= this.lineLength;
        if (result) {
            this.nextWhitespace = NL;
        }
        LOGGER.trace("Token is '{}'; result is {}", (Object)s, (Object)result);
        return result;
    }

    @Override
    public void print(String s) {
        if (s.equals("(")) {
            throw new RuntimeException("Use 'startList'");
        }
        if (s.equals(")")) {
            throw new RuntimeException("Use 'endList'");
        }
        this.maybeWhitespace(s);
        this.pw.print(s);
        this.charCount += s.length();
    }

    @Override
    public void print(int x) {
        this.maybeWhitespace("0");
        this.pw.print(x);
        this.charCount += String.valueOf(x).length();
    }

    @Override
    public void identifier(String name) {
        String qName = name;
        if (this.isQuoteAllIdentifiers() || this.dialect.identifierNeedsToBeQuoted(name)) {
            qName = this.dialect.quoteIdentifier(name);
        }
        this.maybeWhitespace(qName);
        this.pw.print(qName);
        this.charCount += qName.length();
        this.setNeedWhitespace(true);
    }

    @Override
    public void fetchOffset(SqlNode fetch, SqlNode offset) {
        if (fetch == null && offset == null) {
            return;
        }
        if (this.dialect.supportsOffsetFetch()) {
            if (offset != null) {
                this.newlineAndIndent();
                SqlWriter.Frame offsetFrame = this.startList(SqlWriter.FrameTypeEnum.OFFSET);
                this.keyword("OFFSET");
                offset.unparse(this, -1, -1);
                this.keyword("ROWS");
                this.endList(offsetFrame);
            }
            if (fetch != null) {
                this.newlineAndIndent();
                SqlWriter.Frame fetchFrame = this.startList(SqlWriter.FrameTypeEnum.FETCH);
                this.keyword("FETCH");
                this.keyword("NEXT");
                fetch.unparse(this, -1, -1);
                this.keyword("ROWS");
                this.keyword("ONLY");
                this.endList(fetchFrame);
            }
        } else {
            if (fetch != null) {
                this.newlineAndIndent();
                SqlWriter.Frame fetchFrame = this.startList(SqlWriter.FrameTypeEnum.FETCH);
                this.keyword("LIMIT");
                fetch.unparse(this, -1, -1);
                this.endList(fetchFrame);
            }
            if (offset != null) {
                this.newlineAndIndent();
                SqlWriter.Frame offsetFrame = this.startList(SqlWriter.FrameTypeEnum.OFFSET);
                this.keyword("OFFSET");
                offset.unparse(this, -1, -1);
                this.endList(offsetFrame);
            }
        }
    }

    @Override
    public SqlWriter.Frame startFunCall(String funName) {
        this.keyword(funName);
        this.setNeedWhitespace(false);
        return this.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
    }

    @Override
    public void endFunCall(SqlWriter.Frame frame) {
        this.endList(this.frame);
    }

    @Override
    public SqlWriter.Frame startList(String open, String close) {
        return this.startList(SqlWriter.FrameTypeEnum.SIMPLE, null, open, close);
    }

    @Override
    public SqlWriter.Frame startList(SqlWriter.FrameTypeEnum frameType) {
        assert (frameType != null);
        return this.startList(frameType, null, "", "");
    }

    @Override
    public SqlWriter.Frame startList(SqlWriter.FrameType frameType, String open, String close) {
        assert (frameType != null);
        return this.startList(frameType, null, open, close);
    }

    @Override
    public void sep(String sep) {
        this.sep(sep, !sep.equals(",") && !sep.equals("."));
    }

    @Override
    public void sep(String sep, boolean printFirst) {
        if (this.frame == null) {
            throw new RuntimeException("No list started");
        }
        if (sep.startsWith(" ") || sep.endsWith(" ")) {
            throw new RuntimeException("Separator must not contain whitespace");
        }
        this.frame.sep(printFirst, sep);
    }

    @Override
    public void setNeedWhitespace(boolean needWhitespace) {
        this.needWhitespace = needWhitespace;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public void setFormatOptions(SqlFormatOptions options) {
        if (options == null) {
            return;
        }
        this.setAlwaysUseParentheses(options.isAlwaysUseParentheses());
        this.setCaseClausesOnNewLines(options.isCaseClausesOnNewLines());
        this.setClauseStartsLine(options.isClauseStartsLine());
        this.setKeywordsLowerCase(options.isKeywordsLowercase());
        this.setQuoteAllIdentifiers(options.isQuoteAllIdentifiers());
        this.setSelectListItemsOnSeparateLines(options.isSelectListItemsOnSeparateLines());
        this.setWhereListItemsOnSeparateLines(options.isWhereListItemsOnSeparateLines());
        this.setWindowNewline(options.isWindowDeclarationStartsLine());
        this.setWindowDeclListNewline(options.isWindowListItemsOnSeparateLines());
        this.setIndentation(options.getIndentation());
        this.setLineLength(options.getLineLength());
    }

    private static class Bean {
        private final SqlPrettyWriter o;
        private final Map<String, Method> getterMethods = new HashMap<String, Method>();
        private final Map<String, Method> setterMethods = new HashMap<String, Method>();

        Bean(SqlPrettyWriter o) {
            this.o = o;
            for (Method method : o.getClass().getMethods()) {
                String attributeName;
                if (method.getName().startsWith("set") && method.getReturnType() == Void.class && method.getParameterTypes().length == 1) {
                    attributeName = this.stripPrefix(method.getName(), 3);
                    this.setterMethods.put(attributeName, method);
                }
                if (method.getName().startsWith("get") && method.getReturnType() != Void.class && method.getParameterTypes().length == 0) {
                    attributeName = this.stripPrefix(method.getName(), 3);
                    this.getterMethods.put(attributeName, method);
                }
                if (!method.getName().startsWith("is") || method.getReturnType() != Boolean.class || method.getParameterTypes().length != 0) continue;
                attributeName = this.stripPrefix(method.getName(), 2);
                this.getterMethods.put(attributeName, method);
            }
        }

        private String stripPrefix(String name, int offset) {
            return name.substring(offset, offset + 1).toLowerCase() + name.substring(offset + 1);
        }

        public void set(String name, String value) {
            Method method = this.setterMethods.get(name);
            try {
                method.invoke((Object)this.o, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Throwables.propagate(e);
            }
        }

        public Object get(String name) {
            Method method = this.getterMethods.get(name);
            try {
                return method.invoke((Object)this.o, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Throwables.propagate(e);
            }
        }

        public String[] getPropertyNames() {
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.getterMethods.keySet());
            names.addAll(this.setterMethods.keySet());
            return names.toArray(new String[names.size()]);
        }
    }

    protected class FrameImpl
    implements SqlWriter.Frame {
        final SqlWriter.FrameType frameType;
        final String keyword;
        final String open;
        final String close;
        final int extraIndent;
        final int sepIndent;
        int itemCount;
        public final boolean newlineBeforeSep;
        public final boolean newlineAfterSep;
        private final boolean newlineBeforeClose;
        private final boolean newlineAfterClose;
        private final boolean newlineAfterOpen;

        FrameImpl(SqlWriter.FrameType frameType, String keyword, String open, String close, int extraIndent, boolean newlineAfterOpen, boolean newlineBeforeSep, int sepIndent, boolean newlineAfterSep, boolean newlineBeforeClose, boolean newlineAfterClose) {
            this.frameType = frameType;
            this.keyword = keyword;
            this.open = open;
            this.close = close;
            this.extraIndent = extraIndent;
            this.newlineAfterOpen = newlineAfterOpen;
            this.newlineBeforeSep = newlineBeforeSep;
            this.newlineAfterSep = newlineAfterSep;
            this.newlineBeforeClose = newlineBeforeClose;
            this.newlineAfterClose = newlineAfterClose;
            this.sepIndent = sepIndent;
        }

        protected void before() {
            if (this.open != null && !this.open.equals("")) {
                SqlPrettyWriter.this.keyword(this.open);
            }
        }

        protected void after() {
        }

        protected void sep(boolean printFirst, String sep) {
            if (this.newlineBeforeSep && this.itemCount > 0 || this.newlineAfterOpen && this.itemCount == 0) {
                SqlPrettyWriter.this.newlineAndIndent();
            }
            if (this.itemCount > 0 || printFirst) {
                SqlPrettyWriter.this.keyword(sep);
                SqlPrettyWriter.this.nextWhitespace = this.newlineAfterSep ? NL : " ";
            }
            ++this.itemCount;
        }
    }
}

