/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAccumuloSplit
extends FileSplit
implements InputSplit {
    private static final Logger log = LoggerFactory.getLogger(HiveAccumuloSplit.class);
    private RangeInputSplit split;

    public HiveAccumuloSplit() {
        super((Path)null, 0L, 0L, (String[])null);
        this.split = new RangeInputSplit();
    }

    public HiveAccumuloSplit(RangeInputSplit split, Path dummyPath) {
        super(dummyPath, 0L, 0L, (String[])null);
        this.split = split;
    }

    public RangeInputSplit getSplit() {
        return this.split;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.split.readFields(in);
    }

    public String toString() {
        return "HiveAccumuloSplit: " + this.split;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.split.write(out);
    }

    public long getLength() {
        int len = 0;
        try {
            return this.split.getLength();
        }
        catch (IOException e) {
            log.error("Error getting length for split: " + StringUtils.stringifyException((Throwable)e));
            return len;
        }
    }

    public String[] getLocations() throws IOException {
        return this.split.getLocations();
    }
}

