/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum ColumnEncoding {
    STRING("string", "s"),
    BINARY("binary", "b");

    private static final HashMap<String, ColumnEncoding> CODE_CACHE;
    private static final HashMap<String, ColumnEncoding> NAME_CACHE;
    private final String name;
    private final String code;

    private ColumnEncoding(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static ColumnEncoding fromCode(String code) {
        if (!CODE_CACHE.containsKey(code)) {
            throw new IllegalArgumentException("No ColumnEncoding defined with code " + code);
        }
        return CODE_CACHE.get(code);
    }

    public static ColumnEncoding fromName(String name) {
        if (!NAME_CACHE.containsKey(name)) {
            throw new IllegalArgumentException("No ColumnEncoding defined with name " + name);
        }
        return NAME_CACHE.get(name);
    }

    public static ColumnEncoding get(String nameOrCode) {
        ColumnEncoding encoding = CODE_CACHE.get(nameOrCode);
        if (null != encoding) {
            return encoding;
        }
        encoding = NAME_CACHE.get(nameOrCode);
        if (null != encoding) {
            return encoding;
        }
        throw new IllegalArgumentException("No ColumnEncoding defined for " + nameOrCode);
    }

    public static ColumnEncoding getFromMapping(String columnMapping) {
        Preconditions.checkNotNull((Object)columnMapping);
        String encoding = ColumnEncoding.getColumnEncoding(columnMapping);
        return ColumnEncoding.get(encoding);
    }

    public static boolean hasColumnEncoding(String columnMapping) {
        Preconditions.checkNotNull((Object)columnMapping);
        int offset = columnMapping.lastIndexOf(35);
        if (0 < offset && '\\' == columnMapping.charAt(offset - 1)) {
            return false;
        }
        return -1 != offset;
    }

    public static String getColumnEncoding(String columnMapping) {
        int offset = columnMapping.lastIndexOf(35);
        if (0 < offset && '\\' == columnMapping.charAt(offset - 1)) {
            throw new IllegalArgumentException("Column mapping did not contain a column encoding: " + columnMapping);
        }
        return columnMapping.substring(offset + 1);
    }

    public static ColumnEncoding getDefault() {
        return STRING;
    }

    public static String stripCode(String columnMapping) {
        Preconditions.checkNotNull((Object)columnMapping);
        int offset = columnMapping.lastIndexOf(35);
        if (-1 == offset || 0 < offset && '\\' == columnMapping.charAt(offset - 1)) {
            throw new IllegalArgumentException("Provided column mapping does not define a column encoding");
        }
        return columnMapping.substring(0, offset);
    }

    public static boolean isMapEncoding(String columnEncoding) {
        return -1 != columnEncoding.indexOf(58);
    }

    public static Map.Entry<ColumnEncoding, ColumnEncoding> getMapEncoding(String columnEncoding) {
        int index = columnEncoding.indexOf(58);
        if (-1 == index) {
            throw new IllegalArgumentException("Serialized column encoding did not contain a pair of encodings to split");
        }
        String encoding1 = columnEncoding.substring(0, index);
        String encoding2 = columnEncoding.substring(index + 1);
        return Maps.immutableEntry((Object)((Object)ColumnEncoding.get(encoding1)), (Object)((Object)ColumnEncoding.get(encoding2)));
    }

    static {
        CODE_CACHE = new HashMap();
        NAME_CACHE = new HashMap();
        CODE_CACHE.put(STRING.getCode(), STRING);
        CODE_CACHE.put(BINARY.getCode(), BINARY);
        NAME_CACHE.put(STRING.getName(), STRING);
        NAME_CACHE.put(BINARY.getName(), BINARY);
    }
}

