/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.collections.Int2IntCounterMap;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.AssignRegionAction;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.MoveRegionAction;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.SwapRegionsAction;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class BalancerClusterState {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerClusterState.class);
    ServerName[] servers;
    String[] hosts;
    String[] racks;
    boolean multiServersPerHost = false;
    ArrayList<String> tables;
    RegionInfo[] regions;
    Deque<BalancerRegionLoad>[] regionLoads;
    private RegionLocationFinder regionFinder;
    int[][] regionLocations;
    int[] serverIndexToHostIndex;
    int[] serverIndexToRackIndex;
    int[][] regionsPerServer;
    int[] serverIndexToRegionsOffset;
    int[][] regionsPerHost;
    int[][] regionsPerRack;
    Int2IntCounterMap[] colocatedReplicaCountsPerServer;
    Int2IntCounterMap[] colocatedReplicaCountsPerHost;
    Int2IntCounterMap[] colocatedReplicaCountsPerRack;
    int[][] serversPerHost;
    int[][] serversPerRack;
    int[] regionIndexToServerIndex;
    int[] initialRegionIndexToServerIndex;
    int[] regionIndexToTableIndex;
    int[][] numRegionsPerServerPerTable;
    int[] numRegionsPerTable;
    int[] numMaxRegionsPerTable;
    int[] regionIndexToPrimaryIndex;
    boolean hasRegionReplicas = false;
    Integer[] serverIndicesSortedByRegionCount;
    Integer[] serverIndicesSortedByLocality;
    Map<Address, Integer> serversToIndex;
    Map<String, Integer> hostsToIndex;
    Map<String, Integer> racksToIndex;
    Map<String, Integer> tablesToIndex;
    Map<RegionInfo, Integer> regionsToIndex;
    float[] localityPerServer;
    int numServers;
    int numHosts;
    int numRacks;
    int numTables;
    int numRegions;
    int maxReplicas = 1;
    int numMovedRegions = 0;
    Map<ServerName, List<RegionInfo>> clusterState;
    private final RackManager rackManager;
    private float[][] rackLocalities;
    private int[][] regionsToMostLocalEntities;
    private Map<Pair<Integer, Integer>, Float> regionIndexServerIndexRegionCachedRatio;
    private int[] regionServerIndexWithBestRegionCachedRatio;
    Map<String, Pair<ServerName, Float>> regionCacheRatioOnOldServerMap;
    private Comparator<Integer> numRegionsComparator = Comparator.comparingInt(this::getNumRegions);

    BalancerClusterState(Map<ServerName, List<RegionInfo>> clusterState, Map<String, Deque<BalancerRegionLoad>> loads, RegionLocationFinder regionFinder, RackManager rackManager) {
        this(null, clusterState, loads, regionFinder, rackManager, null);
    }

    protected BalancerClusterState(Map<ServerName, List<RegionInfo>> clusterState, Map<String, Deque<BalancerRegionLoad>> loads, RegionLocationFinder regionFinder, RackManager rackManager, Map<String, Pair<ServerName, Float>> oldRegionServerRegionCacheRatio) {
        this(null, clusterState, loads, regionFinder, rackManager, oldRegionServerRegionCacheRatio);
    }

    /*
     * WARNING - void declaration
     */
    BalancerClusterState(Collection<RegionInfo> unassignedRegions, Map<ServerName, List<RegionInfo>> clusterState, Map<String, Deque<BalancerRegionLoad>> loads, RegionLocationFinder regionFinder, RackManager rackManager, Map<String, Pair<ServerName, Float>> oldRegionServerRegionCacheRatio) {
        int i;
        if (unassignedRegions == null) {
            unassignedRegions = Collections.emptyList();
        }
        this.serversToIndex = new HashMap<Address, Integer>();
        this.hostsToIndex = new HashMap<String, Integer>();
        this.racksToIndex = new HashMap<String, Integer>();
        this.tablesToIndex = new HashMap<String, Integer>();
        this.tables = new ArrayList();
        this.rackManager = rackManager != null ? rackManager : new DefaultRackManager();
        this.regionCacheRatioOnOldServerMap = oldRegionServerRegionCacheRatio;
        this.numRegions = 0;
        ArrayList serversPerHostList = new ArrayList();
        ArrayList serversPerRackList = new ArrayList();
        this.clusterState = clusterState;
        this.regionFinder = regionFinder;
        for (ServerName serverName : clusterState.keySet()) {
            if (serverName == null) {
                LOG.warn("TODO: Enable TRACE on BaseLoadBalancer. Empty servername); skipping; unassigned regions?");
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("EMPTY SERVERNAME " + clusterState.toString());
                continue;
            }
            if (this.serversToIndex.get(serverName.getAddress()) == null) {
                this.serversToIndex.put(serverName.getAddress(), this.numServers++);
            }
            if (!this.hostsToIndex.containsKey(serverName.getHostname())) {
                this.hostsToIndex.put(serverName.getHostname(), this.numHosts++);
                serversPerHostList.add(new ArrayList(1));
            }
            int serverIndex = this.serversToIndex.get(serverName.getAddress());
            int n = this.hostsToIndex.get(serverName.getHostname());
            ((List)serversPerHostList.get(n)).add(serverIndex);
            String rack = this.rackManager.getRack(serverName);
            if (!this.racksToIndex.containsKey(rack)) {
                this.racksToIndex.put(rack, this.numRacks++);
                serversPerRackList.add(new ArrayList());
            }
            int rackIndex = this.racksToIndex.get(rack);
            ((List)serversPerRackList.get(rackIndex)).add(serverIndex);
        }
        LOG.debug("Hosts are {} racks are {}", this.hostsToIndex, this.racksToIndex);
        for (Map.Entry entry : clusterState.entrySet()) {
            this.numRegions += ((List)entry.getValue()).size();
        }
        this.numRegions += unassignedRegions.size();
        this.regionsToIndex = new HashMap<RegionInfo, Integer>(this.numRegions);
        this.servers = new ServerName[this.numServers];
        this.serversPerHost = new int[this.numHosts][];
        this.serversPerRack = new int[this.numRacks][];
        this.regions = new RegionInfo[this.numRegions];
        this.regionIndexToServerIndex = new int[this.numRegions];
        this.initialRegionIndexToServerIndex = new int[this.numRegions];
        this.regionIndexToTableIndex = new int[this.numRegions];
        this.regionIndexToPrimaryIndex = new int[this.numRegions];
        this.regionLoads = new Deque[this.numRegions];
        this.regionLocations = new int[this.numRegions][];
        this.serverIndicesSortedByRegionCount = new Integer[this.numServers];
        this.serverIndicesSortedByLocality = new Integer[this.numServers];
        this.localityPerServer = new float[this.numServers];
        this.serverIndexToHostIndex = new int[this.numServers];
        this.serverIndexToRackIndex = new int[this.numServers];
        this.regionsPerServer = new int[this.numServers][];
        this.serverIndexToRegionsOffset = new int[this.numServers];
        this.regionsPerHost = new int[this.numHosts][];
        this.regionsPerRack = new int[this.numRacks][];
        this.colocatedReplicaCountsPerServer = new Int2IntCounterMap[this.numServers];
        this.colocatedReplicaCountsPerHost = new Int2IntCounterMap[this.numHosts];
        this.colocatedReplicaCountsPerRack = new Int2IntCounterMap[this.numRacks];
        int regionIndex = 0;
        boolean bl = false;
        for (Map.Entry<ServerName, List<RegionInfo>> entry : clusterState.entrySet()) {
            if (entry.getKey() == null) {
                LOG.warn("SERVERNAME IS NULL, skipping " + entry.getValue());
                continue;
            }
            int serverIndex = this.serversToIndex.get(entry.getKey().getAddress());
            if (this.servers[serverIndex] == null || this.servers[serverIndex].getStartcode() < entry.getKey().getStartcode()) {
                this.servers[serverIndex] = entry.getKey();
            }
            this.regionsPerServer[serverIndex] = this.regionsPerServer[serverIndex] != null ? new int[entry.getValue().size() + this.regionsPerServer[serverIndex].length] : new int[entry.getValue().size()];
            this.colocatedReplicaCountsPerServer[serverIndex] = new Int2IntCounterMap(this.regionsPerServer[serverIndex].length, 0.65f, 0);
            this.serverIndicesSortedByRegionCount[serverIndex] = serverIndex;
            this.serverIndicesSortedByLocality[serverIndex] = serverIndex;
        }
        this.hosts = new String[this.numHosts];
        for (Map.Entry<Object, Object> entry : this.hostsToIndex.entrySet()) {
            this.hosts[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
        }
        this.racks = new String[this.numRacks];
        for (Map.Entry<Object, Object> entry : this.racksToIndex.entrySet()) {
            this.racks[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
        }
        for (Map.Entry<Object, Object> entry : clusterState.entrySet()) {
            int rackIndex;
            int hostIndex;
            int serverIndex = this.serversToIndex.get(((ServerName)entry.getKey()).getAddress());
            int n = this.serverIndexToRegionsOffset[serverIndex];
            this.serverIndexToHostIndex[serverIndex] = hostIndex = this.hostsToIndex.get(((ServerName)entry.getKey()).getHostname()).intValue();
            this.serverIndexToRackIndex[serverIndex] = rackIndex = this.racksToIndex.get(this.rackManager.getRack((ServerName)entry.getKey())).intValue();
            for (RegionInfo region : (List)entry.getValue()) {
                this.registerRegion(region, regionIndex, serverIndex, loads, regionFinder);
                this.regionsPerServer[serverIndex][n++] = regionIndex++;
            }
            this.serverIndexToRegionsOffset[serverIndex] = n;
        }
        for (RegionInfo regionInfo : unassignedRegions) {
            this.registerRegion(regionInfo, regionIndex, -1, loads, regionFinder);
            ++regionIndex;
        }
        for (i = 0; i < serversPerHostList.size(); ++i) {
            void var12_26;
            this.serversPerHost[i] = new int[((List)serversPerHostList.get(i)).size()];
            boolean bl2 = false;
            while (var12_26 < this.serversPerHost[i].length) {
                this.serversPerHost[i][var12_26] = (Integer)((List)serversPerHostList.get(i)).get((int)var12_26);
                LOG.debug("server {} is on host {}", ((List)serversPerHostList.get(i)).get((int)var12_26), (Object)i);
                ++var12_26;
            }
            if (this.serversPerHost[i].length <= 1) continue;
            this.multiServersPerHost = true;
        }
        for (i = 0; i < serversPerRackList.size(); ++i) {
            this.serversPerRack[i] = new int[((List)serversPerRackList.get(i)).size()];
            for (int j = 0; j < this.serversPerRack[i].length; ++j) {
                this.serversPerRack[i][j] = (Integer)((List)serversPerRackList.get(i)).get(j);
                LOG.info("server {} is on rack {}", ((List)serversPerRackList.get(i)).get(j), (Object)i);
            }
        }
        this.numTables = this.tables.size();
        LOG.debug("Number of tables={}, number of hosts={}, number of racks={}", new Object[]{this.numTables, this.numHosts, this.numRacks});
        this.numRegionsPerServerPerTable = new int[this.numTables][this.numServers];
        this.numRegionsPerTable = new int[this.numTables];
        for (i = 0; i < this.numTables; ++i) {
            for (int j = 0; j < this.numServers; ++j) {
                this.numRegionsPerServerPerTable[i][j] = 0;
            }
        }
        for (i = 0; i < this.regionIndexToServerIndex.length; ++i) {
            if (this.regionIndexToServerIndex[i] < 0) continue;
            int[] nArray = this.numRegionsPerServerPerTable[this.regionIndexToTableIndex[i]];
            int n = this.regionIndexToServerIndex[i];
            nArray[n] = nArray[n] + 1;
            int n2 = this.regionIndexToTableIndex[i];
            this.numRegionsPerTable[n2] = this.numRegionsPerTable[n2] + 1;
        }
        for (i = 0; i < this.regions.length; ++i) {
            RegionInfo regionInfo = this.regions[i];
            if (RegionReplicaUtil.isDefaultReplica((RegionInfo)regionInfo)) {
                this.regionIndexToPrimaryIndex[i] = i;
                continue;
            }
            this.hasRegionReplicas = true;
            RegionInfo primaryInfo = RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)regionInfo);
            this.regionIndexToPrimaryIndex[i] = this.regionsToIndex.getOrDefault(primaryInfo, -1);
        }
        for (i = 0; i < this.regionsPerServer.length; ++i) {
            void var12_31;
            this.colocatedReplicaCountsPerServer[i] = new Int2IntCounterMap(this.regionsPerServer[i].length, 0.65f, 0);
            boolean bl3 = false;
            while (var12_31 < this.regionsPerServer[i].length) {
                int primaryIndex = this.regionIndexToPrimaryIndex[this.regionsPerServer[i][var12_31]];
                this.colocatedReplicaCountsPerServer[i].getAndIncrement(primaryIndex);
                ++var12_31;
            }
        }
        if (this.multiServersPerHost) {
            this.populateRegionPerLocationFromServer(this.regionsPerHost, this.colocatedReplicaCountsPerHost, this.serversPerHost);
        }
        if (this.numRacks > 1) {
            this.populateRegionPerLocationFromServer(this.regionsPerRack, this.colocatedReplicaCountsPerRack, this.serversPerRack);
        }
    }

    private void populateRegionPerLocationFromServer(int[][] regionsPerLocation, Int2IntCounterMap[] colocatedReplicaCountsPerLocation, int[][] serversPerLocation) {
        int j;
        int i;
        for (i = 0; i < serversPerLocation.length; ++i) {
            int numRegionsPerLocation = 0;
            for (j = 0; j < serversPerLocation[i].length; ++j) {
                numRegionsPerLocation += this.regionsPerServer[serversPerLocation[i][j]].length;
            }
            regionsPerLocation[i] = new int[numRegionsPerLocation];
            colocatedReplicaCountsPerLocation[i] = new Int2IntCounterMap(numRegionsPerLocation, 0.65f, 0);
        }
        for (i = 0; i < serversPerLocation.length; ++i) {
            int numRegionPerLocationIndex = 0;
            for (j = 0; j < serversPerLocation[i].length; ++j) {
                for (int k = 0; k < this.regionsPerServer[serversPerLocation[i][j]].length; ++k) {
                    int region;
                    regionsPerLocation[i][numRegionPerLocationIndex] = region = this.regionsPerServer[serversPerLocation[i][j]][k];
                    int primaryIndex = this.regionIndexToPrimaryIndex[region];
                    colocatedReplicaCountsPerLocation[i].getAndIncrement(primaryIndex);
                    ++numRegionPerLocationIndex;
                }
            }
        }
    }

    private void registerRegion(RegionInfo region, int regionIndex, int serverIndex, Map<String, Deque<BalancerRegionLoad>> loads, RegionLocationFinder regionFinder) {
        int numReplicas;
        String tableName = region.getTable().getNameAsString();
        if (!this.tablesToIndex.containsKey(tableName)) {
            this.tables.add(tableName);
            this.tablesToIndex.put(tableName, this.tablesToIndex.size());
        }
        int tableIndex = this.tablesToIndex.get(tableName);
        this.regionsToIndex.put(region, regionIndex);
        this.regions[regionIndex] = region;
        this.regionIndexToServerIndex[regionIndex] = serverIndex;
        this.initialRegionIndexToServerIndex[regionIndex] = serverIndex;
        this.regionIndexToTableIndex[regionIndex] = tableIndex;
        if (loads != null) {
            Deque<BalancerRegionLoad> rl = loads.get(region.getRegionNameAsString());
            if (rl == null) {
                rl = loads.get(region.getEncodedName());
            }
            this.regionLoads[regionIndex] = rl;
        }
        if (regionFinder != null) {
            List<ServerName> loc = regionFinder.getTopBlockLocations(region);
            this.regionLocations[regionIndex] = new int[loc.size()];
            for (int i = 0; i < loc.size(); ++i) {
                this.regionLocations[regionIndex][i] = loc.get(i) == null ? -1 : (this.serversToIndex.get(loc.get(i).getAddress()) == null ? -1 : this.serversToIndex.get(loc.get(i).getAddress()));
            }
        }
        if ((numReplicas = region.getReplicaId() + 1) > this.maxReplicas) {
            this.maxReplicas = numReplicas;
        }
    }

    public boolean serverHasTooFewRegions(int server) {
        int minLoad = this.numRegions / this.numServers;
        int numRegions = this.getNumRegions(server);
        return numRegions < minLoad;
    }

    public float[][] getOrComputeRackLocalities() {
        if (this.rackLocalities == null || this.regionsToMostLocalEntities == null) {
            this.computeCachedLocalities();
        }
        return this.rackLocalities;
    }

    public int[] getOrComputeRegionsToMostLocalEntities(LocalityType type) {
        if (this.rackLocalities == null || this.regionsToMostLocalEntities == null) {
            this.computeCachedLocalities();
        }
        return this.regionsToMostLocalEntities[type.ordinal()];
    }

    public float getOrComputeLocality(int region, int entity, LocalityType type) {
        switch (type) {
            case SERVER: {
                return this.getLocalityOfRegion(region, entity);
            }
            case RACK: {
                return this.getOrComputeRackLocalities()[region][entity];
            }
        }
        throw new IllegalArgumentException("Unsupported LocalityType: " + (Object)((Object)type));
    }

    public double getOrComputeWeightedLocality(int region, int server, LocalityType type) {
        return (float)this.getRegionSizeMB(region) * this.getOrComputeLocality(region, server, type);
    }

    public int getRegionSizeMB(int region) {
        Deque<BalancerRegionLoad> load = this.regionLoads[region];
        if (load == null) {
            return 0;
        }
        return this.regionLoads[region].getLast().getStorefileSizeMB();
    }

    private void computeCachedLocalities() {
        this.rackLocalities = new float[this.numRegions][this.numRacks];
        this.regionsToMostLocalEntities = new int[LocalityType.values().length][this.numRegions];
        for (int region = 0; region < this.numRegions; ++region) {
            int rack;
            int serverWithBestLocality = 0;
            float bestLocalityForRegion = 0.0f;
            for (int server = 0; server < this.numServers; ++server) {
                float locality = this.getLocalityOfRegion(region, server);
                rack = this.serverIndexToRackIndex[server];
                int numServersInRack = this.serversPerRack[rack].length;
                float[] fArray = this.rackLocalities[region];
                int n = rack;
                fArray[n] = fArray[n] + locality / (float)numServersInRack;
                if (!(locality > bestLocalityForRegion)) continue;
                serverWithBestLocality = server;
                bestLocalityForRegion = locality;
            }
            this.regionsToMostLocalEntities[LocalityType.SERVER.ordinal()][region] = serverWithBestLocality;
            int rackWithBestLocality = 0;
            float bestRackLocalityForRegion = 0.0f;
            for (rack = 0; rack < this.numRacks; ++rack) {
                float rackLocality = this.rackLocalities[region][rack];
                if (!(rackLocality > bestRackLocalityForRegion)) continue;
                bestRackLocalityForRegion = rackLocality;
                rackWithBestLocality = rack;
            }
            this.regionsToMostLocalEntities[LocalityType.RACK.ordinal()][region] = rackWithBestLocality;
        }
    }

    public int getTotalRegionHFileSizeMB(int region) {
        Deque<BalancerRegionLoad> load = this.regionLoads[region];
        if (load == null) {
            return 0;
        }
        return this.regionLoads[region].getLast().getRegionSizeMB();
    }

    public float getOrComputeWeightedRegionCacheRatio(int region, int server) {
        return (float)this.getTotalRegionHFileSizeMB(region) * this.getOrComputeRegionCacheRatio(region, server);
    }

    protected float getRegionCacheRatioOnRegionServer(int region, int regionServerIndex) {
        Pair<ServerName, Float> cacheRatioOfRegionOnServer;
        float regionCacheRatio = 0.0f;
        for (int regionIndex : this.regionsPerServer[regionServerIndex]) {
            if (region != regionIndex) continue;
            Deque<BalancerRegionLoad> regionLoadList = this.regionLoads[regionIndex];
            regionCacheRatio = regionLoadList == null ? 0.0f : regionLoadList.getLast().getCurrentRegionCacheRatio();
            return regionCacheRatio;
        }
        String regionEncodedName = this.regions[region].getEncodedName();
        ServerName serverName = this.servers[regionServerIndex];
        if (this.regionCacheRatioOnOldServerMap != null && this.regionCacheRatioOnOldServerMap.containsKey(regionEncodedName) && ServerName.isSameAddress((ServerName)((ServerName)(cacheRatioOfRegionOnServer = this.regionCacheRatioOnOldServerMap.get(regionEncodedName)).getFirst()), (ServerName)serverName)) {
            regionCacheRatio = ((Float)cacheRatioOfRegionOnServer.getSecond()).floatValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Old cache ratio found for region {} on server {}: {}", new Object[]{regionEncodedName, serverName, Float.valueOf(regionCacheRatio)});
            }
        }
        return regionCacheRatio;
    }

    private void computeRegionServerRegionCacheRatio() {
        this.regionIndexServerIndexRegionCachedRatio = new HashMap<Pair<Integer, Integer>, Float>();
        this.regionServerIndexWithBestRegionCachedRatio = new int[this.numRegions];
        for (int region = 0; region < this.numRegions; ++region) {
            float bestRegionCacheRatio = 0.0f;
            int serverWithBestRegionCacheRatio = 0;
            for (int server = 0; server < this.numServers; ++server) {
                float regionCacheRatio = this.getRegionCacheRatioOnRegionServer(region, server);
                if (regionCacheRatio > 0.0f || server == this.regionIndexToServerIndex[region]) {
                    Pair regionServerPair = new Pair((Object)region, (Object)server);
                    this.regionIndexServerIndexRegionCachedRatio.put((Pair<Integer, Integer>)regionServerPair, Float.valueOf(regionCacheRatio));
                }
                if (regionCacheRatio > bestRegionCacheRatio) {
                    serverWithBestRegionCacheRatio = server;
                    bestRegionCacheRatio = regionCacheRatio;
                    continue;
                }
                if (regionCacheRatio != bestRegionCacheRatio || server != this.regionIndexToServerIndex[region]) continue;
                serverWithBestRegionCacheRatio = server;
            }
            this.regionServerIndexWithBestRegionCachedRatio[region] = serverWithBestRegionCacheRatio;
            Pair regionServerPair = new Pair((Object)region, (Object)this.regionIndexToServerIndex[region]);
            float tempRegionCacheRatio = this.regionIndexServerIndexRegionCachedRatio.get(regionServerPair).floatValue();
            if (!(tempRegionCacheRatio > bestRegionCacheRatio)) continue;
            LOG.warn("INVALID CONDITION: region {} on server {} cache ratio {} is greater than the best region cache ratio {} on server {}", new Object[]{this.regions[region].getEncodedName(), this.servers[this.regionIndexToServerIndex[region]], Float.valueOf(tempRegionCacheRatio), Float.valueOf(bestRegionCacheRatio), this.servers[serverWithBestRegionCacheRatio]});
        }
    }

    protected float getOrComputeRegionCacheRatio(int region, int server) {
        Pair regionServerPair;
        if (this.regionServerIndexWithBestRegionCachedRatio == null || this.regionIndexServerIndexRegionCachedRatio.isEmpty()) {
            this.computeRegionServerRegionCacheRatio();
        }
        return this.regionIndexServerIndexRegionCachedRatio.containsKey(regionServerPair = new Pair((Object)region, (Object)server)) ? this.regionIndexServerIndexRegionCachedRatio.get(regionServerPair).floatValue() : 0.0f;
    }

    public int[] getOrComputeServerWithBestRegionCachedRatio() {
        if (this.regionServerIndexWithBestRegionCachedRatio == null || this.regionIndexServerIndexRegionCachedRatio.isEmpty()) {
            this.computeRegionServerRegionCacheRatio();
        }
        return this.regionServerIndexWithBestRegionCachedRatio;
    }

    public int getRackForRegion(int region) {
        return this.serverIndexToRackIndex[this.regionIndexToServerIndex[region]];
    }

    public void doAction(BalanceAction action) {
        switch (action.getType()) {
            case NULL: {
                break;
            }
            case ASSIGN_REGION: {
                assert (action instanceof AssignRegionAction) : action.getClass();
                AssignRegionAction ar = (AssignRegionAction)action;
                this.regionsPerServer[ar.getServer()] = this.addRegion(this.regionsPerServer[ar.getServer()], ar.getRegion());
                this.regionMoved(ar.getRegion(), -1, ar.getServer());
                break;
            }
            case MOVE_REGION: {
                assert (action instanceof MoveRegionAction) : action.getClass();
                MoveRegionAction mra = (MoveRegionAction)action;
                this.regionsPerServer[mra.getFromServer()] = this.removeRegion(this.regionsPerServer[mra.getFromServer()], mra.getRegion());
                this.regionsPerServer[mra.getToServer()] = this.addRegion(this.regionsPerServer[mra.getToServer()], mra.getRegion());
                this.regionMoved(mra.getRegion(), mra.getFromServer(), mra.getToServer());
                break;
            }
            case SWAP_REGIONS: {
                assert (action instanceof SwapRegionsAction) : action.getClass();
                SwapRegionsAction a = (SwapRegionsAction)action;
                this.regionsPerServer[a.getFromServer()] = this.replaceRegion(this.regionsPerServer[a.getFromServer()], a.getFromRegion(), a.getToRegion());
                this.regionsPerServer[a.getToServer()] = this.replaceRegion(this.regionsPerServer[a.getToServer()], a.getToRegion(), a.getFromRegion());
                this.regionMoved(a.getFromRegion(), a.getFromServer(), a.getToServer());
                this.regionMoved(a.getToRegion(), a.getToServer(), a.getFromServer());
                break;
            }
            default: {
                throw new RuntimeException("Uknown action:" + (Object)((Object)action.getType()));
            }
        }
    }

    boolean wouldLowerAvailability(RegionInfo regionInfo, ServerName serverName) {
        if (!this.serversToIndex.containsKey(serverName.getAddress())) {
            return false;
        }
        int server = this.serversToIndex.get(serverName.getAddress());
        int region = this.regionsToIndex.get(regionInfo);
        for (int i : this.regionsPerServer[server]) {
            RegionInfo otherRegionInfo = this.regions[i];
            if (!RegionReplicaUtil.isReplicasForSameRegion((RegionInfo)regionInfo, (RegionInfo)otherRegionInfo)) continue;
            return true;
        }
        int primary = this.regionIndexToPrimaryIndex[region];
        if (primary == -1) {
            return false;
        }
        int result = this.checkLocationForPrimary(server, this.colocatedReplicaCountsPerServer, primary);
        if (result != 0) {
            return result > 0;
        }
        if (this.multiServersPerHost && (result = this.checkLocationForPrimary(this.serverIndexToHostIndex[server], this.colocatedReplicaCountsPerHost, primary)) != 0) {
            return result > 0;
        }
        if (this.numRacks > 1 && (result = this.checkLocationForPrimary(this.serverIndexToRackIndex[server], this.colocatedReplicaCountsPerRack, primary)) != 0) {
            return result > 0;
        }
        return false;
    }

    private int checkLocationForPrimary(int location, Int2IntCounterMap[] colocatedReplicaCountsPerLocation, int primary) {
        if (colocatedReplicaCountsPerLocation[location].containsKey(primary)) {
            for (int i = 0; i < colocatedReplicaCountsPerLocation.length; ++i) {
                if (i == location || colocatedReplicaCountsPerLocation[i].containsKey(primary)) continue;
                return 1;
            }
            return -1;
        }
        return 0;
    }

    void doAssignRegion(RegionInfo regionInfo, ServerName serverName) {
        if (!this.serversToIndex.containsKey(serverName.getAddress())) {
            return;
        }
        int server = this.serversToIndex.get(serverName.getAddress());
        int region = this.regionsToIndex.get(regionInfo);
        this.doAction(new AssignRegionAction(region, server));
    }

    void regionMoved(int region, int oldServer, int newServer) {
        this.regionIndexToServerIndex[region] = newServer;
        if (this.initialRegionIndexToServerIndex[region] == newServer) {
            --this.numMovedRegions;
        } else if (oldServer >= 0 && this.initialRegionIndexToServerIndex[region] == oldServer) {
            ++this.numMovedRegions;
        }
        int tableIndex = this.regionIndexToTableIndex[region];
        if (oldServer >= 0) {
            int[] nArray = this.numRegionsPerServerPerTable[tableIndex];
            int n = oldServer;
            nArray[n] = nArray[n] - 1;
        }
        int[] nArray = this.numRegionsPerServerPerTable[tableIndex];
        int n = newServer;
        nArray[n] = nArray[n] + 1;
        int primary = this.regionIndexToPrimaryIndex[region];
        if (oldServer >= 0) {
            this.colocatedReplicaCountsPerServer[oldServer].getAndDecrement(primary);
        }
        this.colocatedReplicaCountsPerServer[newServer].getAndIncrement(primary);
        if (this.multiServersPerHost) {
            this.updateForLocation(this.serverIndexToHostIndex, this.regionsPerHost, this.colocatedReplicaCountsPerHost, oldServer, newServer, primary, region);
        }
        if (this.numRacks > 1) {
            this.updateForLocation(this.serverIndexToRackIndex, this.regionsPerRack, this.colocatedReplicaCountsPerRack, oldServer, newServer, primary, region);
        }
    }

    private void updateForLocation(int[] serverIndexToLocation, int[][] regionsPerLocation, Int2IntCounterMap[] colocatedReplicaCountsPerLocation, int oldServer, int newServer, int primary, int region) {
        int newLocation = serverIndexToLocation[newServer];
        int oldLocation = oldServer >= 0 ? serverIndexToLocation[oldServer] : -1;
        if (newLocation != oldLocation) {
            regionsPerLocation[newLocation] = this.addRegion(regionsPerLocation[newLocation], region);
            colocatedReplicaCountsPerLocation[newLocation].getAndIncrement(primary);
            if (oldLocation >= 0) {
                regionsPerLocation[oldLocation] = this.removeRegion(regionsPerLocation[oldLocation], region);
                colocatedReplicaCountsPerLocation[oldLocation].getAndDecrement(primary);
            }
        }
    }

    int[] removeRegion(int[] regions, int regionIndex) {
        int[] newRegions = new int[regions.length - 1];
        int i = 0;
        for (i = 0; i < regions.length && regions[i] != regionIndex; ++i) {
            newRegions[i] = regions[i];
        }
        System.arraycopy(regions, i + 1, newRegions, i, newRegions.length - i);
        return newRegions;
    }

    int[] addRegion(int[] regions, int regionIndex) {
        int[] newRegions = new int[regions.length + 1];
        System.arraycopy(regions, 0, newRegions, 0, regions.length);
        newRegions[newRegions.length - 1] = regionIndex;
        return newRegions;
    }

    int[] addRegionSorted(int[] regions, int regionIndex) {
        int[] newRegions = new int[regions.length + 1];
        int i = 0;
        for (i = 0; i < regions.length && regions[i] <= regionIndex; ++i) {
        }
        System.arraycopy(regions, 0, newRegions, 0, i);
        System.arraycopy(regions, i, newRegions, i + 1, regions.length - i);
        newRegions[i] = regionIndex;
        return newRegions;
    }

    int[] replaceRegion(int[] regions, int regionIndex, int newRegionIndex) {
        int i = 0;
        for (i = 0; i < regions.length; ++i) {
            if (regions[i] != regionIndex) continue;
            regions[i] = newRegionIndex;
            break;
        }
        return regions;
    }

    void sortServersByRegionCount() {
        Arrays.sort(this.serverIndicesSortedByRegionCount, this.numRegionsComparator);
    }

    int getNumRegions(int server) {
        return this.regionsPerServer[server].length;
    }

    public Comparator<Integer> getNumRegionsComparator() {
        return this.numRegionsComparator;
    }

    boolean contains(int[] arr, int val) {
        return Arrays.binarySearch(arr, val) >= 0;
    }

    int getLowestLocalityRegionOnServer(int serverIndex) {
        if (this.regionFinder != null) {
            float lowestLocality = 1.0f;
            int lowestLocalityRegionIndex = -1;
            if (this.regionsPerServer[serverIndex].length == 0) {
                return -1;
            }
            for (int j = 0; j < this.regionsPerServer[serverIndex].length; ++j) {
                int regionIndex = this.regionsPerServer[serverIndex][j];
                HDFSBlocksDistribution distribution = this.regionFinder.getBlockDistribution(this.regions[regionIndex]);
                float locality = distribution.getBlockLocalityIndex(this.servers[serverIndex].getHostname());
                if (distribution.getUniqueBlocksTotalWeight() == 0L || !(locality < lowestLocality)) continue;
                lowestLocality = locality;
                lowestLocalityRegionIndex = j;
            }
            if (lowestLocalityRegionIndex == -1) {
                return -1;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Lowest locality region is " + this.regions[this.regionsPerServer[serverIndex][lowestLocalityRegionIndex]].getRegionNameAsString() + " with locality " + lowestLocality + " and its region server contains " + this.regionsPerServer[serverIndex].length + " regions");
            }
            return this.regionsPerServer[serverIndex][lowestLocalityRegionIndex];
        }
        return -1;
    }

    float getLocalityOfRegion(int region, int server) {
        if (this.regionFinder != null) {
            HDFSBlocksDistribution distribution = this.regionFinder.getBlockDistribution(this.regions[region]);
            return distribution.getBlockLocalityIndex(this.servers[server].getHostname());
        }
        return 0.0f;
    }

    void setNumRegions(int numRegions) {
        this.numRegions = numRegions;
    }

    void setNumMovedRegions(int numMovedRegions) {
        this.numMovedRegions = numMovedRegions;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder("Cluster={servers=[");
        for (ServerName sn : this.servers) {
            desc.append(sn.getAddress().toString()).append(", ");
        }
        desc.append("], serverIndicesSortedByRegionCount=").append(Arrays.toString((Object[])this.serverIndicesSortedByRegionCount)).append(", regionsPerServer=").append(Arrays.deepToString((Object[])this.regionsPerServer));
        desc.append(", numRegions=").append(this.numRegions).append(", numServers=").append(this.numServers).append(", numTables=").append(this.numTables).append(", numMovedRegions=").append(this.numMovedRegions).append('}');
        return desc.toString();
    }

    static enum LocalityType {
        SERVER,
        RACK;

    }

    static class DefaultRackManager
    extends RackManager {
        DefaultRackManager() {
        }

        @Override
        public String getRack(ServerName server) {
            return "Unknown Rack";
        }
    }
}

