/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotOfRegionAssignmentFromMeta {
    private static final Logger LOG = LoggerFactory.getLogger((String)SnapshotOfRegionAssignmentFromMeta.class.getName());
    private final Connection connection;
    private final Map<TableName, List<RegionInfo>> tableToRegionMap;
    private Map<RegionInfo, ServerName> regionToRegionServerMap;
    private final Map<String, RegionInfo> regionNameToRegionInfoMap;
    private final Map<ServerName, List<RegionInfo>> currentRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> secondaryRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> teritiaryRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> primaryRSToRegionMap;
    private final FavoredNodesPlan existingAssignmentPlan;
    private final Set<TableName> disabledTables;
    private final boolean excludeOfflinedSplitParents;

    public SnapshotOfRegionAssignmentFromMeta(Connection connection) {
        this(connection, new HashSet<TableName>(), false);
    }

    public SnapshotOfRegionAssignmentFromMeta(Connection connection, Set<TableName> disabledTables, boolean excludeOfflinedSplitParents) {
        this.connection = connection;
        this.tableToRegionMap = new HashMap<TableName, List<RegionInfo>>();
        this.regionToRegionServerMap = new HashMap<RegionInfo, ServerName>();
        this.currentRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.primaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.secondaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.teritiaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.regionNameToRegionInfoMap = new TreeMap<String, RegionInfo>();
        this.existingAssignmentPlan = new FavoredNodesPlan();
        this.disabledTables = disabledTables;
        this.excludeOfflinedSplitParents = excludeOfflinedSplitParents;
    }

    private void processMetaRecord(Result result) throws IOException {
        if (result == null || result.isEmpty()) {
            return;
        }
        RegionLocations rl = MetaTableAccessor.getRegionLocations((Result)result);
        if (rl == null) {
            return;
        }
        RegionInfo hri = rl.getRegionLocation(0).getRegion();
        if (hri == null) {
            return;
        }
        if (hri.getTable() == null) {
            return;
        }
        if (this.disabledTables.contains(hri.getTable())) {
            return;
        }
        if (this.excludeOfflinedSplitParents && hri.isSplit()) {
            return;
        }
        HRegionLocation[] hrls = rl.getRegionLocations();
        for (int i = 0; i < hrls.length; ++i) {
            if (hrls[i] == null || (hri = hrls[i].getRegion()) == null) continue;
            this.addAssignment(hri, hrls[i].getServerName());
            this.addRegion(hri);
        }
        hri = rl.getRegionLocation(0).getRegion();
        byte[] favoredNodes = result.getValue(HConstants.CATALOG_FAMILY, FavoredNodeAssignmentHelper.FAVOREDNODES_QUALIFIER);
        if (favoredNodes == null) {
            return;
        }
        Object[] favoredServerList = FavoredNodeAssignmentHelper.getFavoredNodesList(favoredNodes);
        this.existingAssignmentPlan.updateFavoredNodesMap(hri, Arrays.asList(favoredServerList));
        if (favoredServerList.length != 3) {
            LOG.warn("Insufficient favored nodes for region " + hri + " fn: " + Arrays.toString(favoredServerList));
        }
        for (int i = 0; i < favoredServerList.length; ++i) {
            if (i == FavoredNodesPlan.Position.PRIMARY.ordinal()) {
                this.addPrimaryAssignment(hri, (ServerName)favoredServerList[i]);
            }
            if (i == FavoredNodesPlan.Position.SECONDARY.ordinal()) {
                this.addSecondaryAssignment(hri, (ServerName)favoredServerList[i]);
            }
            if (i != FavoredNodesPlan.Position.TERTIARY.ordinal()) continue;
            this.addTeritiaryAssignment(hri, (ServerName)favoredServerList[i]);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() throws IOException {
        block28: {
            block27: {
                SnapshotOfRegionAssignmentFromMeta.LOG.info("Start to scan the hbase:meta for the current region assignment snappshot");
                metaTable = this.connection.getTable(TableName.META_TABLE_NAME);
                var2_2 = null;
                try {
                    scanner = metaTable.getScanner(HConstants.CATALOG_FAMILY);
                    var4_6 = null;
                    ** try [egrp 1[TRYBLOCK] [2, 3 : 38->112)] { 
lbl8:
                    // 1 sources

                    break block27;
lbl9:
                    // 1 sources

                    catch (Throwable var5_9) {
                        var4_6 = var5_9;
                        throw var5_9;
                    }
                }
                catch (Throwable var3_5) {
                    var2_2 = var3_5;
                    throw var3_5;
                }
            }
            while ((result = scanner.next()) != null) {
                try {
                    this.processMetaRecord(result);
                }
                catch (RuntimeException e) {
                    SnapshotOfRegionAssignmentFromMeta.LOG.error("Catch remote exception " + e.getMessage() + " when processing" + result);
                    throw e;
                }
            }
            break block28;
lbl24:
            // 1 sources

            finally {
                if (scanner != null) {
                    if (var4_6 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable var5_8) {
                            var4_6.addSuppressed(var5_8);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            finally {
                if (metaTable != null) {
                    if (var2_2 != null) {
                        try {
                            metaTable.close();
                        }
                        catch (Throwable var3_4) {
                            var2_2.addSuppressed(var3_4);
                        }
                    } else {
                        metaTable.close();
                    }
                }
            }
        }
        SnapshotOfRegionAssignmentFromMeta.LOG.info("Finished to scan the hbase:meta for the current region assignmentsnapshot");
    }

    private void addRegion(RegionInfo regionInfo) {
        this.regionNameToRegionInfoMap.put(regionInfo.getRegionNameAsString(), regionInfo);
        TableName tableName = regionInfo.getTable();
        List<RegionInfo> regionList = this.tableToRegionMap.get(tableName);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.tableToRegionMap.put(tableName, regionList);
    }

    private void addAssignment(RegionInfo regionInfo, ServerName server) {
        this.regionToRegionServerMap.put(regionInfo, server);
        if (server == null) {
            return;
        }
        List<RegionInfo> regionList = this.currentRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.currentRSToRegionMap.put(server, regionList);
    }

    private void addPrimaryAssignment(RegionInfo regionInfo, ServerName server) {
        List<RegionInfo> regionList = this.primaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.primaryRSToRegionMap.put(server, regionList);
    }

    private void addSecondaryAssignment(RegionInfo regionInfo, ServerName server) {
        List<RegionInfo> regionList = this.secondaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.secondaryRSToRegionMap.put(server, regionList);
    }

    private void addTeritiaryAssignment(RegionInfo regionInfo, ServerName server) {
        List<RegionInfo> regionList = this.teritiaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.teritiaryRSToRegionMap.put(server, regionList);
    }

    public Map<String, RegionInfo> getRegionNameToRegionInfoMap() {
        return this.regionNameToRegionInfoMap;
    }

    public Map<TableName, List<RegionInfo>> getTableToRegionMap() {
        return this.tableToRegionMap;
    }

    public Map<RegionInfo, ServerName> getRegionToRegionServerMap() {
        return this.regionToRegionServerMap;
    }

    public Map<ServerName, List<RegionInfo>> getRegionServerToRegionMap() {
        return this.currentRSToRegionMap;
    }

    public FavoredNodesPlan getExistingAssignmentPlan() {
        return this.existingAssignmentPlan;
    }

    public Set<TableName> getTableSet() {
        return this.tableToRegionMap.keySet();
    }

    public Map<ServerName, List<RegionInfo>> getSecondaryToRegionInfoMap() {
        return this.secondaryRSToRegionMap;
    }

    public Map<ServerName, List<RegionInfo>> getTertiaryToRegionInfoMap() {
        return this.teritiaryRSToRegionMap;
    }

    public Map<ServerName, List<RegionInfo>> getPrimaryToRegionInfoMap() {
        return this.primaryRSToRegionMap;
    }
}

