/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicasWithRestartScenarios {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicasWithRestartScenarios.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionReplicasWithRestartScenarios.class);
    @Rule
    public TestName name = new TestName();
    private static final int NB_SERVERS = 3;
    private Table table;
    private TableName tableName;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final byte[] f = HConstants.CATALOG_FAMILY;

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        HTU.startMiniCluster(3);
    }

    @Before
    public void before() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        this.table = TestRegionReplicasWithRestartScenarios.createTableDirectlyFromHTD(this.tableName);
    }

    @After
    public void after() throws IOException {
        this.table.close();
        HTU.deleteTable(this.tableName);
    }

    private static Table createTableDirectlyFromHTD(TableName tableName) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setRegionReplication(3);
        return HTU.createTable(builder.build(), (byte[][])new byte[][]{f}, TestRegionReplicasWithRestartScenarios.getSplits(20), new Configuration(HTU.getConfiguration()));
    }

    private static byte[][] getSplits(int numRegions) {
        RegionSplitter.UniformSplit split = new RegionSplitter.UniformSplit();
        split.setFirstRow(Bytes.toBytes((long)0L));
        split.setLastRow(Bytes.toBytes((long)Long.MAX_VALUE));
        return split.split(numRegions);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = false;
        HTU.shutdownMiniCluster();
    }

    private HRegionServer getRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(0);
    }

    private HRegionServer getSecondaryRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(1);
    }

    private HRegionServer getTertiaryRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(2);
    }

    @Test
    public void testRegionReplicasCreated() throws Exception {
        this.assertReplicaDistributed();
    }

    @Test
    public void testWhenRestart() throws Exception {
        HTU.getHBaseCluster().startRegionServerAndWait(60000L).getRegionServer();
        HRegionServer stopRegionServer = this.getRS();
        ServerName serverName = stopRegionServer.getServerName();
        ArrayList<HRegion> regionsOnStoppedServer = new ArrayList<HRegion>(stopRegionServer.getOnlineRegionsLocalContext());
        HTU.getHBaseCluster().stopRegionServer(serverName);
        HTU.getHBaseCluster().waitForRegionServerToStop(serverName, 60000L);
        HTU.waitTableAvailable(this.tableName);
        this.assertReplicaDistributed(regionsOnStoppedServer);
    }

    private void assertReplicaDistributed() throws Exception {
        this.assertReplicaDistributed(this.getRS().getOnlineRegionsLocalContext());
    }

    private void assertReplicaDistributed(Collection<HRegion> onlineRegions) throws Exception {
        LOG.info("ASSERT DISTRIBUTED {}", onlineRegions);
        boolean res = this.checkDuplicates(onlineRegions);
        Assert.assertFalse((boolean)res);
        Collection onlineRegions2 = this.getSecondaryRS().getOnlineRegionsLocalContext();
        res = this.checkDuplicates(onlineRegions2);
        Assert.assertFalse((boolean)res);
        Collection onlineRegions3 = this.getTertiaryRS().getOnlineRegionsLocalContext();
        this.checkDuplicates(onlineRegions3);
        Assert.assertFalse((boolean)res);
        int totalRegions = HTU.getMiniHBaseCluster().getLiveRegionServerThreads().stream().mapToInt(l -> l.getRegionServer().getOnlineRegions().size()).sum();
        Assert.assertEquals((long)62L, (long)totalRegions);
    }

    private boolean checkDuplicates(Collection<HRegion> onlineRegions3) throws Exception {
        ArrayList<HRegion> copyOfRegion = new ArrayList<HRegion>(onlineRegions3);
        for (Region region : copyOfRegion) {
            RegionInfo regionInfo = region.getRegionInfo();
            RegionInfo regionInfoForReplica = RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)regionInfo);
            int i = 0;
            for (Region region2 : onlineRegions3) {
                if (!regionInfoForReplica.equals(RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region2.getRegionInfo())) || ++i <= 1) continue;
                LOG.warn("Duplicate found {} and {}", (Object)region2.getRegionInfo(), (Object)region.getRegionInfo());
                Assert.assertTrue((boolean)Bytes.equals((byte[])region.getRegionInfo().getStartKey(), (byte[])region2.getRegionInfo().getStartKey()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])region.getRegionInfo().getEndKey(), (byte[])region2.getRegionInfo().getEndKey()));
                return true;
            }
        }
        return false;
    }
}

