/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionSplit {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSplit.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionSplit.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String ColumnFamilyName = "cf";
    private static final int startRowNum = 11;
    private static final int rowCount = 60;
    @Rule
    public TestName name = new TestName();

    private static void setupConf(Configuration conf) {
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestRegionSplit.setupConf(UTIL.getConfiguration());
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(1).numRegionServers(3).numDataNodes(3).build();
        UTIL.startMiniCluster(option);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(false);
        for (int i = 0; i < UTIL.getHBaseCluster().getLiveRegionServerThreads().size(); ++i) {
            UTIL.getHBaseCluster().getRegionServer(i).getCompactSplitThread().switchCompaction(false);
        }
    }

    @After
    public void tearDown() throws Exception {
        for (TableDescriptor htd : UTIL.getAdmin().listTableDescriptors()) {
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testSplitTableRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, ColumnFamilyName);
        this.insertData(tableName);
        int splitRowNum = 41;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        Assert.assertTrue((String)"not able to find a splittable region", (regions != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"not able to find a splittable region", (regions.length == 1 ? 1 : 0) != 0);
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), regions[0], splitKey));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        Assert.assertTrue((String)"not able to split table", (UTIL.getHBaseCluster().getRegions(tableName).size() == 2 ? 1 : 0) != 0);
        UTIL.getAdmin().disableTable(tableName);
        Thread.sleep(500L);
        UTIL.getHBaseCluster().stopMaster(0);
        UTIL.getHBaseCluster().waitOnMaster(0);
        Thread.sleep(500L);
        JVMClusterUtil.MasterThread t = UTIL.getHBaseCluster().startMaster();
        Thread.sleep(500L);
        UTIL.invalidateConnection();
        UTIL.getAdmin().enableTable(tableName);
        Thread.sleep(500L);
        Assert.assertEquals((String)"Table region not correct.", (long)2L, (long)UTIL.getHBaseCluster().getRegions(tableName).size());
    }

    private void insertData(TableName tableName) throws IOException {
        Table t = UTIL.getConnection().getTable(tableName);
        for (int i = 0; i < 30; ++i) {
            Put p = new Put(Bytes.toBytes((String)("" + (11 + i))));
            p.addColumn(Bytes.toBytes((String)ColumnFamilyName), Bytes.toBytes((String)"q1"), Bytes.toBytes((int)i));
            t.put(p);
            p = new Put(Bytes.toBytes((String)("" + (71 - i - 1))));
            p.addColumn(Bytes.toBytes((String)ColumnFamilyName), Bytes.toBytes((String)"q1"), Bytes.toBytes((int)i));
            t.put(p);
        }
        UTIL.getAdmin().flush(tableName);
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

