/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.SplitWALManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestSplitWALManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitWALManager.class);
    private static HBaseTestingUtility TEST_UTIL;
    private HMaster master;
    private SplitWALManager splitWALManager;
    private TableName TABLE_NAME;
    private byte[] FAMILY;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setBoolean("hbase.split.wal.zk.coordinated", false);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.wal.max.splitters", 1);
        TEST_UTIL.startMiniCluster(3);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.splitWALManager = this.master.getSplitWALManager();
        this.TABLE_NAME = TableName.valueOf((byte[])Bytes.toBytes((String)"TestSplitWALManager"));
        this.FAMILY = Bytes.toBytes((String)"test");
    }

    @After
    public void teardown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAcquireAndRelease() throws Exception {
        ArrayList<FakeServerProcedure> testProcedures = new ArrayList<FakeServerProcedure>();
        for (int i = 0; i < 4; ++i) {
            testProcedures.add(new FakeServerProcedure(TEST_UTIL.getHBaseCluster().getServerHoldingMeta()));
        }
        ServerName server = this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(0));
        Assert.assertNotNull((Object)server);
        Assert.assertNotNull((Object)this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(1)));
        Assert.assertNotNull((Object)this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(2)));
        ProcedureSuspendedException e = null;
        try {
            this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(3));
        }
        catch (ProcedureSuspendedException suspendException) {
            e = suspendException;
        }
        Assert.assertNotNull((Object)((Object)e));
        Assert.assertTrue((boolean)(e instanceof ProcedureSuspendedException));
        this.splitWALManager.releaseSplitWALWorker(server, ((MasterProcedureEnv)TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment()).getProcedureScheduler());
        Assert.assertNotNull((Object)this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(3)));
    }

    @Test
    public void testAddNewServer() throws Exception {
        ArrayList<FakeServerProcedure> testProcedures = new ArrayList<FakeServerProcedure>();
        for (int i = 0; i < 4; ++i) {
            testProcedures.add(new FakeServerProcedure(TEST_UTIL.getHBaseCluster().getServerHoldingMeta()));
        }
        ServerName server = this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(0));
        Assert.assertNotNull((Object)server);
        Assert.assertNotNull((Object)this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(1)));
        Assert.assertNotNull((Object)this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(2)));
        ProcedureSuspendedException e = null;
        try {
            this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(3));
        }
        catch (ProcedureSuspendedException suspendException) {
            e = suspendException;
        }
        Assert.assertNotNull((Object)((Object)e));
        Assert.assertTrue((boolean)(e instanceof ProcedureSuspendedException));
        JVMClusterUtil.RegionServerThread newServer = TEST_UTIL.getHBaseCluster().startRegionServer();
        newServer.waitForServerOnline();
        Assert.assertNotNull((Object)this.splitWALManager.acquireSplitWALWorker((Procedure)testProcedures.get(3)));
    }

    @Test
    public void testCreateSplitWALProcedures() throws Exception {
        TEST_UTIL.createTable(this.TABLE_NAME, this.FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        TEST_UTIL.loadTable(TEST_UTIL.getConnection().getTable(this.TABLE_NAME), this.FAMILY);
        ProcedureExecutor masterPE = this.master.getMasterProcedureExecutor();
        ServerName metaServer = TEST_UTIL.getHBaseCluster().getServerHoldingMeta();
        Path metaWALDir = new Path(TEST_UTIL.getDefaultRootDirPath(), AbstractFSWALProvider.getWALDirectoryName((String)metaServer.toString()));
        FileStatus[] wals = TEST_UTIL.getTestFileSystem().listStatus(metaWALDir, MasterWalManager.META_FILTER);
        Assert.assertEquals((long)1L, (long)wals.length);
        List testProcedures = this.splitWALManager.createSplitWALProcedures((List)Lists.newArrayList((Object[])new FileStatus[]{wals[0]}), metaServer);
        Assert.assertEquals((long)1L, (long)testProcedures.size());
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)masterPE, (Procedure)((Procedure)testProcedures.get(0)));
        Assert.assertFalse((boolean)TEST_UTIL.getTestFileSystem().exists(wals[0].getPath()));
        wals = TEST_UTIL.getTestFileSystem().listStatus(metaWALDir, MasterWalManager.NON_META_FILTER);
        Assert.assertEquals((long)1L, (long)wals.length);
        testProcedures = this.splitWALManager.createSplitWALProcedures((List)Lists.newArrayList((Object[])new FileStatus[]{wals[0]}), metaServer);
        Assert.assertEquals((long)1L, (long)testProcedures.size());
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)masterPE, (Procedure)((Procedure)testProcedures.get(0)));
        Assert.assertFalse((boolean)TEST_UTIL.getTestFileSystem().exists(wals[0].getPath()));
    }

    @Test
    public void testAcquireAndReleaseSplitWALWorker() throws Exception {
        ProcedureExecutor masterPE = this.master.getMasterProcedureExecutor();
        ArrayList<FakeServerProcedure> testProcedures = new ArrayList<FakeServerProcedure>();
        for (int i = 0; i < 3; ++i) {
            FakeServerProcedure procedure = new FakeServerProcedure(TEST_UTIL.getHBaseCluster().getRegionServer(i).getServerName());
            testProcedures.add(procedure);
            ProcedureTestingUtility.submitProcedure((ProcedureExecutor)masterPE, (Procedure)procedure, (long)0L, (long)0L);
        }
        TEST_UTIL.waitFor(10000L, () -> ((FakeServerProcedure)((Object)((Object)testProcedures.get(2)))).isWorkerAcquired());
        FakeServerProcedure failedProcedure = new FakeServerProcedure(TEST_UTIL.getHBaseCluster().getServerHoldingMeta());
        ProcedureTestingUtility.submitProcedure((ProcedureExecutor)masterPE, (Procedure)failedProcedure, (long)0L, (long)0L);
        TEST_UTIL.waitFor(20000L, () -> failedProcedure.isTriedToAcquire());
        Assert.assertFalse((boolean)failedProcedure.isWorkerAcquired());
        ((FakeServerProcedure)((Object)testProcedures.get(0))).countDown();
        TEST_UTIL.waitFor(10000L, () -> failedProcedure.isWorkerAcquired());
        Assert.assertTrue((boolean)((FakeServerProcedure)((Object)testProcedures.get(0))).isSuccess());
    }

    @Test
    public void testGetWALsToSplit() throws Exception {
        TEST_UTIL.createTable(this.TABLE_NAME, this.FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        TEST_UTIL.loadTable(TEST_UTIL.getConnection().getTable(this.TABLE_NAME), this.FAMILY);
        ServerName metaServer = TEST_UTIL.getHBaseCluster().getServerHoldingMeta();
        List metaWals = this.splitWALManager.getWALsToSplit(metaServer, true);
        Assert.assertEquals((long)1L, (long)metaWals.size());
        List wals = this.splitWALManager.getWALsToSplit(metaServer, false);
        Assert.assertEquals((long)1L, (long)wals.size());
        ServerName testServer = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(rs -> rs.getRegionServer().getServerName()).filter(rs -> rs != metaServer).findAny().get();
        metaWals = this.splitWALManager.getWALsToSplit(testServer, true);
        Assert.assertEquals((long)0L, (long)metaWals.size());
    }

    @Test
    public void testSplitLogs() throws Exception {
        TEST_UTIL.createTable(this.TABLE_NAME, this.FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        TEST_UTIL.loadTable(TEST_UTIL.getConnection().getTable(this.TABLE_NAME), this.FAMILY);
        ProcedureExecutor masterPE = this.master.getMasterProcedureExecutor();
        ServerName metaServer = TEST_UTIL.getHBaseCluster().getServerHoldingMeta();
        ServerName testServer = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(rs -> rs.getRegionServer().getServerName()).filter(rs -> rs != metaServer).findAny().get();
        List procedures = this.splitWALManager.splitWALs(testServer, false);
        Assert.assertEquals((long)1L, (long)procedures.size());
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)masterPE, (Procedure)((Procedure)procedures.get(0)));
        Assert.assertEquals((long)0L, (long)this.splitWALManager.getWALsToSplit(testServer, false).size());
        procedures = this.splitWALManager.splitWALs(metaServer, true);
        Assert.assertEquals((long)1L, (long)procedures.size());
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)masterPE, (Procedure)((Procedure)procedures.get(0)));
        Assert.assertEquals((long)0L, (long)this.splitWALManager.getWALsToSplit(metaServer, true).size());
        Assert.assertEquals((long)1L, (long)this.splitWALManager.getWALsToSplit(metaServer, false).size());
    }

    @Test
    public void testWorkerReloadWhenMasterRestart() throws Exception {
        ArrayList<FakeServerProcedure> testProcedures = new ArrayList<FakeServerProcedure>();
        for (int i = 0; i < 3; ++i) {
            FakeServerProcedure procedure = new FakeServerProcedure(TEST_UTIL.getHBaseCluster().getRegionServer(i).getServerName());
            testProcedures.add(procedure);
            ProcedureTestingUtility.submitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (Procedure)procedure, (long)0L, (long)0L);
        }
        TEST_UTIL.waitFor(10000L, () -> ((FakeServerProcedure)((Object)((Object)testProcedures.get(2)))).isWorkerAcquired());
        TEST_UTIL.getHBaseCluster().killMaster(this.master.getServerName());
        TEST_UTIL.getHBaseCluster().waitForMasterToStop(this.master.getServerName(), 20000L);
        TEST_UTIL.getHBaseCluster().startMaster();
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        FakeServerProcedure failedProcedure = new FakeServerProcedure(TEST_UTIL.getHBaseCluster().getServerHoldingMeta());
        ProcedureTestingUtility.submitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (Procedure)failedProcedure, (long)0L, (long)0L);
        TEST_UTIL.waitFor(20000L, () -> failedProcedure.isTriedToAcquire());
        Assert.assertFalse((boolean)failedProcedure.isWorkerAcquired());
        for (int i = 0; i < 3; ++i) {
            ((FakeServerProcedure)((Object)testProcedures.get(i))).countDown();
        }
        failedProcedure.countDown();
    }

    public static final class FakeServerProcedure
    extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.SplitWALState>
    implements ServerProcedureInterface {
        private ServerName serverName;
        private ServerName worker;
        private CountDownLatch barrier = new CountDownLatch(1);
        private boolean triedToAcquire = false;

        public FakeServerProcedure() {
        }

        public FakeServerProcedure(ServerName serverName) {
            this.serverName = serverName;
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public boolean hasMetaTableRegion() {
            return false;
        }

        public ServerProcedureInterface.ServerOperationType getServerOperationType() {
            return ServerProcedureInterface.ServerOperationType.SPLIT_WAL;
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SplitWALState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            SplitWALManager splitWALManager = env.getMasterServices().getSplitWALManager();
            switch (state) {
                case ACQUIRE_SPLIT_WAL_WORKER: {
                    this.triedToAcquire = true;
                    this.worker = splitWALManager.acquireSplitWALWorker((Procedure)this);
                    this.setNextState(MasterProcedureProtos.SplitWALState.DISPATCH_WAL_TO_WORKER);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case DISPATCH_WAL_TO_WORKER: {
                    this.barrier.await();
                    this.setNextState(MasterProcedureProtos.SplitWALState.RELEASE_SPLIT_WORKER);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case RELEASE_SPLIT_WORKER: {
                    splitWALManager.releaseSplitWALWorker(this.worker, env.getProcedureScheduler());
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }

        public boolean isWorkerAcquired() {
            return this.worker != null;
        }

        public boolean isTriedToAcquire() {
            return this.triedToAcquire;
        }

        public void countDown() {
            this.barrier.countDown();
        }

        protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SplitWALState state) throws IOException, InterruptedException {
        }

        protected MasterProcedureProtos.SplitWALState getState(int stateId) {
            return MasterProcedureProtos.SplitWALState.forNumber((int)stateId);
        }

        protected int getStateId(MasterProcedureProtos.SplitWALState state) {
            return state.getNumber();
        }

        protected MasterProcedureProtos.SplitWALState getInitialState() {
            return MasterProcedureProtos.SplitWALState.ACQUIRE_SPLIT_WAL_WORKER;
        }

        protected boolean holdLock(MasterProcedureEnv env) {
            return true;
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        }

        protected boolean abort(MasterProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
            MasterProcedureProtos.SplitWALData.Builder builder = MasterProcedureProtos.SplitWALData.newBuilder();
            builder.setWalPath("test").setCrashedServer(ProtobufUtil.toServerName((ServerName)this.serverName));
            serializer.serialize((Message)builder.build());
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
            MasterProcedureProtos.SplitWALData data = (MasterProcedureProtos.SplitWALData)serializer.deserialize(MasterProcedureProtos.SplitWALData.class);
            this.serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getCrashedServer());
        }
    }
}

