/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlwaysStandByHMaster
extends HMaster {
    public AlwaysStandByHMaster(Configuration conf) throws IOException {
        super(conf);
    }

    protected ActiveMasterManager createActiveMasterManager(ZKWatcher zk, ServerName sn, Server server) {
        return new AlwaysStandByMasterManager(zk, sn, server);
    }

    private static class AlwaysStandByMasterManager
    extends ActiveMasterManager {
        private static final Logger LOG = LoggerFactory.getLogger(AlwaysStandByMasterManager.class);

        AlwaysStandByMasterManager(ZKWatcher watcher, ServerName sn, Server master) {
            super(watcher, sn, master);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean blockUntilBecomingActiveMaster(int checkInterval, MonitoredTask startupStatus) {
            while (!this.master.isAborted() && !this.master.isStopped()) {
                startupStatus.setStatus("Forever looping to stay as a standby master.");
                try {
                    this.activeMasterServerName = null;
                    try {
                        if (MasterAddressTracker.getMasterAddress((ZKWatcher)this.watcher) != null) {
                            this.clusterHasActiveMaster.set(true);
                        }
                        Threads.sleepWithoutInterrupt((long)100L);
                    }
                    catch (IOException iOException) {}
                }
                catch (KeeperException e) {
                    this.master.abort("Received an unexpected KeeperException, aborting", (Throwable)e);
                    return false;
                }
                AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
                synchronized (atomicBoolean) {
                    while (this.clusterHasActiveMaster.get() && !this.master.isStopped()) {
                        try {
                            this.clusterHasActiveMaster.wait(checkInterval);
                        }
                        catch (InterruptedException e) {
                            LOG.debug("Interrupted waiting for master to die", (Throwable)e);
                        }
                    }
                    if (this.clusterShutDown.get()) {
                        this.master.stop("Cluster went down before this master became active");
                    }
                }
            }
            return false;
        }
    }
}

