/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruCachedBlock;
import org.apache.hadoop.hbase.io.hfile.TinyLfuBlockCache;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ClassSize;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestTinyLfuBlockCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTinyLfuBlockCache.class);

    @Test
    public void testCacheSimple() throws Exception {
        long maxSize = 1000000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 101);
        TinyLfuBlockCache cache = new TinyLfuBlockCache(maxSize, blockSize, blockSize, Runnable::run);
        CachedItem[] blocks = this.generateRandomBlocks(100, blockSize);
        long expectedCacheSize = cache.heapSize();
        for (CachedItem block : blocks) {
            Assert.assertTrue((cache.getBlock(block.cacheKey, true, false, true) == null ? 1 : 0) != 0);
        }
        for (CachedItem block : blocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
            expectedCacheSize += block.heapSize();
        }
        Assert.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        for (CachedItem block : blocks) {
            Cacheable buf = cache.getBlock(block.cacheKey, true, false, true);
            Assert.assertTrue((buf != null ? 1 : 0) != 0);
            Assert.assertEquals((long)buf.heapSize(), (long)block.heapSize());
        }
        long expectedBlockCount = cache.getBlockCount();
        for (CachedItem block : blocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
        }
        Assert.assertEquals((String)"Cache should ignore cache requests for blocks already in cache", (long)expectedBlockCount, (long)cache.getBlockCount());
        Assert.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        for (CachedItem block : blocks) {
            Cacheable buf = cache.getBlock(block.cacheKey, true, false, true);
            Assert.assertTrue((buf != null ? 1 : 0) != 0);
            Assert.assertEquals((long)buf.heapSize(), (long)block.heapSize());
        }
        Assert.assertEquals((long)0L, (long)cache.getStats().getEvictionCount());
    }

    @Test
    public void testCacheEvictionSimple() throws Exception {
        CachedItem[] blocks;
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 10);
        TinyLfuBlockCache cache = new TinyLfuBlockCache(maxSize, blockSize, blockSize, Runnable::run);
        for (CachedItem block : blocks = this.generateFixedBlocks(11, blockSize, "block")) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
        }
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictionCount());
        Assert.assertTrue((cache.heapSize() < maxSize ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)cache.getBlockCount());
    }

    @Test
    public void testScanResistance() throws Exception {
        int i;
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        TinyLfuBlockCache cache = new TinyLfuBlockCache(maxSize, blockSize, blockSize, Runnable::run);
        CachedItem[] singleBlocks = this.generateFixedBlocks(20, blockSize, "single");
        CachedItem[] multiBlocks = this.generateFixedBlocks(5, blockSize, "multi");
        for (i = 0; i < 5; ++i) {
            cache.cacheBlock(singleBlocks[i].cacheKey, (Cacheable)singleBlocks[i]);
            cache.cacheBlock(multiBlocks[i].cacheKey, (Cacheable)multiBlocks[i]);
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 10; ++j) {
                CachedItem block = multiBlocks[i];
                cache.getBlock(block.cacheKey, true, false, true);
            }
        }
        for (i = 5; i < 18; ++i) {
            cache.cacheBlock(singleBlocks[i].cacheKey, (Cacheable)singleBlocks[i]);
        }
        for (CachedItem block : multiBlocks) {
            Assert.assertTrue((boolean)cache.cache.asMap().containsKey(block.cacheKey));
        }
        Assert.assertEquals((long)10L, (long)cache.getBlockCount());
        Assert.assertEquals((long)13L, (long)cache.getStats().getEvictionCount());
    }

    @Test
    public void testMaxBlockSize() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        TinyLfuBlockCache cache = new TinyLfuBlockCache(maxSize, blockSize, blockSize, Runnable::run);
        CachedItem[] tooLong = this.generateFixedBlocks(10, 2L * blockSize, "long");
        CachedItem[] small = this.generateFixedBlocks(15, blockSize / 2L, "small");
        for (CachedItem i : tooLong) {
            cache.cacheBlock(i.cacheKey, (Cacheable)i);
        }
        for (CachedItem i : small) {
            cache.cacheBlock(i.cacheKey, (Cacheable)i);
        }
        Assert.assertEquals((long)15L, (long)cache.getBlockCount());
        for (CachedItem i : small) {
            Assert.assertNotNull((Object)cache.getBlock(i.cacheKey, true, false, false));
        }
        for (CachedItem i : tooLong) {
            Assert.assertNull((Object)cache.getBlock(i.cacheKey, true, false, false));
        }
        Assert.assertEquals((long)10L, (long)cache.getStats().getFailedInserts());
    }

    @Test
    public void testResizeBlockCache() throws Exception {
        CachedItem[] blocks;
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        TinyLfuBlockCache cache = new TinyLfuBlockCache(maxSize, blockSize, blockSize, Runnable::run);
        for (CachedItem block : blocks = this.generateFixedBlocks(10, blockSize, "block")) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
        }
        Assert.assertEquals((long)10L, (long)cache.getBlockCount());
        Assert.assertEquals((long)0L, (long)cache.getStats().getEvictionCount());
        cache.setMaxSize(maxSize / 2L);
        Assert.assertEquals((long)5L, (long)cache.getBlockCount());
        Assert.assertEquals((long)5L, (long)cache.getStats().getEvictedCount());
    }

    private CachedItem[] generateFixedBlocks(int numBlocks, int size, String pfx) {
        CachedItem[] blocks = new CachedItem[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new CachedItem(pfx + i, size);
        }
        return blocks;
    }

    private CachedItem[] generateFixedBlocks(int numBlocks, long size, String pfx) {
        return this.generateFixedBlocks(numBlocks, (int)size, pfx);
    }

    private CachedItem[] generateRandomBlocks(int numBlocks, long maxSize) {
        CachedItem[] blocks = new CachedItem[numBlocks];
        Random r = new Random();
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new CachedItem("block" + i, r.nextInt((int)maxSize) + 1);
        }
        return blocks;
    }

    private long calculateBlockSize(long maxSize, int numBlocks) {
        long roughBlockSize = maxSize / (long)numBlocks;
        int numEntries = (int)Math.ceil(1.2 * (double)maxSize / (double)roughBlockSize);
        long totalOverhead = LruBlockCache.CACHE_FIXED_OVERHEAD + (long)ClassSize.CONCURRENT_HASHMAP + (long)(numEntries * ClassSize.CONCURRENT_HASHMAP_ENTRY) + (long)(16 * ClassSize.CONCURRENT_HASHMAP_SEGMENT);
        long negateBlockSize = totalOverhead / (long)numEntries;
        return ClassSize.align((long)((long)Math.floor((float)(roughBlockSize - (negateBlockSize += LruCachedBlock.PER_BLOCK_OVERHEAD)) * 0.99f)));
    }

    private long calculateBlockSizeDefault(long maxSize, int numBlocks) {
        long roughBlockSize = maxSize / (long)numBlocks;
        int numEntries = (int)Math.ceil(1.2 * (double)maxSize / (double)roughBlockSize);
        long totalOverhead = LruBlockCache.CACHE_FIXED_OVERHEAD + (long)ClassSize.CONCURRENT_HASHMAP + (long)(numEntries * ClassSize.CONCURRENT_HASHMAP_ENTRY) + (long)(16 * ClassSize.CONCURRENT_HASHMAP_SEGMENT);
        long negateBlockSize = totalOverhead / (long)numEntries;
        return ClassSize.align((long)((long)Math.floor((float)(roughBlockSize - (negateBlockSize += LruCachedBlock.PER_BLOCK_OVERHEAD)) * 0.99f)));
    }

    private static class CachedItem
    implements Cacheable {
        BlockCacheKey cacheKey;
        int size;

        CachedItem(String blockName, int size) {
            this.cacheKey = new BlockCacheKey(blockName, 0L);
            this.size = size;
        }

        public long heapSize() {
            return ClassSize.align((int)this.size);
        }

        public int getSerializedLength() {
            return 0;
        }

        public CacheableDeserializer<Cacheable> getDeserializer() {
            return null;
        }

        public BlockType getBlockType() {
            return BlockType.DATA;
        }

        public void serialize(ByteBuffer destination, boolean includeNextBlockMetadata) {
        }
    }
}

