/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFilePreadReader;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, MediumTests.class})
public class TestHFileWriterV3WithDataEncoders {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileWriterV3WithDataEncoders.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileWriterV3WithDataEncoders.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private FileSystem fs;
    private boolean useTags;
    private DataBlockEncoding dataBlockEncoding;

    public TestHFileWriterV3WithDataEncoders(boolean useTags, DataBlockEncoding dataBlockEncoding) {
        this.useTags = useTags;
        this.dataBlockEncoding = dataBlockEncoding;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        DataBlockEncoding[] dataBlockEncodings = DataBlockEncoding.values();
        Object[][] params = new Object[dataBlockEncodings.length * 2 - 2][];
        int i = 0;
        for (DataBlockEncoding dataBlockEncoding : dataBlockEncodings) {
            if (dataBlockEncoding == DataBlockEncoding.NONE) continue;
            params[i++] = new Object[]{false, dataBlockEncoding};
            params[i++] = new Object[]{true, dataBlockEncoding};
        }
        return Arrays.asList(params);
    }

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testHFileFormatV3() throws IOException {
        this.testHFileFormatV3Internals(this.useTags);
    }

    private void testHFileFormatV3Internals(boolean useTags) throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testHFileFormatV3");
        Compression.Algorithm compressAlgo = Compression.Algorithm.GZ;
        int entryCount = 10000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, 10000, false, useTags);
    }

    @Test
    public void testMidKeyInHFile() throws IOException {
        this.testMidKeyInHFileInternals(this.useTags);
    }

    private void testMidKeyInHFileInternals(boolean useTags) throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testMidKeyInHFile");
        Compression.Algorithm compressAlgo = Compression.Algorithm.NONE;
        int entryCount = 50000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, entryCount, true, useTags);
    }

    private void writeDataAndReadFromHFile(Path hfilePath, Compression.Algorithm compressAlgo, int entryCount, boolean findMidKey, boolean useTags) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(4096).withIncludesTags(useTags).withDataBlockEncoding(this.dataBlockEncoding).withCellComparator((CellComparator)CellComparatorImpl.COMPARATOR).withCompression(compressAlgo).build();
        CacheConfig cacheConfig = new CacheConfig(this.conf);
        HFile.Writer writer = new HFile.WriterFactory(this.conf, cacheConfig).withPath(this.fs, hfilePath).withFileContext(context).create();
        Random rand = new Random(9713312L);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(entryCount);
        this.writeKeyValues(entryCount, useTags, writer, rand, keyValues);
        FSDataInputStream fsdis = this.fs.open(hfilePath);
        long fileSize = this.fs.getFileStatus(hfilePath).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream((FSDataInputStream)fsdis, (long)fileSize);
        Assert.assertEquals((long)3L, (long)trailer.getMajorVersion());
        Assert.assertEquals((long)entryCount, (long)trailer.getEntryCount());
        HFileContext meta = new HFileContextBuilder().withCompression(compressAlgo).withIncludesMvcc(true).withIncludesTags(useTags).withDataBlockEncoding(this.dataBlockEncoding).withHBaseCheckSum(true).build();
        ReaderContext readerContext = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(fsdis)).withFilePath(hfilePath).withFileSystem(this.fs).withFileSize(fileSize).build();
        HFileBlock.FSReaderImpl blockReader = new HFileBlock.FSReaderImpl(readerContext, meta, ByteBuffAllocator.HEAP);
        CellComparator comparator = trailer.createComparator();
        HFileBlockIndex.CellBasedKeyBlockIndexReader dataBlockIndexReader = new HFileBlockIndex.CellBasedKeyBlockIndexReader(comparator, trailer.getNumDataIndexLevels());
        HFileBlockIndex.ByteArrayKeyBlockIndexReader metaBlockIndexReader = new HFileBlockIndex.ByteArrayKeyBlockIndexReader(1);
        HFileBlock.BlockIterator blockIter = blockReader.blockRange(trailer.getLoadOnOpenDataOffset(), fileSize - (long)trailer.getTrailerSize());
        dataBlockIndexReader.readMultiLevelIndexRoot(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), trailer.getDataIndexCount());
        FSDataInputStreamWrapper wrapper = new FSDataInputStreamWrapper(this.fs, hfilePath);
        readerContext = new ReaderContextBuilder().withFilePath(hfilePath).withFileSize(fileSize).withFileSystem(wrapper.getHfs()).withInputStreamWrapper(wrapper).build();
        HFileInfo hfile = new HFileInfo(readerContext, this.conf);
        HFilePreadReader reader = new HFilePreadReader(readerContext, hfile, cacheConfig, this.conf);
        hfile.initMetaAndIndex((HFile.Reader)reader);
        if (findMidKey) {
            Cell midkey = dataBlockIndexReader.midkey((HFile.CachingBlockReader)reader);
            Assert.assertNotNull((String)"Midkey should not be null", (Object)midkey);
        }
        metaBlockIndexReader.readRootIndex((DataInput)blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX).getByteStream(), trailer.getMetaIndexCount());
        HFileInfo fileInfo = new HFileInfo();
        fileInfo.read(blockIter.nextBlockWithBlockType(BlockType.FILE_INFO).getByteStream());
        byte[] keyValueFormatVersion = fileInfo.get((Object)HFileWriterImpl.KEY_VALUE_VERSION);
        boolean includeMemstoreTS = keyValueFormatVersion != null && Bytes.toInt((byte[])keyValueFormatVersion) > 0;
        int entriesRead = 0;
        int blocksRead = 0;
        long memstoreTS = 0L;
        DataBlockEncoder encoder = this.dataBlockEncoding.getEncoder();
        long curBlockPos = this.scanBlocks(entryCount, context, keyValues, fsdis, trailer, meta, (HFileBlock.FSReader)blockReader, entriesRead, blocksRead, encoder);
        int metaCounter = 0;
        while (fsdis.getPos() < trailer.getLoadOnOpenDataOffset()) {
            LOG.info("Current offset: {}, scanning until {}", (Object)fsdis.getPos(), (Object)trailer.getLoadOnOpenDataOffset());
            HFileBlock block = blockReader.readBlockData(curBlockPos, -1L, false, false, true).unpack(context, (HFileBlock.FSReader)blockReader);
            Assert.assertEquals((Object)BlockType.META, (Object)block.getBlockType());
            Text t = new Text();
            ByteBuff buf = block.getBufferWithoutHeader();
            if (Writables.getWritable((byte[])buf.array(), (int)buf.arrayOffset(), (int)buf.limit(), (Writable)t) == null) {
                throw new IOException("Failed to deserialize block " + this + " into a " + t.getClass().getSimpleName());
            }
            Text expectedText = metaCounter == 0 ? new Text("Paris") : (metaCounter == 1 ? new Text("Moscow") : new Text("Washington, D.C."));
            Assert.assertEquals((Object)expectedText, (Object)t);
            LOG.info("Read meta block data: " + t);
            ++metaCounter;
            curBlockPos += (long)block.getOnDiskSizeWithHeader();
        }
        fsdis.close();
        reader.close();
    }

    private long scanBlocks(int entryCount, HFileContext context, List<KeyValue> keyValues, FSDataInputStream fsdis, FixedFileTrailer trailer, HFileContext meta, HFileBlock.FSReader blockReader, int entriesRead, int blocksRead, DataBlockEncoder encoder) throws IOException {
        long curBlockPos;
        HFileBlock block;
        fsdis.seek(0L);
        for (curBlockPos = 0L; curBlockPos <= trailer.getLastDataBlockOffset(); curBlockPos += (long)block.getOnDiskSizeWithHeader()) {
            HFileBlockDecodingContext ctx = blockReader.getBlockDecodingContext();
            block = blockReader.readBlockData(curBlockPos, -1L, false, false, true).unpack(context, blockReader);
            Assert.assertEquals((Object)BlockType.ENCODED_DATA, (Object)block.getBlockType());
            ByteBuff origBlock = block.getBufferReadOnly();
            int pos = block.headerSize() + 2;
            origBlock.position(pos);
            origBlock.limit(pos + block.getUncompressedSizeWithoutHeader() - 2);
            ByteBuff buf = origBlock.slice();
            DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(encoder.newDataBlockDecodingContext(meta));
            seeker.setCurrentBuffer(buf);
            Cell res = seeker.getCell();
            KeyValue kv = keyValues.get(entriesRead);
            Assert.assertEquals((long)0L, (long)CellComparatorImpl.COMPARATOR.compare(res, (Cell)kv));
            ++entriesRead;
            while (seeker.next()) {
                res = seeker.getCell();
                kv = keyValues.get(entriesRead);
                Assert.assertEquals((long)0L, (long)CellComparatorImpl.COMPARATOR.compare(res, (Cell)kv));
                ++entriesRead;
            }
            ++blocksRead;
        }
        LOG.info("Finished reading: entries={}, blocksRead = {}", (Object)entriesRead, (Object)blocksRead);
        Assert.assertEquals((long)entryCount, (long)entriesRead);
        return curBlockPos;
    }

    private void writeKeyValues(int entryCount, boolean useTags, HFile.Writer writer, Random rand, List<KeyValue> keyValues) throws IOException {
        for (int i = 0; i < entryCount; ++i) {
            byte[] keyBytes = RandomKeyValueUtil.randomOrderedKey(rand, i);
            byte[] valueBytes = RandomKeyValueUtil.randomValue(rand);
            KeyValue keyValue = null;
            if (useTags) {
                ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>();
                for (int j = 0; j < 1 + rand.nextInt(4); ++j) {
                    byte[] tagBytes = new byte[16];
                    rand.nextBytes(tagBytes);
                    tags.add(new ArrayBackedTag(1, tagBytes));
                }
                keyValue = new KeyValue(keyBytes, null, null, Long.MAX_VALUE, valueBytes, tags);
            } else {
                keyValue = new KeyValue(keyBytes, null, null, Long.MAX_VALUE, valueBytes);
            }
            writer.append((Cell)keyValue);
            keyValues.add(keyValue);
        }
        writer.appendMetaBlock("CAPITAL_OF_USA", (Writable)new Text("Washington, D.C."));
        writer.appendMetaBlock("CAPITAL_OF_RUSSIA", (Writable)new Text("Moscow"));
        writer.appendMetaBlock("CAPITAL_OF_FRANCE", (Writable)new Text("Paris"));
        writer.close();
    }
}

