/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.junit.rules.ExternalResource;

public class ConnectionRule
extends ExternalResource {
    private final Supplier<CompletableFuture<AsyncConnection>> connectionSupplier;
    private AsyncConnection connection;

    public ConnectionRule(Supplier<CompletableFuture<AsyncConnection>> connectionSupplier) {
        this.connectionSupplier = connectionSupplier;
    }

    public AsyncConnection getConnection() {
        return this.connection;
    }

    protected void before() throws Throwable {
        this.connection = this.connectionSupplier.get().join();
    }

    protected void after() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

