/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import java.util.Optional;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SplitWALManager;
import org.apache.hadoop.hbase.master.procedure.SplitWALProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSplitWALProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitWALProcedure.class);
    private static HBaseTestingUtility TEST_UTIL;
    private HMaster master;
    private TableName TABLE_NAME;
    private SplitWALManager splitWALManager;
    private byte[] FAMILY;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setBoolean("hbase.split.wal.zk.coordinated", false);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.wal.max.splitters", 1);
        TEST_UTIL.startMiniCluster(3);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.splitWALManager = this.master.getSplitWALManager();
        this.TABLE_NAME = TableName.valueOf((byte[])Bytes.toBytes((String)"TestSplitWALProcedure"));
        this.FAMILY = Bytes.toBytes((String)"test");
    }

    @After
    public void teardown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (boolean)false);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHandleDeadWorker() throws Exception {
        Table table = TEST_UTIL.createTable(this.TABLE_NAME, this.FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        for (int i = 0; i < 10; ++i) {
            TEST_UTIL.loadTable(table, this.FAMILY);
        }
        HRegionServer testServer = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        ProcedureExecutor masterPE = this.master.getMasterProcedureExecutor();
        List wals = this.splitWALManager.getWALsToSplit(testServer.getServerName(), false);
        Assert.assertEquals((long)1L, (long)wals.size());
        TEST_UTIL.getHBaseCluster().killRegionServer(testServer.getServerName());
        TEST_UTIL.waitFor(30000L, () -> this.master.getProcedures().stream().anyMatch(procedure -> procedure instanceof SplitWALProcedure));
        Procedure splitWALProcedure = this.master.getProcedures().stream().filter(procedure -> procedure instanceof SplitWALProcedure).findAny().get();
        Assert.assertNotNull((Object)splitWALProcedure);
        TEST_UTIL.waitFor(5000L, () -> ((SplitWALProcedure)splitWALProcedure).getWorker() != null);
        TEST_UTIL.getHBaseCluster().killRegionServer(((SplitWALProcedure)splitWALProcedure).getWorker());
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)masterPE, (long)splitWALProcedure.getProcId());
        Assert.assertTrue((boolean)splitWALProcedure.isSuccess());
        ProcedureTestingUtility.waitAllProcedures((ProcedureExecutor)masterPE);
    }

    @Test
    public void testMasterRestart() throws Exception {
        Table table = TEST_UTIL.createTable(this.TABLE_NAME, this.FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        for (int i = 0; i < 10; ++i) {
            TEST_UTIL.loadTable(table, this.FAMILY);
        }
        HRegionServer testServer = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        List wals = this.splitWALManager.getWALsToSplit(testServer.getServerName(), false);
        Assert.assertEquals((long)1L, (long)wals.size());
        SplitWALProcedure splitWALProcedure = new SplitWALProcedure(((FileStatus)wals.get(0)).getPath().toString(), testServer.getServerName());
        long pid = ProcedureTestingUtility.submitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (Procedure)splitWALProcedure, (long)0L, (long)0L);
        TEST_UTIL.waitFor(5000L, () -> splitWALProcedure.getWorker() != null);
        TEST_UTIL.getHBaseCluster().killMaster(this.master.getServerName());
        TEST_UTIL.getHBaseCluster().waitForMasterToStop(this.master.getServerName(), 20000L);
        TEST_UTIL.getHBaseCluster().startMaster();
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (long)pid);
        Optional<Procedure> procedure = this.master.getProcedures().stream().filter(p -> p.getProcId() == pid).findAny();
        Assert.assertTrue((boolean)procedure.isPresent());
        Assert.assertTrue((boolean)procedure.get().isSuccess());
        Assert.assertFalse((boolean)TEST_UTIL.getTestFileSystem().exists(((FileStatus)wals.get(0)).getPath()));
    }
}

