/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncRegionAdminApi
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncRegionAdminApi.class);

    @Test
    public void testAssignRegionAndUnassignRegion() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        RegionInfo hri = (RegionInfo)am.getRegionStates().getRegionsOfTable(this.tableName).get(0);
        RegionStates regionStates = am.getRegionStates();
        ServerName serverName = regionStates.getRegionServerOfRegion(hri);
        TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        Assert.assertTrue((boolean)regionStates.getRegionState(hri).isOpened());
        try {
            this.admin.assign(hri.getRegionName()).get();
            Assert.fail((String)"Should fail when assigning an already onlined region");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(DoNotRetryRegionException.class));
        }
        Assert.assertFalse((boolean)am.getRegionStates().getRegionStateNode(hri).isInTransition());
        Assert.assertTrue((boolean)regionStates.getRegionState(hri).isOpened());
        this.admin.unassign(hri.getRegionName(), true).get();
        Assert.assertFalse((boolean)am.getRegionStates().getRegionStateNode(hri).isInTransition());
        Assert.assertTrue((boolean)regionStates.getRegionState(hri).isClosed());
    }

    RegionInfo createTableAndGetOneRegion(TableName tableName) throws IOException, InterruptedException, ExecutionException {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        this.admin.createTable(desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 5).get();
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        long timeoutTime = System.currentTimeMillis() + 3000L;
        List regions;
        while ((regions = master.getAssignmentManager().getRegionStates().getRegionsOfTable(tableName)).size() <= 3) {
            long now = System.currentTimeMillis();
            if (now > timeoutTime) {
                Assert.fail((String)"Could not find an online region");
            }
            Thread.sleep(10L);
        }
        return (RegionInfo)regions.get(2);
    }

    @Test
    public void testGetRegionByStateOfTable() throws Exception {
        RegionInfo hri = this.createTableAndGetOneRegion(this.tableName);
        RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
        Assert.assertTrue((boolean)((List)regionStates.getRegionByStateOfTable(this.tableName).get(RegionState.State.OPEN)).stream().anyMatch(r -> RegionInfo.COMPARATOR.compare(r, hri) == 0));
        Assert.assertFalse((boolean)((List)regionStates.getRegionByStateOfTable(TableName.valueOf((String)"I_am_the_phantom")).get(RegionState.State.OPEN)).stream().anyMatch(r -> RegionInfo.COMPARATOR.compare(r, hri) == 0));
    }

    @Test
    public void testMoveRegion() throws Exception {
        ServerName sn;
        JVMClusterUtil.RegionServerThread regionServer;
        HRegionServer destServer;
        this.admin.balancerSwitch(false).join();
        RegionInfo hri = this.createTableAndGetOneRegion(this.tableName);
        RawAsyncHBaseAdmin rawAdmin = (RawAsyncHBaseAdmin)ASYNC_CONN.getAdmin();
        ServerName serverName = ((HRegionLocation)rawAdmin.getRegionLocation(hri.getRegionName()).get()).getServerName();
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        ServerManager serverManager = master.getServerManager();
        ServerName destServerName = null;
        List<JVMClusterUtil.RegionServerThread> regionServers = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads();
        Iterator<JVMClusterUtil.RegionServerThread> iterator = regionServers.iterator();
        while (iterator.hasNext() && ((destServerName = (destServer = (regionServer = iterator.next()).getRegionServer()).getServerName()).equals((Object)serverName) || !serverManager.isServerOnline(destServerName))) {
        }
        Assert.assertTrue((destServerName != null && !destServerName.equals((Object)serverName) ? 1 : 0) != 0);
        this.admin.move(hri.getRegionName(), destServerName).get();
        long timeoutTime = System.currentTimeMillis() + 30000L;
        while ((sn = ((HRegionLocation)rawAdmin.getRegionLocation(hri.getRegionName()).get()).getServerName()) == null || !sn.equals((Object)destServerName)) {
            long now = System.currentTimeMillis();
            if (now > timeoutTime) {
                Assert.fail((String)("Failed to move the region in time: " + hri));
            }
            Thread.sleep(100L);
        }
        this.admin.balancerSwitch(true).join();
    }

    @Test
    public void testGetOnlineRegions() throws Exception {
        this.createTableAndGetOneRegion(this.tableName);
        AtomicInteger regionServerCount = new AtomicInteger(0);
        TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(rsThread -> rsThread.getRegionServer()).forEach(rs -> {
            ServerName serverName = rs.getServerName();
            try {
                Assert.assertEquals((long)((List)this.admin.getRegions(serverName).get()).size(), (long)rs.getRegions().size());
            }
            catch (Exception e) {
                Assert.fail((String)("admin.getOnlineRegions() method throws a exception: " + e.getMessage()));
            }
            regionServerCount.incrementAndGet();
        });
        Assert.assertEquals((long)TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().size(), (long)regionServerCount.get());
    }

    @Test
    public void testFlushTableAndRegion() throws Exception {
        RegionInfo hri = this.createTableAndGetOneRegion(this.tableName);
        ServerName serverName = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(rsThread -> rsThread.getRegionServer()).filter(rs -> rs.getServerName().equals((Object)serverName)).findFirst().get();
        ASYNC_CONN.getTable(this.tableName).put(new Put(hri.getStartKey()).addColumn(FAMILY, FAMILY_0, Bytes.toBytes((String)"value-1"))).join();
        Assert.assertTrue((regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreDataSize() > 0L ? 1 : 0) != 0);
        LOG.info("flushing region: " + Bytes.toStringBinary((byte[])hri.getRegionName()));
        this.admin.flushRegion(hri.getRegionName()).get();
        LOG.info("blocking until flush is complete: " + Bytes.toStringBinary((byte[])hri.getRegionName()));
        Threads.sleepWithoutInterrupt((long)500L);
        while (regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreDataSize() > 0L) {
            Threads.sleep((long)50L);
        }
        Assert.assertEquals((long)regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreDataSize(), (long)0L);
        ASYNC_CONN.getTable(this.tableName).put(new Put(hri.getStartKey()).addColumn(FAMILY, FAMILY_0, Bytes.toBytes((String)"value-2"))).join();
        Assert.assertTrue((regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreDataSize() > 0L ? 1 : 0) != 0);
        this.admin.flush(this.tableName).get();
        Threads.sleepWithoutInterrupt((long)500L);
        while (regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreDataSize() > 0L) {
            Threads.sleep((long)50L);
        }
        Assert.assertEquals((long)regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreDataSize(), (long)0L);
    }

    private void waitUntilMobCompactionFinished(TableName tableName) throws ExecutionException, InterruptedException {
        long finished = EnvironmentEdgeManager.currentTime() + 60000L;
        CompactionState state = (CompactionState)this.admin.getCompactionState(tableName, CompactType.MOB).get();
        while (EnvironmentEdgeManager.currentTime() < finished && state != CompactionState.NONE) {
            Thread.sleep(10L);
            state = (CompactionState)this.admin.getCompactionState(tableName, CompactType.MOB).get();
        }
        Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
    }

    @Test
    public void testCompactMob() throws Exception {
        ColumnFamilyDescriptor columnDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"mob")).setMobEnabled(true).setMobThreshold(0L).build();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(columnDescriptor).build();
        this.admin.createTable(tableDescriptor).get();
        byte[][] families = new byte[][]{Bytes.toBytes((String)"mob")};
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 3000, 8);
        this.admin.majorCompact(this.tableName, CompactType.MOB).get();
        CompactionState state = (CompactionState)this.admin.getCompactionState(this.tableName, CompactType.MOB).get();
        Assert.assertNotEquals((Object)CompactionState.NONE, (Object)state);
        this.waitUntilMobCompactionFinished(this.tableName);
    }

    @Test
    public void testCompactRegionServer() throws Exception {
        byte[][] families = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2"), Bytes.toBytes((String)"f3")};
        this.createTableWithDefaultConf(this.tableName, null, (byte[][])families);
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 3000, 8);
        List<HRegionServer> rsList = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(rsThread -> rsThread.getRegionServer()).collect(Collectors.toList());
        ArrayList<Region> regions = new ArrayList<Region>();
        rsList.forEach(rs -> regions.addAll(rs.getRegions(this.tableName)));
        Assert.assertEquals((long)1L, (long)regions.size());
        int countBefore = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        Assert.assertTrue((countBefore > 0 ? 1 : 0) != 0);
        for (HRegionServer hRegionServer : rsList) {
            this.admin.compactRegionServer(hRegionServer.getServerName()).get();
        }
        Thread.sleep(5000L);
        int countAfterMinorCompaction = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        Assert.assertTrue((countAfterMinorCompaction < countBefore ? 1 : 0) != 0);
        for (HRegionServer rs3 : rsList) {
            this.admin.majorCompactRegionServer(rs3.getServerName()).get();
        }
        Thread.sleep(5000L);
        int n = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        Assert.assertEquals((long)3L, (long)n);
    }

    @Test
    public void testCompactionSwitchStates() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        byte[][] families = new byte[][]{family, Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"2")), Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"3"))};
        this.createTableWithDefaultConf(this.tableName, null, (byte[][])families);
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 3000, 8);
        ArrayList regions = new ArrayList();
        TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().forEach(rsThread -> regions.addAll(rsThread.getRegionServer().getRegions(this.tableName)));
        CompletableFuture listCompletableFuture = this.admin.compactionSwitch(true, new ArrayList());
        Map pairs = (Map)listCompletableFuture.get();
        for (Map.Entry p : pairs.entrySet()) {
            Assert.assertEquals((String)"Default compaction state, expected=enabled actual=disabled", (Object)true, p.getValue());
        }
        CompletableFuture listCompletableFuture1 = this.admin.compactionSwitch(false, new ArrayList());
        Map pairs1 = (Map)listCompletableFuture1.get();
        for (Map.Entry p : pairs1.entrySet()) {
            Assert.assertEquals((String)"Last compaction state, expected=enabled actual=disabled", (Object)true, p.getValue());
        }
        CompletableFuture listCompletableFuture2 = this.admin.compactionSwitch(true, new ArrayList());
        Map pairs2 = (Map)listCompletableFuture2.get();
        for (Map.Entry p : pairs2.entrySet()) {
            Assert.assertEquals((String)"Last compaction state, expected=disabled actual=enabled", (Object)false, p.getValue());
        }
        ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        ArrayList<String> serverNameList = new ArrayList<String>();
        serverNameList.add(serverName.getServerName());
        CompletableFuture listCompletableFuture3 = this.admin.compactionSwitch(false, serverNameList);
        Map pairs3 = (Map)listCompletableFuture3.get();
        Assert.assertEquals((long)pairs3.entrySet().size(), (long)1L);
        for (Map.Entry p : pairs3.entrySet()) {
            Assert.assertEquals((String)"Last compaction state, expected=enabled actual=disabled", (Object)true, p.getValue());
        }
        CompletableFuture listCompletableFuture4 = this.admin.compactionSwitch(true, serverNameList);
        Map pairs4 = (Map)listCompletableFuture4.get();
        Assert.assertEquals((long)pairs4.entrySet().size(), (long)1L);
        for (Map.Entry p : pairs4.entrySet()) {
            Assert.assertEquals((String)"Last compaction state, expected=disabled actual=enabled", (Object)false, p.getValue());
        }
    }

    @Test
    public void testCompact() throws Exception {
        this.compactionTest(TableName.valueOf((String)"testCompact1"), 8, CompactionState.MAJOR, false);
        this.compactionTest(TableName.valueOf((String)"testCompact2"), 15, CompactionState.MINOR, false);
        this.compactionTest(TableName.valueOf((String)"testCompact3"), 8, CompactionState.MAJOR, true);
        this.compactionTest(TableName.valueOf((String)"testCompact4"), 15, CompactionState.MINOR, true);
    }

    private void compactionTest(TableName tableName, int flushes, CompactionState expectedState, boolean singleFamily) throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        byte[][] families = new byte[][]{family, Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"2")), Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"3"))};
        this.createTableWithDefaultConf(tableName, null, (byte[][])families);
        TestAsyncRegionAdminApi.loadData(tableName, families, 3000, flushes);
        ArrayList<Region> regions = new ArrayList<Region>();
        TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().forEach(rsThread -> regions.addAll(rsThread.getRegionServer().getRegions(tableName)));
        Assert.assertEquals((long)1L, (long)regions.size());
        int countBefore = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        int countBeforeSingleFamily = TestAsyncRegionAdminApi.countStoreFilesInFamily(regions, family);
        Assert.assertTrue((countBefore > 0 ? 1 : 0) != 0);
        if (expectedState == CompactionState.MINOR) {
            if (singleFamily) {
                this.admin.compact(tableName, family).get();
            } else {
                this.admin.compact(tableName).get();
            }
        } else if (singleFamily) {
            this.admin.majorCompact(tableName, family).get();
        } else {
            this.admin.majorCompact(tableName).get();
        }
        long curt = System.currentTimeMillis();
        long waitTime = 5000L;
        long endt = curt + waitTime;
        CompactionState state = (CompactionState)this.admin.getCompactionState(tableName).get();
        while (state == CompactionState.NONE && curt < endt) {
            Thread.sleep(10L);
            state = (CompactionState)this.admin.getCompactionState(tableName).get();
            curt = System.currentTimeMillis();
        }
        if (expectedState != state) {
            for (Region region : regions) {
                state = CompactionState.valueOf((String)region.getCompactionState().toString());
                Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
            }
        } else {
            state = (CompactionState)this.admin.getCompactionState(tableName).get();
            while (state != CompactionState.NONE && curt < endt) {
                Thread.sleep(10L);
                state = (CompactionState)this.admin.getCompactionState(tableName).get();
            }
            Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
        }
        int countAfter = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        int countAfterSingleFamily = TestAsyncRegionAdminApi.countStoreFilesInFamily(regions, family);
        Assert.assertTrue((countAfter < countBefore ? 1 : 0) != 0);
        if (!singleFamily) {
            if (expectedState == CompactionState.MAJOR) {
                Assert.assertTrue((families.length == countAfter ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((families.length < countAfter ? 1 : 0) != 0);
            }
        } else {
            int singleFamDiff = countBeforeSingleFamily - countAfterSingleFamily;
            Assert.assertTrue((singleFamDiff == countBefore - countAfter ? 1 : 0) != 0);
            if (expectedState == CompactionState.MAJOR) {
                Assert.assertTrue((1 == countAfterSingleFamily ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((1 < countAfterSingleFamily ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNonExistentTableCompaction() {
        this.testNonExistentTableCompaction(CompactionState.MINOR);
        this.testNonExistentTableCompaction(CompactionState.MAJOR);
    }

    private void testNonExistentTableCompaction(CompactionState compactionState) {
        try {
            if (compactionState == CompactionState.MINOR) {
                this.admin.compact(TableName.valueOf((String)"NonExistentTable")).get();
            } else {
                this.admin.majorCompact(TableName.valueOf((String)"NonExistentTable")).get();
            }
            Assert.fail((String)"Expected TableNotFoundException when table doesn't exist");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TableNotFoundException));
        }
    }

    private static int countStoreFilesInFamily(List<Region> regions, byte[] family) {
        return TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, new byte[][]{family});
    }

    private static int countStoreFilesInFamilies(List<Region> regions, byte[][] families) {
        int count = 0;
        for (Region region : regions) {
            count += region.getStoreFileList(families).size();
        }
        return count;
    }

    static void loadData(TableName tableName, byte[][] families, int rows) throws IOException {
        TestAsyncRegionAdminApi.loadData(tableName, families, rows, 1);
    }

    static void loadData(TableName tableName, byte[][] families, int rows, int flushes) throws IOException {
        AsyncTable table = ASYNC_CONN.getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(rows);
        byte[] qualifier = Bytes.toBytes((String)"val");
        for (int i = 0; i < flushes; ++i) {
            for (int k = 0; k < rows; ++k) {
                byte[] row = Bytes.add((byte[])Bytes.toBytes((int)k), (byte[])Bytes.toBytes((int)i));
                Put p = new Put(row);
                for (int j = 0; j < families.length; ++j) {
                    p.addColumn(families[j], qualifier, row);
                }
                puts.add(p);
            }
            table.putAll(puts).join();
            TEST_UTIL.flush();
            puts.clear();
        }
    }
}

