/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NonThreadSafeMemStoreSizing
implements MemStoreSizing {
    private long dataSize = 0L;
    private long heapSize = 0L;
    private long offHeapSize = 0L;
    private int cellsCount = 0;

    NonThreadSafeMemStoreSizing() {
        this(0L, 0L, 0L, 0);
    }

    NonThreadSafeMemStoreSizing(MemStoreSize mss) {
        this(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
    }

    NonThreadSafeMemStoreSizing(long dataSize, long heapSize, long offHeapSize, int cellsCount) {
        this.incMemStoreSize(dataSize, heapSize, offHeapSize, cellsCount);
    }

    @Override
    public MemStoreSize getMemStoreSize() {
        return new MemStoreSize(this.dataSize, this.heapSize, this.offHeapSize, this.cellsCount);
    }

    @Override
    public long incMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta, int cellsCountDelta) {
        this.offHeapSize += offHeapSizeDelta;
        this.heapSize += heapSizeDelta;
        this.dataSize += dataSizeDelta;
        this.cellsCount += cellsCountDelta;
        return this.dataSize;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public long getHeapSize() {
        return this.heapSize;
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize;
    }

    @Override
    public int getCellsCount() {
        return this.cellsCount;
    }

    public String toString() {
        return this.getMemStoreSize().toString();
    }
}

