/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotQuotaObserverChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotQuotaObserverChore.class);
    static final String SNAPSHOT_QUOTA_CHORE_PERIOD_KEY = "hbase.master.quotas.snapshot.chore.period";
    static final int SNAPSHOT_QUOTA_CHORE_PERIOD_DEFAULT = 300000;
    static final String SNAPSHOT_QUOTA_CHORE_DELAY_KEY = "hbase.master.quotas.snapshot.chore.delay";
    static final long SNAPSHOT_QUOTA_CHORE_DELAY_DEFAULT = 60000L;
    static final String SNAPSHOT_QUOTA_CHORE_TIMEUNIT_KEY = "hbase.master.quotas.snapshot.chore.timeunit";
    static final String SNAPSHOT_QUOTA_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    private final Connection conn;
    private final Configuration conf;
    private final MetricsMaster metrics;
    private final FileSystem fs;

    public SnapshotQuotaObserverChore(HMaster master, MetricsMaster metrics) {
        this(master.getConnection(), master.getConfiguration(), master.getFileSystem(), master, metrics);
    }

    SnapshotQuotaObserverChore(Connection conn, Configuration conf, FileSystem fs, Stoppable stopper, MetricsMaster metrics) {
        super(QuotaObserverChore.class.getSimpleName(), stopper, SnapshotQuotaObserverChore.getPeriod(conf), SnapshotQuotaObserverChore.getInitialDelay(conf), SnapshotQuotaObserverChore.getTimeUnit(conf));
        this.conn = conn;
        this.conf = conf;
        this.metrics = metrics;
        this.fs = fs;
    }

    protected void chore() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Computing sizes of snapshots for quota management.");
            }
            long start = System.nanoTime();
            this._chore();
            if (null != this.metrics) {
                this.metrics.incrementSnapshotObserverTime((System.nanoTime() - start) / 1000000L);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to compute the size of snapshots, will retry", (Throwable)e);
        }
    }

    void _chore() throws IOException {
        long start = System.nanoTime();
        Multimap<TableName, String> snapshotsToComputeSize = this.getSnapshotsToComputeSize();
        if (null != this.metrics) {
            this.metrics.incrementSnapshotFetchTime((System.nanoTime() - start) / 1000000L);
        }
        Multimap<TableName, SnapshotWithSize> snapshotsWithSize = this.computeSnapshotSizes(snapshotsToComputeSize);
        this.persistSnapshotSizes(snapshotsWithSize);
    }

    Multimap<TableName, String> getSnapshotsToComputeSize() throws IOException {
        HashSet<TableName> tablesToFetchSnapshotsFrom = new HashSet<TableName>();
        QuotaFilter filter = new QuotaFilter();
        filter.addTypeFilter(QuotaType.SPACE);
        try (Admin admin = this.conn.getAdmin();){
            for (QuotaSettings qs : QuotaRetriever.open((Configuration)this.conf, (QuotaFilter)filter)) {
                String ns = qs.getNamespace();
                TableName tn = qs.getTableName();
                if (null == ns && null == tn || null != ns && null != tn) {
                    throw new IllegalStateException("Expected only one of namespace and tablename to be null");
                }
                if (null != ns) {
                    tablesToFetchSnapshotsFrom.addAll(Arrays.asList(admin.listTableNamesByNamespace(ns)));
                    continue;
                }
                tablesToFetchSnapshotsFrom.add(tn);
            }
            Multimap<TableName, String> multimap = this.getSnapshotsFromTables(admin, tablesToFetchSnapshotsFrom);
            return multimap;
        }
    }

    Multimap<TableName, String> getSnapshotsFromTables(Admin admin, Set<TableName> tablesToFetchSnapshotsFrom) throws IOException {
        HashMultimap snapshotsToCompute = HashMultimap.create();
        for (SnapshotDescription sd : admin.listSnapshots()) {
            TableName tn = sd.getTableName();
            if (!tablesToFetchSnapshotsFrom.contains(tn)) continue;
            snapshotsToCompute.put((Object)tn, (Object)sd.getName());
        }
        return snapshotsToCompute;
    }

    Multimap<TableName, SnapshotWithSize> computeSnapshotSizes(Multimap<TableName, String> snapshotsToComputeSize) throws IOException {
        HashMultimap snapshotSizes = HashMultimap.create();
        for (Map.Entry entry : snapshotsToComputeSize.asMap().entrySet()) {
            Set<String> tableReferencedStoreFiles;
            TableName tn = (TableName)entry.getKey();
            ArrayList snapshotNames = new ArrayList((Collection)entry.getValue());
            Collections.sort(snapshotNames);
            Path rootDir = FSUtils.getRootDir((Configuration)this.conf);
            try {
                tableReferencedStoreFiles = FSUtils.getTableStoreFilePathMap(this.fs, rootDir).keySet();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Paths for " + tn + ": " + tableReferencedStoreFiles);
            }
            HashSet<String> snapshotReferencedFiles = new HashSet<String>();
            for (String snapshotName : snapshotNames) {
                long start = System.nanoTime();
                Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
                SnapshotProtos.SnapshotDescription sd = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
                SnapshotManifest manifest = SnapshotManifest.open(this.conf, this.fs, snapshotDir, sd);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Files referenced by other snapshots: " + snapshotReferencedFiles);
                }
                Set<StoreFileReference> unreferencedStoreFileNames = this.getStoreFilesFromSnapshot(manifest, sfn -> !tableReferencedStoreFiles.contains(sfn) && !snapshotReferencedFiles.contains(sfn));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Snapshot " + snapshotName + " solely references the files: " + unreferencedStoreFileNames);
                }
                long size = this.getSizeOfStoreFiles(tn, unreferencedStoreFileNames);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Computed size of " + snapshotName + " to be " + size);
                }
                snapshotSizes.put((Object)tn, (Object)new SnapshotWithSize(snapshotName, size));
                for (StoreFileReference ref : unreferencedStoreFileNames) {
                    for (String fileName : ref.getFamilyToFilesMapping().values()) {
                        snapshotReferencedFiles.add(fileName);
                    }
                }
                if (null == this.metrics) continue;
                this.metrics.incrementSnapshotSizeComputationTime((System.nanoTime() - start) / 1000000L);
            }
        }
        return snapshotSizes;
    }

    Set<StoreFileReference> getStoreFilesFromSnapshot(SnapshotManifest manifest, Predicate<String> filter) {
        HashSet<StoreFileReference> references = new HashSet<StoreFileReference>();
        for (SnapshotProtos.SnapshotRegionManifest rm : manifest.getRegionManifests()) {
            StoreFileReference regionReference = new StoreFileReference(HRegionInfo.convert((HBaseProtos.RegionInfo)rm.getRegionInfo()).getEncodedName());
            for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles ff : rm.getFamilyFilesList()) {
                String familyName = ff.getFamilyName().toStringUtf8();
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile sf : ff.getStoreFilesList()) {
                    String storeFileName = sf.getName();
                    if (!filter.test(storeFileName)) continue;
                    regionReference.addFamilyStoreFile(familyName, storeFileName);
                }
            }
            if (regionReference.getFamilyToFilesMapping().isEmpty()) continue;
            references.add(regionReference);
        }
        return references;
    }

    Path getTableDir(TableName tn) throws IOException {
        Path rootDir = FSUtils.getRootDir((Configuration)this.conf);
        return FSUtils.getTableDir((Path)rootDir, (TableName)tn);
    }

    long getSizeOfStoreFiles(TableName tn, Set<StoreFileReference> storeFileNames) {
        return storeFileNames.stream().collect(Collectors.summingLong(sfr -> this.getSizeOfStoreFile(tn, (StoreFileReference)sfr)));
    }

    long getSizeOfStoreFile(TableName tn, StoreFileReference storeFileName) {
        String regionName = storeFileName.getRegionName();
        return storeFileName.getFamilyToFilesMapping().entries().stream().collect(Collectors.summingLong(e -> this.getSizeOfStoreFile(tn, regionName, (String)e.getKey(), (String)e.getValue())));
    }

    long getSizeOfStoreFile(TableName tn, String regionName, String family, String storeFile) {
        Path familyArchivePath;
        try {
            familyArchivePath = HFileArchiveUtil.getStoreArchivePath(this.conf, tn, regionName, family);
        }
        catch (IOException e) {
            LOG.warn("Could not compute path for the archive directory for the region", (Throwable)e);
            return 0L;
        }
        Path fileArchivePath = new Path(familyArchivePath, storeFile);
        try {
            if (this.fs.exists(fileArchivePath)) {
                FileStatus[] status = this.fs.listStatus(fileArchivePath);
                if (1 != status.length) {
                    LOG.warn("Expected " + fileArchivePath + " to be a file but was a directory, ignoring reference");
                    return 0L;
                }
                return status[0].getLen();
            }
        }
        catch (IOException e) {
            LOG.warn("Could not obtain the status of " + fileArchivePath, (Throwable)e);
            return 0L;
        }
        LOG.warn("Expected " + fileArchivePath + " to exist but does not, ignoring reference.");
        return 0L;
    }

    void persistSnapshotSizes(Multimap<TableName, SnapshotWithSize> snapshotsWithSize) throws IOException {
        try (Table quotaTable = this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            this.persistSnapshotSizes(quotaTable, snapshotsWithSize);
            this.persistSnapshotSizesByNS(quotaTable, snapshotsWithSize);
        }
    }

    void persistSnapshotSizes(Table table, Multimap<TableName, SnapshotWithSize> snapshotsWithSize) throws IOException {
        table.put(snapshotsWithSize.entries().stream().map(e -> QuotaTableUtil.createPutForSnapshotSize((TableName)((TableName)e.getKey()), (String)((SnapshotWithSize)e.getValue()).getName(), (long)((SnapshotWithSize)e.getValue()).getSize())).collect(Collectors.toList()));
    }

    void persistSnapshotSizesByNS(Table quotaTable, Multimap<TableName, SnapshotWithSize> snapshotsWithSize) throws IOException {
        Map<String, Long> namespaceSnapshotSizes = this.groupSnapshotSizesByNamespace(snapshotsWithSize);
        quotaTable.put(namespaceSnapshotSizes.entrySet().stream().map(e -> QuotaTableUtil.createPutForNamespaceSnapshotSize((String)((String)e.getKey()), (long)((Long)e.getValue()))).collect(Collectors.toList()));
    }

    Map<String, Long> groupSnapshotSizesByNamespace(Multimap<TableName, SnapshotWithSize> snapshotsWithSize) {
        return snapshotsWithSize.entries().stream().collect(Collectors.groupingBy(e -> ((TableName)e.getKey()).getNamespaceAsString(), Collectors.mapping(Map.Entry::getValue, Collectors.summingLong(sws -> sws.getSize()))));
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(SNAPSHOT_QUOTA_CHORE_PERIOD_KEY, 300000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(SNAPSHOT_QUOTA_CHORE_DELAY_KEY, 60000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(SNAPSHOT_QUOTA_CHORE_TIMEUNIT_KEY, SNAPSHOT_QUOTA_CHORE_TIMEUNIT_DEFAULT));
    }

    static class StoreFileReference {
        private final String regionName;
        private final Multimap<String, String> familyToFiles;

        StoreFileReference(String regionName) {
            this.regionName = Objects.requireNonNull(regionName);
            this.familyToFiles = HashMultimap.create();
        }

        String getRegionName() {
            return this.regionName;
        }

        Multimap<String, String> getFamilyToFilesMapping() {
            return this.familyToFiles;
        }

        void addFamilyStoreFile(String family, String storeFileName) {
            this.familyToFiles.put((Object)family, (Object)storeFileName);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.regionName).append(this.familyToFiles).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StoreFileReference)) {
                return false;
            }
            StoreFileReference other = (StoreFileReference)o;
            return this.regionName.equals(other.regionName) && this.familyToFiles.equals(other.familyToFiles);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            return sb.append("StoreFileReference[region=").append(this.regionName).append(", files=").append(this.familyToFiles).append("]").toString();
        }
    }

    static class SnapshotWithSize {
        private final String name;
        private final long size;

        SnapshotWithSize(String name, long size) {
            this.name = Objects.requireNonNull(name);
            this.size = size;
        }

        String getName() {
            return this.name;
        }

        long getSize() {
            return this.size;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.name).append(this.size).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SnapshotWithSize)) {
                return false;
            }
            SnapshotWithSize other = (SnapshotWithSize)o;
            return this.name.equals(other.name) && this.size == other.size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            return sb.append("SnapshotWithSize:[").append(this.name).append(" ").append(StringUtils.byteDesc((long)this.size)).append("]").toString();
        }
    }
}

