/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class AccessChecker {
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + AccessChecker.class.getName()));
    private TableAuthManager authManager;
    private boolean authorizationEnabled;

    public static boolean isAuthorizationSupported(Configuration conf) {
        return conf.getBoolean("hbase.security.authorization", false);
    }

    public AccessChecker(Configuration conf, ZKWatcher zkw) throws RuntimeException {
        if (zkw != null) {
            try {
                this.authManager = TableAuthManager.getOrCreate(zkw, conf);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error obtaining AccessChecker", ioe);
            }
        } else {
            throw new NullPointerException("Error obtaining AccessChecker, zk found null.");
        }
        this.authorizationEnabled = AccessChecker.isAuthorizationSupported(conf);
    }

    public void stop() {
        TableAuthManager.release(this.authManager);
    }

    public TableAuthManager getAuthManager() {
        return this.authManager;
    }

    public void requireAccess(User user, String request, TableName tableName, Permission.Action ... permissions) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.hasAccess(user, tableName, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, null, null);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requirePermission(User user, String request, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(user, request, perm, null, null);
    }

    public void requireGlobalPermission(User user, String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (!this.authManager.authorize(user, perm)) {
            AuthResult result = AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
            AccessChecker.logResult(result);
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        AuthResult result = AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap);
        result.getParams().setTableName(tableName).setFamilies(familyMap);
        AccessChecker.logResult(result);
    }

    public void requireGlobalPermission(User user, String request, Permission.Action perm, String namespace) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (!this.authManager.authorize(user, perm)) {
            AuthResult authResult = AuthResult.deny(request, "Global check failed", user, perm, null);
            authResult.getParams().setNamespace(namespace);
            AccessChecker.logResult(authResult);
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        AuthResult authResult = AuthResult.allow(request, "Global check allowed", user, perm, null);
        authResult.getParams().setNamespace(namespace);
        AccessChecker.logResult(authResult);
    }

    public void requireNamespacePermission(User user, String request, String namespace, Permission.Action ... permissions) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireNamespacePermission(User user, String request, String namespace, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap, Permission.Action ... permissions) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                result.getParams().setTableName(tableName).setFamilies(familyMap);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requirePermission(User user, String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireTablePermission(User user, String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, null, null, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                result.getParams().setFamily(family).setQualifier(qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
            result.getParams().setFamily(family).setQualifier(qualifier);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void checkLockPermissions(User user, String namespace, TableName tableName, RegionInfo[] regionInfos, String reason) throws IOException {
        if (namespace != null && !namespace.isEmpty()) {
            this.requireNamespacePermission(user, reason, namespace, Permission.Action.ADMIN, Permission.Action.CREATE);
        } else if (tableName != null || regionInfos != null && regionInfos.length > 0) {
            TableName tn = tableName != null ? tableName : regionInfos[0].getTable();
            this.requireTablePermission(user, reason, tn, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        } else {
            throw new DoNotRetryIOException("Invalid lock level when requesting permissions.");
        }
    }

    public static void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            AUDITLOG.trace("Access {} for user {}; reason: {}; remote address: {}; request: {}; context: {}", new Object[]{result.isAllowed() ? "allowed" : "denied", result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN", result.getReason(), RpcServer.getRemoteAddress().map(InetAddress::toString).orElse(""), result.getRequest(), result.toContextString()});
        }
    }
}

