// Autogenerated Jamon implementation
// /Users/stack/checkouts/hbase.git/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.RegionMetrics;
// 30, 9
import org.apache.hadoop.hbase.ServerMetrics;
// 31, 9
import org.apache.hadoop.hbase.ServerName;
// 32, 9
import org.apache.hadoop.hbase.Size;
// 33, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 34, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 38, 1
    if ((servers != null && servers.size() > 0))
    {
      // 38, 47
      jamonWriter.write("\n\n");
      // 40, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 45, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStas\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 55, 13
      {
        // 55, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 55, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 58, 13
      {
        // 58, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 58, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 61, 13
      {
        // 61, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 61, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 64, 13
      {
        // 64, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 64, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStas\">\n            ");
      // 67, 13
      {
        // 67, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 67, 62
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 72, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 74, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 78, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n");
    // 87, 1
    
    int totalRegions = 0;
    int totalRequestsPerSecond = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerMetrics sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }

    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestCountPerSecond();
        numRegionsOnline = sl.getRegionMetrics().size();
        totalRegions += sl.getRegionMetrics().size();
        totalRequestsPerSecond += sl.getRequestCountPerSecond();
        lastContact = (System.currentTimeMillis() - sl.getReportTimestamp())/1000;
    }
    long startcode = serverName.getStartcode();

    // 113, 1
    jamonWriter.write("<tr>\n    <td>");
    // 114, 9
    {
      // 114, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 114, 70
    jamonWriter.write("</td>\n    <td>");
    // 115, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 115, 34
    jamonWriter.write("</td>\n    <td>");
    // 116, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 116, 71
    jamonWriter.write("</td>\n    <td>");
    // 117, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 117, 22
    jamonWriter.write("</td>\n    <td>");
    // 118, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 118, 55
    jamonWriter.write("</td>\n    <td>");
    // 119, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 119, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 121, 1
    
}

    // 124, 1
    jamonWriter.write("<tr><td>Total:");
    // 124, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 124, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
    // 127, 1
    if (inconsistentNodeNum > 0)
    {
      // 127, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 128, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 128, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 129, 1
    else
    {
      // 129, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 131, 7
    jamonWriter.write("\n<td>");
    // 132, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequestsPerSecond), jamonWriter);
    // 132, 33
    jamonWriter.write("</td>\n<td>");
    // 133, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 133, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 285, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 289, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n");
    // 297, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
long totalCompactingCells = 0;
long totalCompactedCells = 0;
for (RegionMetrics rl : sl.getRegionMetrics().values()) {
  totalCompactingCells += rl.getCompactingCellCount();
  totalCompactedCells += rl.getCompactedCellCount();
}
String percentDone = "";
if  (totalCompactingCells > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) totalCompactedCells / totalCompactingCells)) + "%";
}

    // 314, 1
    jamonWriter.write("<tr>\n<td>");
    // 315, 5
    {
      // 315, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 315, 66
    jamonWriter.write("</td>\n<td>");
    // 316, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactingCells), jamonWriter);
    // 316, 31
    jamonWriter.write("</td>\n<td>");
    // 317, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactedCells), jamonWriter);
    // 317, 30
    jamonWriter.write("</td>\n<td>");
    // 318, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactingCells - totalCompactedCells), jamonWriter);
    // 318, 53
    jamonWriter.write("</td>\n<td>");
    // 319, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 319, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 321, 1
    
        }  else {
        
    // 324, 1
    {
      // 324, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 324, 40
    jamonWriter.write("\n");
    // 325, 1
    
    }
}

    // 329, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 350, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 354, 5
    jamonWriter.write("<tr>\n    <td>");
    // 355, 9
    {
      // 355, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, null);
    }
    // 355, 72
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 138, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 142, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
    // 150, 1
    
for (ServerName serverName: serverNames) {

    ServerMetrics sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {
      long memStoreSizeMB = 0;
      for (RegionMetrics rl : sl.getRegionMetrics().values()) {
        memStoreSizeMB += rl.getMemStoreSize().get(Size.Unit.MEGABYTE);
      }

    // 160, 1
    jamonWriter.write("<tr>\n    <td>");
    // 161, 9
    {
      // 161, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 161, 70
    jamonWriter.write("</td>\n    <td>");
    // 162, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String((long) sl.getUsedHeapSize().get(Size.Unit.MEGABYTE)
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 163, 55
    jamonWriter.write("</td>\n    <td>");
    // 164, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String((long) sl.getMaxHeapSize().get(Size.Unit.MEGABYTE)
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 165, 55
    jamonWriter.write("</td>\n    <td>");
    // 166, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(memStoreSizeMB
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 167, 55
    jamonWriter.write("</td>\n\n</tr>\n");
    // 170, 1
    
        }  else {

    // 173, 1
    {
      // 173, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 173, 40
    jamonWriter.write("\n");
    // 174, 1
    
        }
}

    // 178, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 182, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 186, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
    // 194, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
  long readRequestCount = 0;
  long writeRequestCount = 0;
  long filteredReadRequestCount = 0;
  for (RegionMetrics rl : sl.getRegionMetrics().values()) {
    readRequestCount += rl.getReadRequestCount();
    writeRequestCount += rl.getWriteRequestCount();
    filteredReadRequestCount += rl.getFilteredReadRequestCount();
  }

    // 208, 1
    jamonWriter.write("<tr>\n<td>");
    // 209, 5
    {
      // 209, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 209, 66
    jamonWriter.write("</td>\n<td>");
    // 210, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getRequestCountPerSecond()), jamonWriter);
    // 210, 40
    jamonWriter.write("</td>\n<td>");
    // 211, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(readRequestCount), jamonWriter);
    // 211, 27
    jamonWriter.write("</td>\n<td>");
    // 212, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(filteredReadRequestCount), jamonWriter);
    // 212, 35
    jamonWriter.write("</td>\n<td>");
    // 213, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(writeRequestCount), jamonWriter);
    // 213, 28
    jamonWriter.write("</td>\n</tr>\n");
    // 215, 1
    
        }  else {
        
    // 218, 1
    {
      // 218, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 218, 40
    jamonWriter.write("\n");
    // 219, 1
    
        }
}

    // 223, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 333, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName, final ServerMetrics serverLoad)
    throws java.io.IOException
  {
    // 338, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 343, 9
    if (infoPort > 0)
    {
      // 343, 28
      jamonWriter.write("\n            <a href=\"");
      // 344, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 344, 31
      jamonWriter.write("\">");
      // 344, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 344, 65
      jamonWriter.write("</a>\n        ");
    }
    // 345, 9
    else
    {
      // 345, 16
      jamonWriter.write("\n            ");
      // 346, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 346, 45
      jamonWriter.write("\n        ");
    }
    // 347, 15
    jamonWriter.write("\n");
  }
  
  
  // 227, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 231, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
    // 241, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
  long storeCount = 0;
  long storeFileCount = 0;
  long storeUncompressedSizeMB = 0;
  long storeFileSizeMB = 0;
  long totalStaticIndexSizeKB = 0;
  long totalStaticBloomSizeKB = 0;
  for (RegionMetrics rl : sl.getRegionMetrics().values()) {
    storeCount += rl.getStoreCount();
    storeFileCount += rl.getStoreFileCount();
    storeUncompressedSizeMB += rl.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
    storeFileSizeMB += rl.getStoreFileSize().get(Size.Unit.MEGABYTE);
    totalStaticIndexSizeKB += rl.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
    totalStaticBloomSizeKB += rl.getBloomFilterSize().get(Size.Unit.KILOBYTE);
  }

    // 261, 1
    jamonWriter.write("<tr>\n<td>");
    // 262, 5
    {
      // 262, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 262, 66
    jamonWriter.write("</td>\n<td>");
    // 263, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeCount), jamonWriter);
    // 263, 21
    jamonWriter.write("</td>\n<td>");
    // 264, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeFileCount), jamonWriter);
    // 264, 25
    jamonWriter.write("</td>\n<td>");
    // 265, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
  storeUncompressedSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 266, 75
    jamonWriter.write("</td>\n<td>");
    // 267, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(storeFileSizeMB
  * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 268, 51
    jamonWriter.write("</td>\n<td>");
    // 269, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(totalStaticIndexSizeKB
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 270, 51
    jamonWriter.write("</td>\n<td>");
    // 271, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(totalStaticBloomSizeKB
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 272, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 274, 1
    
        }  else {
        
    // 277, 1
    {
      // 277, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 277, 40
    jamonWriter.write("\n");
    // 278, 1
    
    }
}

    // 282, 1
    jamonWriter.write("</table>\n");
  }
  
  
}
