/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class StoreUtils {
    private static final Log LOG = LogFactory.getLog(StoreUtils.class);

    public static OptionalInt getDeterministicRandomSeed(Collection<HStoreFile> files) {
        return files.stream().mapToInt(f -> f.getPath().getName().hashCode()).findFirst();
    }

    public static boolean hasReferences(Collection<HStoreFile> files) {
        return files != null ? files.stream().anyMatch(HStoreFile::isReference) : false;
    }

    public static long getLowestTimestamp(Collection<HStoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        for (HStoreFile storeFile : candidates) {
            minTs = Math.min(minTs, storeFile.getModificationTimeStamp());
        }
        return minTs;
    }

    static Optional<HStoreFile> getLargestFile(Collection<HStoreFile> candidates) {
        return candidates.stream().filter(f -> f.getReader() != null).max((f1, f2) -> Long.compare(f1.getReader().length(), f2.getReader().length()));
    }

    public static OptionalLong getMaxMemStoreTSInList(Collection<HStoreFile> sfs) {
        return sfs.stream().filter(sf -> !sf.isBulkLoadResult()).mapToLong(HStoreFile::getMaxMemStoreTS).max();
    }

    public static OptionalLong getMaxSequenceIdInList(Collection<HStoreFile> sfs) {
        return sfs.stream().mapToLong(HStoreFile::getMaxSequenceId).max();
    }

    static Optional<byte[]> getFileSplitPoint(HStoreFile file, CellComparator comparator) throws IOException {
        StoreFileReader reader = file.getReader();
        if (reader == null) {
            LOG.warn((Object)("Storefile " + file + " Reader is null; cannot get split point"));
            return Optional.empty();
        }
        Optional<Cell> optionalMidKey = reader.midKey();
        if (!optionalMidKey.isPresent()) {
            return Optional.empty();
        }
        Cell midKey = optionalMidKey.get();
        Cell firstKey = reader.getFirstKey().get();
        Cell lastKey = reader.getLastKey().get();
        if (comparator.compareRows(midKey, firstKey) == 0 || comparator.compareRows(midKey, lastKey) == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"cannot split because midkey is the same as first or last row");
            }
            return Optional.empty();
        }
        return Optional.of(CellUtil.cloneRow((Cell)midKey));
    }

    static Optional<byte[]> getSplitPoint(Collection<HStoreFile> storefiles, CellComparator comparator) throws IOException {
        Optional<HStoreFile> largestFile = StoreUtils.getLargestFile(storefiles);
        return largestFile.isPresent() ? StoreUtils.getFileSplitPoint(largestFile.get(), comparator) : Optional.empty();
    }
}

