/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellArrayImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellChunkImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.CompositeImmutableSegment;
import org.apache.hadoop.hbase.regionserver.ImmutableMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class SegmentFactory {
    private static SegmentFactory instance = new SegmentFactory();

    private SegmentFactory() {
    }

    public static SegmentFactory instance() {
        return instance;
    }

    public CompositeImmutableSegment createCompositeImmutableSegment(CellComparator comparator, List<ImmutableSegment> segments) {
        return new CompositeImmutableSegment(comparator, segments);
    }

    public ImmutableSegment createImmutableSegmentByCompaction(Configuration conf, CellComparator comparator, MemStoreSegmentsIterator iterator, int numOfCells, CompactingMemStore.IndexType idxType) throws IOException {
        MemStoreLAB memStoreLAB = MemStoreLAB.newInstance(conf);
        return this.createImmutableSegment(conf, comparator, iterator, memStoreLAB, numOfCells, MemStoreCompactor.Action.COMPACT, idxType);
    }

    public ImmutableSegment createImmutableSegment(CellComparator comparator) {
        MutableSegment segment = this.generateMutableSegment(null, comparator, null);
        return this.createImmutableSegment(segment);
    }

    public ImmutableSegment createImmutableSegment(MutableSegment segment) {
        return new CSLMImmutableSegment(segment);
    }

    public MutableSegment createMutableSegment(Configuration conf, CellComparator comparator) {
        MemStoreLAB memStoreLAB = MemStoreLAB.newInstance(conf);
        return this.generateMutableSegment(conf, comparator, memStoreLAB);
    }

    public ImmutableSegment createImmutableSegmentByMerge(Configuration conf, CellComparator comparator, MemStoreSegmentsIterator iterator, int numOfCells, List<ImmutableSegment> segments, CompactingMemStore.IndexType idxType) throws IOException {
        MemStoreLAB memStoreLAB = this.getMergedMemStoreLAB(conf, segments);
        return this.createImmutableSegment(conf, comparator, iterator, memStoreLAB, numOfCells, MemStoreCompactor.Action.MERGE, idxType);
    }

    public ImmutableSegment createImmutableSegmentByFlattening(CSLMImmutableSegment segment, CompactingMemStore.IndexType idxType, MemStoreSizing memstoreSizing) {
        ImmutableSegment res = null;
        switch (idxType) {
            case CHUNK_MAP: {
                res = new CellChunkImmutableSegment(segment, memstoreSizing);
                break;
            }
            case CSLM_MAP: {
                assert (false);
                break;
            }
            case ARRAY_MAP: {
                res = new CellArrayImmutableSegment(segment, memstoreSizing);
            }
        }
        return res;
    }

    private ImmutableSegment createImmutableSegment(Configuration conf, CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB, int numOfCells, MemStoreCompactor.Action action, CompactingMemStore.IndexType idxType) {
        ImmutableSegment res = null;
        switch (idxType) {
            case CHUNK_MAP: {
                res = new CellChunkImmutableSegment(comparator, iterator, memStoreLAB, numOfCells, action);
                break;
            }
            case CSLM_MAP: {
                assert (false);
                break;
            }
            case ARRAY_MAP: {
                res = new CellArrayImmutableSegment(comparator, iterator, memStoreLAB, numOfCells, action);
            }
        }
        return res;
    }

    private MutableSegment generateMutableSegment(Configuration conf, CellComparator comparator, MemStoreLAB memStoreLAB) {
        CellSet set = new CellSet(comparator);
        return new MutableSegment(set, comparator, memStoreLAB);
    }

    private MemStoreLAB getMergedMemStoreLAB(Configuration conf, List<ImmutableSegment> segments) {
        ArrayList<MemStoreLAB> mslabs = new ArrayList<MemStoreLAB>();
        if (!conf.getBoolean("hbase.hregion.memstore.mslab.enabled", true)) {
            return null;
        }
        for (ImmutableSegment segment : segments) {
            mslabs.add(segment.getMemStoreLAB());
        }
        return new ImmutableMemStoreLAB(mslabs);
    }
}

