/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellArrayMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellArrayImmutableSegment
extends ImmutableSegment {
    public static final long DEEP_OVERHEAD_CAM = DEEP_OVERHEAD + (long)ClassSize.CELL_ARRAY_MAP;

    protected CellArrayImmutableSegment(CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB, int numOfCells, MemStoreCompactor.Action action) {
        super(null, comparator, memStoreLAB);
        this.incSize(0L, DEEP_OVERHEAD_CAM);
        this.initializeCellSet(numOfCells, iterator, action);
    }

    protected CellArrayImmutableSegment(CSLMImmutableSegment segment, MemStoreSizing memstoreSizing) {
        super(segment);
        this.incSize(0L, DEEP_OVERHEAD_CAM - CSLMImmutableSegment.DEEP_OVERHEAD_CSLM);
        int numOfCells = segment.getCellsCount();
        this.reinitializeCellSet(numOfCells, segment.getScanner(Long.MAX_VALUE), segment.getCellSet());
        long newSegmentSizeDelta = (long)numOfCells * (this.indexEntrySize() - (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY);
        this.incSize(0L, newSegmentSizeDelta);
        memstoreSizing.incMemStoreSize(0L, newSegmentSizeDelta);
    }

    @Override
    protected long indexEntrySize() {
        return ClassSize.CELL_ARRAY_MAP_ENTRY;
    }

    @Override
    protected boolean canBeFlattened() {
        return false;
    }

    private void initializeCellSet(int numOfCells, MemStoreSegmentsIterator iterator, MemStoreCompactor.Action action) {
        Cell[] cells = new Cell[numOfCells];
        int i = 0;
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            cells[i] = action == MemStoreCompactor.Action.MERGE ? c : this.maybeCloneWithAllocator(c);
            this.updateMetaInfo(c, true, null);
            ++i;
        }
        CellArrayMap cam = new CellArrayMap((Comparator<? super Cell>)this.getComparator(), cells, 0, i, false);
        this.setCellSet(null, new CellSet(cam));
    }

    private void reinitializeCellSet(int numOfCells, KeyValueScanner segmentScanner, CellSet oldCellSet) {
        Cell[] cells = new Cell[numOfCells];
        int idx = 0;
        try {
            Cell curCell;
            while ((curCell = segmentScanner.next()) != null) {
                cells[idx++] = curCell;
            }
        }
        catch (IOException ie) {
            throw new IllegalStateException(ie);
        }
        finally {
            segmentScanner.close();
        }
        CellArrayMap cam = new CellArrayMap((Comparator<? super Cell>)this.getComparator(), cells, 0, idx, false);
        this.setCellSet(oldCellSet, new CellSet(cam));
    }
}

