/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FileSystemUtilizationChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(FileSystemUtilizationChore.class);
    static final String FS_UTILIZATION_CHORE_PERIOD_KEY = "hbase.regionserver.quotas.fs.utilization.chore.period";
    static final int FS_UTILIZATION_CHORE_PERIOD_DEFAULT = 300000;
    static final String FS_UTILIZATION_CHORE_DELAY_KEY = "hbase.regionserver.quotas.fs.utilization.chore.delay";
    static final long FS_UTILIZATION_CHORE_DELAY_DEFAULT = 60000L;
    static final String FS_UTILIZATION_CHORE_TIMEUNIT_KEY = "hbase.regionserver.quotas.fs.utilization.chore.timeunit";
    static final String FS_UTILIZATION_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    static final String FS_UTILIZATION_MAX_ITERATION_DURATION_KEY = "hbase.regionserver.quotas.fs.utilization.chore.max.iteration.millis";
    static final long FS_UTILIZATION_MAX_ITERATION_DURATION_DEFAULT = 5000L;
    private int numberOfCyclesToSkip = 0;
    private int prevNumberOfCyclesToSkip = 0;
    private static final int CYCLE_UPPER_BOUND = 32;
    private final HRegionServer rs;
    private final long maxIterationMillis;
    private Iterator<Region> leftoverRegions;

    public FileSystemUtilizationChore(HRegionServer rs) {
        super(FileSystemUtilizationChore.class.getSimpleName(), (Stoppable)rs, FileSystemUtilizationChore.getPeriod(rs.getConfiguration()), FileSystemUtilizationChore.getInitialDelay(rs.getConfiguration()), FileSystemUtilizationChore.getTimeUnit(rs.getConfiguration()));
        this.rs = rs;
        this.maxIterationMillis = rs.getConfiguration().getLong(FS_UTILIZATION_MAX_ITERATION_DURATION_KEY, 5000L);
    }

    protected void chore() {
        boolean processingLeftovers;
        Iterator<Region> iterator;
        if (this.numberOfCyclesToSkip > 0) {
            --this.numberOfCyclesToSkip;
            return;
        }
        HashMap<RegionInfo, Long> onlineRegionSizes = new HashMap<RegionInfo, Long>();
        HashSet<HRegion> onlineRegions = new HashSet<HRegion>(this.rs.getRegions());
        Iterator<Region> oldRegionsToProcess = this.getLeftoverRegions();
        if (oldRegionsToProcess == null) {
            iterator = onlineRegions.iterator();
            processingLeftovers = false;
        } else {
            iterator = oldRegionsToProcess;
            processingLeftovers = true;
        }
        this.setLeftoverRegions(null);
        long regionSizesCalculated = 0L;
        long offlineRegionsSkipped = 0L;
        long skippedSplitParents = 0L;
        long skippedRegionReplicas = 0L;
        long start = EnvironmentEdgeManager.currentTime();
        while (iterator.hasNext()) {
            long timeRunning = EnvironmentEdgeManager.currentTime() - start;
            if (timeRunning > this.maxIterationMillis) {
                LOG.debug((Object)"Preempting execution of FileSystemUtilizationChore because it exceeds the maximum iteration configuration value. Will process remaining iterators on a subsequent invocation.");
                this.setLeftoverRegions(iterator);
                break;
            }
            Region region = iterator.next();
            if (processingLeftovers && !onlineRegions.contains(region)) {
                ++offlineRegionsSkipped;
                continue;
            }
            if (region.getRegionInfo().isSplitParent()) {
                ++skippedSplitParents;
                continue;
            }
            if (0 != region.getRegionInfo().getReplicaId()) {
                ++skippedRegionReplicas;
                continue;
            }
            long sizeInBytes = this.computeSize(region);
            onlineRegionSizes.put(region.getRegionInfo(), sizeInBytes);
            ++regionSizesCalculated;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Computed the size of " + regionSizesCalculated + " Regions. Skipped computation of " + offlineRegionsSkipped + " regions due to not being online on this RS, " + skippedSplitParents + " regions due to being the parent of a split, and" + skippedRegionReplicas + " regions due to being region replicas."));
        }
        if (!this.reportRegionSizesToMaster(onlineRegionSizes)) {
            int n = this.numberOfCyclesToSkip = this.prevNumberOfCyclesToSkip > 0 ? 2 * this.prevNumberOfCyclesToSkip : 1;
            if (this.numberOfCyclesToSkip > 32) {
                this.numberOfCyclesToSkip = 32;
            }
            this.prevNumberOfCyclesToSkip = this.numberOfCyclesToSkip;
        }
    }

    Iterator<Region> getLeftoverRegions() {
        return this.leftoverRegions;
    }

    void setLeftoverRegions(Iterator<Region> newLeftovers) {
        this.leftoverRegions = newLeftovers;
    }

    long computeSize(Region r) {
        long regionSize = 0L;
        for (Store store : r.getStores()) {
            regionSize += store.getHFilesSize();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Size of " + r + " is " + regionSize));
        }
        return regionSize;
    }

    boolean reportRegionSizesToMaster(Map<RegionInfo, Long> onlineRegionSizes) {
        return this.rs.reportRegionSizesForQuotas(onlineRegionSizes);
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(FS_UTILIZATION_CHORE_PERIOD_KEY, 300000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(FS_UTILIZATION_CHORE_DELAY_KEY, 60000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(FS_UTILIZATION_CHORE_TIMEUNIT_KEY, FS_UTILIZATION_CHORE_TIMEUNIT_DEFAULT));
    }
}

