/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CachedEntryQueue {
    private MinMaxPriorityQueue<Map.Entry<BlockCacheKey, BucketCache.BucketEntry>> queue;
    private long cacheSize;
    private long maxSize;

    public CachedEntryQueue(long maxSize, long blockSize) {
        int initialSize = (int)(maxSize / blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = MinMaxPriorityQueue.orderedBy((Comparator)new Comparator<Map.Entry<BlockCacheKey, BucketCache.BucketEntry>>(){

            @Override
            public int compare(Map.Entry<BlockCacheKey, BucketCache.BucketEntry> entry1, Map.Entry<BlockCacheKey, BucketCache.BucketEntry> entry2) {
                return BucketCache.BucketEntry.COMPARATOR.compare(entry1.getValue(), entry2.getValue());
            }
        }).expectedSize(initialSize).create();
        this.cacheSize = 0L;
        this.maxSize = maxSize;
    }

    public void add(Map.Entry<BlockCacheKey, BucketCache.BucketEntry> entry) {
        if (this.cacheSize < this.maxSize) {
            this.queue.add(entry);
            this.cacheSize += (long)entry.getValue().getLength();
        } else {
            BucketCache.BucketEntry head = (BucketCache.BucketEntry)((Map.Entry)this.queue.peek()).getValue();
            if (BucketCache.BucketEntry.COMPARATOR.compare(entry.getValue(), head) > 0) {
                this.cacheSize += (long)entry.getValue().getLength();
                this.cacheSize -= (long)head.getLength();
                if (this.cacheSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.cacheSize += (long)head.getLength();
                }
                this.queue.add(entry);
            }
        }
    }

    public Map.Entry<BlockCacheKey, BucketCache.BucketEntry> poll() {
        return (Map.Entry)this.queue.poll();
    }

    public Map.Entry<BlockCacheKey, BucketCache.BucketEntry> pollLast() {
        return (Map.Entry)this.queue.pollLast();
    }

    public long cacheSize() {
        return this.cacheSize;
    }
}

