// Autogenerated Jamon implementation
// /Users/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
// 30, 9
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
// 31, 9
import org.apache.hadoop.hbase.ServerLoad;
// 32, 9
import org.apache.hadoop.hbase.ServerName;
// 33, 9
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 34, 9
import org.apache.hadoop.hbase.client.HConnectionManager;
// 35, 9
import org.apache.hadoop.hbase.HTableDescriptor;
// 36, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 37, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 38, 9
import org.apache.hadoop.hbase.util.Pair;
// 39, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 43, 1
    if ((servers != null && servers.size() > 0))
    {
      // 43, 47
      jamonWriter.write("\n\n");
      // 45, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 50, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n        <li class=\"\"><a href=\"#tab_replicationStats\" data-toggle=\"tab\">Replications</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 61, 13
      {
        // 61, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 61, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 64, 13
      {
        // 64, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 64, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 67, 13
      {
        // 67, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 67, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 70, 13
      {
        // 70, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 70, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStats\">\n            ");
      // 73, 13
      {
        // 73, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 73, 62
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_replicationStats\">\n            ");
      // 76, 13
      {
        // 76, 13
        __jamon_innerUnit__replicationStats(jamonWriter, serverNames);
      }
      // 76, 63
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 81, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 328, 1
  private void __jamon_innerUnit__replicationStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 332, 1
    
        HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>> replicationLoadSourceMap
            = master.getReplicationLoad(serverNames);
        List<String> peers = null;
        if (replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0){
            peers = new ArrayList<>(replicationLoadSourceMap.keySet());
            Collections.sort(peers);
        }

    // 342, 1
    if ((replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0) )
    {
      // 342, 82
      jamonWriter.write("\n\n<div class=\"tabbable\">\n    <ul class=\"nav nav-tabs\">\n        ");
      // 346, 9
      
        String active = "active";
        for (String peer : peers){
        
      // 350, 13
      jamonWriter.write("<li class=");
      // 350, 23
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 350, 35
      jamonWriter.write("><a href=\"#tab_");
      // 350, 50
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 350, 60
      jamonWriter.write("\" data-toggle=\"tab\">Peer ");
      // 350, 85
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 350, 95
      jamonWriter.write("</a> </li>\n        ");
      // 351, 9
      
        active = "";
        }
        
      // 355, 5
      jamonWriter.write("</ul>\n    <div class=\"tab-content\">\n        ");
      // 357, 9
      
            active = "active";
            for (String peer : peers){
        
      // 361, 13
      jamonWriter.write("<div class=\"tab-pane ");
      // 361, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 361, 46
      jamonWriter.write("\" id=\"tab_");
      // 361, 56
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 361, 66
      jamonWriter.write("\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Server</th>\n                        <th>AgeOfLastShippedOp</th>\n                        <th>SizeOfLogQueue</th>\n                        <th>ReplicationLag</th>\n                    </tr>\n\n                    ");
      // 370, 21
      for (Pair<ServerName, ReplicationLoadSource> pair: replicationLoadSourceMap.get(peer) )
      {
        // 370, 110
        jamonWriter.write("\n                    <tr>\n                        <td>");
        // 372, 29
        {
          // 372, 29
          __jamon_innerUnit__serverNameLink(jamonWriter, pair.getFirst());
        }
        // 372, 78
        jamonWriter.write("</td>\n                        <td>");
        // 373, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanTimeDiff(pair.getSecond().getAgeOfLastShippedOp())), jamonWriter);
        // 373, 102
        jamonWriter.write("</td>\n                        <td>");
        // 374, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(pair.getSecond().getSizeOfLogQueue()), jamonWriter);
        // 374, 71
        jamonWriter.write("</td>\n                        <td>");
        // 375, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanTimeDiff(pair.getSecond().getReplicationLag())), jamonWriter);
        // 375, 98
        jamonWriter.write("</td>\n                    </tr>\n                    ");
      }
      // 377, 28
      jamonWriter.write("\n        </table>\n            </div>\n        ");
      // 380, 9
      
                active = "";
                }
        
      // 384, 5
      jamonWriter.write("</div>\n</div>\n");
    }
    // 386, 1
    else
    {
      // 386, 8
      jamonWriter.write("\n    <p>No Peers Metrics</p>\n");
    }
    // 388, 7
    jamonWriter.write("\n");
  }
  
  
  // 196, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 200, 1
    jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n</thead>\n<tbody>\n");
    // 210, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 216, 1
    jamonWriter.write("<tr>\n<td>");
    // 217, 5
    {
      // 217, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 217, 49
    jamonWriter.write("</td>\n<td>");
    // 218, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", sl.getRequestsPerSecond())), jamonWriter);
    // 218, 59
    jamonWriter.write("</td>\n<td>");
    // 219, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getReadRequestsCount()), jamonWriter);
    // 219, 36
    jamonWriter.write("</td>\n<td>");
    // 220, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getWriteRequestsCount()), jamonWriter);
    // 220, 37
    jamonWriter.write("</td>\n</tr>\n");
    // 222, 1
    
        }  else {
        
    // 225, 1
    {
      // 225, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 225, 40
    jamonWriter.write("\n");
    // 226, 1
    
        }
}

    // 230, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 407, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 411, 5
    jamonWriter.write("<tr>\n    <td>");
    // 412, 9
    {
      // 412, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 412, 53
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 391, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 395, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 400, 9
    if (infoPort > 0)
    {
      // 400, 28
      jamonWriter.write("\n            <a href=\"");
      // 401, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 401, 31
      jamonWriter.write("\">");
      // 401, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 401, 65
      jamonWriter.write("</a>\n        ");
    }
    // 402, 9
    else
    {
      // 402, 16
      jamonWriter.write("\n            ");
      // 403, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 403, 45
      jamonWriter.write("\n        ");
    }
    // 404, 15
    jamonWriter.write("\n");
  }
  
  
  // 152, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 156, 1
    jamonWriter.write("<table id=\"memoryStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n</thead>\n<tbody>\n");
    // 167, 1
    
for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {

    // 173, 1
    jamonWriter.write("<tr>\n    <td>");
    // 174, 9
    {
      // 174, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 174, 53
    jamonWriter.write("</td>\n    <td>");
    // 175, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getUsedHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 176, 55
    jamonWriter.write("</td>\n    <td>");
    // 177, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMaxHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 178, 55
    jamonWriter.write("</td>\n    <td>");
    // 179, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMemstoreSizeInMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 180, 55
    jamonWriter.write("</td>\n\n</tr>\n");
    // 183, 1
    
        }  else {

    // 186, 1
    {
      // 186, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 186, 40
    jamonWriter.write("\n");
    // 187, 1
    
        }
}

    // 191, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 83, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 87, 1
    jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n</thead>\n<tbody> \n");
    // 99, 1
    
    int totalRegions = 0;
    int totalRequests = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }
    
    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestsPerSecond();
        numRegionsOnline = sl.getNumberOfRegions();
        totalRegions += sl.getNumberOfRegions();
        // Is this correct?  Adding a rate to a measure.
        totalRequests += sl.getNumberOfRequests();
        lastContact = (System.currentTimeMillis() - sl.getReportTime())/1000;
    }
    long startcode = serverName.getStartcode();

    // 126, 1
    jamonWriter.write("<tr>\n    <td>");
    // 127, 9
    {
      // 127, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 127, 53
    jamonWriter.write("</td>\n    <td>");
    // 128, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 128, 34
    jamonWriter.write("</td>\n    <td>");
    // 129, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 129, 71
    jamonWriter.write("</td>\n    <td>");
    // 130, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 130, 22
    jamonWriter.write("</td>\n    <td>");
    // 131, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 131, 55
    jamonWriter.write("</td>\n    <td>");
    // 132, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 132, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 134, 1
    
}

    // 137, 1
    jamonWriter.write("</tbody> \n<tr><td>Total:");
    // 138, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 138, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
    // 141, 1
    if (inconsistentNodeNum > 0)
    {
      // 141, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 142, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 142, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 143, 1
    else
    {
      // 143, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 145, 7
    jamonWriter.write("\n<td>");
    // 146, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 146, 24
    jamonWriter.write("</td>\n<td>");
    // 147, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 147, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 283, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 287, 1
    jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting KVs</th>\n    <th>Num. Compacted KVs</th>\n    <th>Remaining KVs</th>\n    <th>Compaction Progress</th>\n</tr>\n</thead>\n<tbody>\n");
    // 298, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
String percentDone = "";
if  (sl.getTotalCompactingKVs() > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) sl.getCurrentCompactedKVs() / sl.getTotalCompactingKVs())) + "%";
}

    // 309, 1
    jamonWriter.write("<tr>\n<td>");
    // 310, 5
    {
      // 310, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 310, 49
    jamonWriter.write("</td>\n<td>");
    // 311, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs()), jamonWriter);
    // 311, 37
    jamonWriter.write("</td>\n<td>");
    // 312, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getCurrentCompactedKVs()), jamonWriter);
    // 312, 38
    jamonWriter.write("</td>\n<td>");
    // 313, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs() - sl.getCurrentCompactedKVs()), jamonWriter);
    // 313, 67
    jamonWriter.write("</td>\n<td>");
    // 314, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 314, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 316, 1
    
        }  else {
        
    // 319, 1
    {
      // 319, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 319, 40
    jamonWriter.write("\n");
    // 320, 1
    
    }
}

    // 324, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 235, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 239, 1
    jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n</thead>\n<tbody>\n");
    // 252, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 258, 1
    jamonWriter.write("<tr>\n<td>");
    // 259, 5
    {
      // 259, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 259, 49
    jamonWriter.write("</td>\n<td>");
    // 260, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStores()), jamonWriter);
    // 260, 25
    jamonWriter.write("</td>\n<td>");
    // 261, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStorefiles()), jamonWriter);
    // 261, 29
    jamonWriter.write("</td>\n<td>");
    // 262, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
  sl.getStoreUncompressedSizeMB() * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 263, 83
    jamonWriter.write("</td>\n<td>");
    // 264, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getStorefileSizeInMB()
  * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 265, 51
    jamonWriter.write("</td>\n<td>");
    // 266, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticIndexSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 267, 51
    jamonWriter.write("</td>\n<td>");
    // 268, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticBloomSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 269, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 271, 1
    
        }  else {
        
    // 274, 1
    {
      // 274, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 274, 40
    jamonWriter.write("\n");
    // 275, 1
    
    }
}

    // 279, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
}
