// Autogenerated Jamon implementation
// /Users/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import org.apache.hadoop.util.StringUtils;
// 34, 1
import org.apache.hadoop.hbase.util.Bytes;
// 35, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 36, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 37, 1
import org.apache.hadoop.hbase.master.HMaster;
// 38, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 39, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 40, 1
import org.apache.hadoop.hbase.HConstants;
// 41, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 42, 1
import org.apache.hadoop.hbase.ServerLoad;
// 43, 1
import org.apache.hadoop.hbase.ServerName;
// 44, 1
import org.apache.hadoop.hbase.client.Admin;
// 45, 1
import org.apache.hadoop.hbase.client.HConnectionManager;
// 46, 1
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
// 47, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 48, 1
import org.apache.hadoop.hbase.master.RegionState;
// 49, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 50, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 51, 1
import org.apache.hadoop.hbase.TableName;
// 52, 1
import org.apache.hadoop.hbase.tool.CanaryTool;
// 53, 1
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos.SnapshotDescription;
// 54, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 55, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 56, 1
import org.apache.hadoop.hbase.replication.ReplicationPeer;
// 57, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
// 58, 1
import org.apache.hadoop.hbase.replication.ReplicationSerDeHelper;
// 59, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 60, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;
// 61, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final AssignmentManager assignmentManager;
  private final ServerName metaLocation;
  private final String filter;
  private final boolean catalogJanitorEnabled;
  private final ServerManager serverManager;
  private final String format;
  private final Map<String,Integer> frags;
  private final Set<ServerName> deadServers;
  private final List<ServerName> servers;
  // 73, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    assignmentManager = p_implData.getAssignmentManager();
    metaLocation = p_implData.getMetaLocation();
    filter = p_implData.getFilter();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    serverManager = p_implData.getServerManager();
    format = p_implData.getFormat();
    frags = p_implData.getFrags();
    deadServers = p_implData.getDeadServers();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 64, 1
    if (format.equals("json") )
    {
      // 64, 30
      jamonWriter.write("\n  ");
      // 65, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_7.setFilter(filter);
        __jamon__var_7.setFormat("json" );
        __jamon__var_7.renderNoFlush(jamonWriter);
      }
      // 65, 68
      jamonWriter.write("\n  ");
      // 66, 3
      return; 
    }
    // 67, 7
    jamonWriter.write("\n");
    // 68, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 100, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 107, 12
    if (master.isActiveMaster() )
    {
      // 107, 43
      jamonWriter.write("Master: ");
    }
    // 107, 51
    else
    {
      // 107, 58
      jamonWriter.write("Backup Master: ");
    }
    // 107, 79
    jamonWriter.write("\n    ");
    // 108, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 108, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/procedures.jsp\">Procedures</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 138, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 138, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 140, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 147, 2
    if (master.isActiveMaster() )
    {
      // 147, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 150, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 150, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 156, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 156, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 158, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 158, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n          for details.\n          </div>\n        ");
      }
      // 163, 15
      jamonWriter.write("\n        ");
      // 164, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 164, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 169, 15
      jamonWriter.write("\n        ");
      // 170, 9
      if (master.isInMaintenanceMode() )
      {
        // 170, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This may be because of HBCK aborting while\n          running in repair mode. Please re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 175, 15
      jamonWriter.write("\n        ");
      // 176, 9
      if (!master.isBalancerOn() )
      {
        // 176, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 182, 15
      jamonWriter.write("\n        ");
      // 183, 9
      if (!master.isSplitOrMergeEnabled(Admin.MasterSwitchType.SPLIT) )
      {
        // 183, 76
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 189, 15
      jamonWriter.write("\n        ");
      // 190, 9
      if (!master.isSplitOrMergeEnabled(Admin.MasterSwitchType.MERGE) )
      {
        // 190, 76
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 196, 15
      jamonWriter.write("\n\n        <section>\n            <h2>Region Servers</h2>\n            ");
      // 200, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_8.setServers(servers );
        __jamon__var_8.renderNoFlush(jamonWriter, master);
      }
      // 200, 74
      jamonWriter.write("\n\n            ");
      // 202, 13
      if ((deadServers != null) )
      {
        // 202, 42
        jamonWriter.write("\n                ");
        // 203, 17
        {
          // 203, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 203, 40
        jamonWriter.write("\n            ");
      }
      // 204, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 207, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_9.renderNoFlush(jamonWriter, master );
      }
      // 207, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 225, 25
      if ((metaLocation != null) )
      {
        // 225, 55
        jamonWriter.write("\n                            ");
        // 226, 29
        {
          // 226, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 226, 45
        jamonWriter.write("\n                        ");
      }
      // 227, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 230, 25
      if ((metaLocation != null) )
      {
        // 230, 55
        jamonWriter.write("\n                            ");
        // 231, 29
        {
          // 231, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 231, 48
        jamonWriter.write("\n                        ");
      }
      // 232, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 235, 25
      {
        // 235, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 235, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        <section>\n            <h2>Peers</h2>\n            ");
      // 242, 13
      {
        // 242, 13
        __jamon_innerUnit__peerConfigs(jamonWriter);
      }
      // 242, 30
      jamonWriter.write("\n        </section>\n        ");
      // 244, 9
      if (master.getAssignmentManager() != null )
      {
        // 244, 54
        jamonWriter.write("\n        ");
        // 245, 9
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_10.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 245, 90
        jamonWriter.write("\n        ");
      }
      // 246, 15
      jamonWriter.write("\n\t");
    }
    // 247, 2
    else
    {
      // 247, 9
      jamonWriter.write("\n        <section>\n            ");
      // 249, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_11.renderNoFlush(jamonWriter, master );
      }
      // 249, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 251, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 255, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_12 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_12.setFilter(filter );
      __jamon__var_12.renderNoFlush(jamonWriter);
    }
    // 255, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 268, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 268, 84
    jamonWriter.write(", revision=");
    // 268, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 268, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 272, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 272, 81
    jamonWriter.write(", ");
    // 272, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 272, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 277, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 277, 88
    jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 282, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 282, 78
    jamonWriter.write(", revision=");
    // 282, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 282, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 287, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 287, 75
    jamonWriter.write(", ");
    // 287, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 287, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 292, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 292, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 297, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 297, 72
    jamonWriter.write(", revision=");
    // 297, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevision()), jamonWriter);
    // 297, 131
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 302, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 302, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Quorum</td>\n                    <td> ");
    // 308, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 308, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Base Path</td>\n                    <td> ");
    // 313, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getBaseZNode()), jamonWriter);
    // 313, 68
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 318, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 318, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 323, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 323, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 326, 17
    if (master.isActiveMaster() )
    {
      // 326, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 329, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 329, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 334, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 334, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 339, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 340, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 343, 18
      if (frags != null )
      {
        // 343, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 346, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 346, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 349, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 352, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 353, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 358, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 358, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 361, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script>\n        $(document).ready(function() \n            { \n                $(\"#baseStatsTable\").tablesorter();\n                $(\"#memoryStatsTable\").tablesorter();\n                $(\"#requestStatsTable\").tablesorter();\n                $(\"#storeStatsTable\").tablesorter();\n                $(\"#compactionStatsTable\").tablesorter();\n                \n                $(\"#userTables\").tablesorter();\n            } \n        );\n        </script>\n  </body>\n</html>\n\n");
  }
  
  
  // 503, 1
  private void __jamon_innerUnit__userSnapshots(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 504, 1
    
   List<SnapshotDescription> snapshots = null;
   try (Admin admin = master.getConnection().getAdmin()) {
     snapshots = master.isInitialized() ? admin.listSnapshots() : null;
   }

    // 510, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 510, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 517, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 517, 57
        jamonWriter.write("\n    ");
        // 518, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 521, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 522, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 522, 68
        jamonWriter.write("\">");
        // 522, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 522, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 523, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 523, 74
        jamonWriter.write("\">");
        // 523, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 523, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 525, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 525, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 527, 12
      jamonWriter.write("\n    <p>");
      // 528, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 528, 30
      jamonWriter.write(" snapshot(s) in set. [<a href=\"/snapshotsStats.jsp\">Snapshot Storefile stats</a>]</p>\n</table>\n");
    }
    // 530, 7
    jamonWriter.write("\n");
  }
  
  
  // 387, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 388, 1
    
 HTableDescriptor[] sysTables = null;
 try (Admin admin = master.getConnection().getAdmin()) {
   sysTables = master.isInitialized() ? admin.listTableDescriptorsByNamespace(
     NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;
 }

    // 395, 1
    if ((sysTables != null && sysTables.length > 0))
    {
      // 395, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 399, 5
      if ((frags != null) )
      {
        // 399, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 401, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 404, 1
      for (HTableDescriptor systemTable : sysTables)
      {
        // 404, 49
        jamonWriter.write("\n<tr>\n");
        // 406, 1
        TableName tableName = systemTable.getTableName();
        // 407, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 407, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 407, 48
        jamonWriter.write("\">");
        // 407, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 407, 65
        jamonWriter.write("</a></td>\n    ");
        // 408, 5
        if ((frags != null))
        {
          // 408, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 409, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 410, 37
          jamonWriter.write("</td>\n    ");
        }
        // 411, 11
        jamonWriter.write("\n    ");
        // 412, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(CanaryTool.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups";
        }
    
        // 431, 5
        jamonWriter.write("<td>");
        // 431, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 431, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 433, 8
      jamonWriter.write("\n</table>\n");
    }
    // 435, 7
    jamonWriter.write("\n");
  }
  
  
  // 438, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 439, 1
    
   HTableDescriptor[] tables = null;
   try (Admin admin = master.getConnection().getAdmin()) {
     tables = master.isInitialized() ? admin.listTables() : null;
   }

    // 445, 1
    if ((tables != null && tables.length > 0))
    {
      // 445, 45
      jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th>Namespace</th>\n        <th>Table Name</th>\n        ");
      // 451, 9
      if ((frags != null) )
      {
        // 451, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 453, 15
      jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Offline Regions</th>\n        <th>Failed Regions</th>\n        <th>Split Regions</th>\n        <th>Other Regions</th>\n        <th>Description</th>\n    </tr>\n</thead>\n<tbody>\n    ");
      // 463, 5
      for (HTableDescriptor htDesc : tables)
      {
        // 463, 45
        jamonWriter.write("\n    ");
        // 464, 5
        
      TableName tableName = htDesc.getTableName();
      Map<RegionState.State, List<HRegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<HRegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount;
    
        // 483, 5
        jamonWriter.write("<tr>\n        <td>");
        // 484, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 484, 51
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 485, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
        // 485, 69
        jamonWriter.write(">");
        // 485, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getQualifierAsString()), jamonWriter);
        // 485, 108
        jamonWriter.write("</a> </td>\n        ");
        // 486, 9
        if ((frags != null) )
        {
          // 486, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 487, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 487, 150
          jamonWriter.write("</td>\n        ");
        }
        // 488, 15
        jamonWriter.write("\n        <td>");
        // 489, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 489, 35
        jamonWriter.write("</td>\n        <td>");
        // 490, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 490, 38
        jamonWriter.write("</td>\n        <td>");
        // 491, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 491, 37
        jamonWriter.write("</td>\n        <td>");
        // 492, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 492, 36
        jamonWriter.write("</td>\n        <td>");
        // 493, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 493, 36
        jamonWriter.write("</td>\n        <td>");
        // 494, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 494, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 496, 12
      jamonWriter.write("\n    <p>");
      // 497, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.length), jamonWriter);
      // 497, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</tbody>\n</table>\n");
    }
    // 500, 7
    jamonWriter.write("\n");
  }
  
  
  // 567, 1
  private void __jamon_innerUnit__peerConfigs(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 568, 1
    
    Map<String, ReplicationPeerConfig> peers = null;
    try (ReplicationAdmin admin = new ReplicationAdmin(master.getConfiguration())) {
        peers = admin.listPeerConfigs();
    }

    // 574, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Peer Id</th>\n        <th>Cluster Key</th>\n        <th>Bandwidth</th>\n        <th>Table Cfs</th>\n    </tr>\n");
    // 581, 1
    if ((peers != null && peers.size() > 0))
    {
      // 581, 43
      jamonWriter.write("\n    ");
      // 582, 5
      for (Map.Entry<String, ReplicationPeerConfig> peer : peers.entrySet() )
      {
        // 582, 78
        jamonWriter.write("\n    ");
        // 583, 5
        
        String peerId = peer.getKey();
        ReplicationPeerConfig peerConfig = peer.getValue();
    
        // 587, 5
        jamonWriter.write("<tr>\n        <td>");
        // 588, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerId), jamonWriter);
        // 588, 25
        jamonWriter.write("</td>\n        <td>");
        // 589, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getClusterKey()), jamonWriter);
        // 589, 45
        jamonWriter.write("</td>\n        <td>");
        // 590, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getBandwidth() == 0? "UNLIMITED" : StringUtils.humanReadableInt(peerConfig.getBandwidth())), jamonWriter);
        // 590, 120
        jamonWriter.write("</td>\n        <td>\n           ");
        // 592, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getTableCFsMap() == null ? "" : ReplicationSerDeHelper.convertToString(peerConfig.getTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 592, 150
        jamonWriter.write("\n        </td>\n    </tr>\n    ");
      }
      // 595, 12
      jamonWriter.write("\n");
    }
    // 596, 7
    jamonWriter.write("\n<tr><td>Total: ");
    // 597, 16
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf((peers != null) ? peers.size() : 0), jamonWriter);
    // 597, 56
    jamonWriter.write("</td></tr>\n</table>\n");
  }
  
  
  // 534, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 536, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 536, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 544, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 550, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 552, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 552, 33
      jamonWriter.write("</td>\n        <td>");
      // 553, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 553, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 555, 5
      
        }
    
      // 558, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 560, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 560, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 564, 7
    jamonWriter.write("\n");
  }
  
  
}
