/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.util.concurrent.AtomicLongMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.io.WALLink;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.KeeperException;

public class DumpReplicationQueues
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog((String)DumpReplicationQueues.class.getName());
    private List<String> deadRegionServers = new ArrayList<String>();
    private List<String> deletedQueues = new ArrayList<String>();
    private AtomicLongMap<String> peersQueueSize = AtomicLongMap.create();
    private long totalSizeOfWALs = 0L;
    private long numWalsNotFound = 0L;

    static DumpOptions parseOpts(Queue<String> args) {
        DumpOptions opts = new DumpOptions();
        String cmd = null;
        while ((cmd = args.poll()) != null) {
            if (cmd.equals("-h") || cmd.equals("--h") || cmd.equals("--help")) {
                args.add(cmd);
                break;
            }
            String hdfs = "--hdfs";
            if (cmd.equals("--hdfs")) {
                opts.setHdfs(true);
                continue;
            }
            String distributed = "--distributed";
            if (cmd.equals("--distributed")) {
                opts.setDistributed(true);
                continue;
            }
            DumpReplicationQueues.printUsageAndExit("ERROR: Unrecognized option/command: " + cmd, -1);
            if (opts.isDistributed() || !opts.isHdfs()) continue;
            DumpReplicationQueues.printUsageAndExit("ERROR: --hdfs option can only be used with --distributed: " + cmd, -1);
        }
        return opts;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new DumpReplicationQueues(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        int errCode = -1;
        LinkedList<String> argv = new LinkedList<String>();
        argv.addAll(Arrays.asList(args));
        DumpOptions opts = DumpReplicationQueues.parseOpts(argv);
        if (!argv.isEmpty()) {
            errCode = 0;
            this.printUsage();
            return errCode;
        }
        return this.dumpReplicationQueues(opts);
    }

    protected void printUsage() {
        DumpReplicationQueues.printUsage(((Object)((Object)this)).getClass().getName(), null);
    }

    protected static void printUsage(String message) {
        DumpReplicationQueues.printUsage(DumpReplicationQueues.class.getName(), message);
    }

    protected static void printUsage(String className, String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: bin/hbase " + className + " \\");
        System.err.println("  <OPTIONS> [-D<property=value>]*");
        System.err.println();
        System.err.println("General Options:");
        System.err.println(" -h|--h|--help  Show this help and exit.");
        System.err.println(" --distributed  Poll each RS and print its own replication queue. Default only polls ZooKeeper");
        System.err.println(" --hdfs         Use HDFS to calculate usage of WALs by replication. It could be overestimated if replicating to multiple peers. --distributed flag is also needed.");
    }

    protected static void printUsageAndExit(String message, int exitCode) {
        DumpReplicationQueues.printUsage(message);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpReplicationQueues(DumpOptions opts) throws Exception {
        Configuration conf = this.getConf();
        HBaseAdmin.checkHBaseAvailable((Configuration)conf);
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(conf);
        ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)conf);
        try (ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "DumpReplicationQueues" + System.currentTimeMillis(), (Abortable)new WarnOnlyAbortable(), true);){
            LOG.info((Object)("Our Quorum: " + zkw.getQuorum()));
            List replicatedTables = replicationAdmin.listReplicated();
            if (replicatedTables.isEmpty()) {
                LOG.info((Object)"No tables with a configured replication peer were found.");
                int n = 0;
                return n;
            }
            LOG.info((Object)("Replicated Tables: " + replicatedTables));
            Map peerConfigs = replicationAdmin.listPeerConfigs();
            if (peerConfigs.isEmpty()) {
                LOG.info((Object)"Replication is enabled but no peer configuration was found.");
            }
            System.out.println("Dumping replication peers and configurations:");
            System.out.println(this.dumpPeersState(replicationAdmin, peerConfigs));
            if (opts.isDistributed()) {
                LOG.info((Object)"Found [--distributed], will poll each RegionServer.");
                System.out.println(this.dumpQueues(connection, peerConfigs.keySet(), zkw, opts.isHdfs()));
                System.out.println(this.dumpReplicationSummary());
            } else {
                System.out.print("Dumping replication znodes via ZooKeeper:");
                System.out.println(ZKUtil.getReplicationZnodesDump((ZooKeeperWatcher)zkw));
            }
            int n = 0;
            return n;
        }
    }

    public String dumpReplicationSummary() {
        StringBuilder sb = new StringBuilder();
        if (!this.deletedQueues.isEmpty()) {
            sb.append("Found " + this.deletedQueues.size() + " deleted queues" + ", run hbck -fixReplication in order to remove the deleted replication queues\n");
            for (String string : this.deletedQueues) {
                sb.append("    " + string + "\n");
            }
        }
        if (!this.deadRegionServers.isEmpty()) {
            sb.append("Found " + this.deadRegionServers.size() + " dead regionservers" + ", restart one regionserver to transfer the queues of dead regionservers\n");
            for (String string : this.deadRegionServers) {
                sb.append("    " + string + "\n");
            }
        }
        if (!this.peersQueueSize.isEmpty()) {
            sb.append("Dumping all peers's number of WALs in replication queue\n");
            for (Map.Entry entry : this.peersQueueSize.asMap().entrySet()) {
                sb.append("    PeerId: " + (String)entry.getKey() + " , sizeOfLogQueue: " + entry.getValue() + "\n");
            }
        }
        sb.append("    Total size of WALs on HDFS: " + StringUtils.humanSize((double)this.totalSizeOfWALs) + "\n");
        if (this.numWalsNotFound > 0L) {
            sb.append("    ERROR: There are " + this.numWalsNotFound + " WALs not found!!!\n");
        }
        return sb.toString();
    }

    public String dumpPeersState(ReplicationAdmin replicationAdmin, Map<String, ReplicationPeerConfig> peerConfigs) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ReplicationPeerConfig> peer : peerConfigs.entrySet()) {
            try {
                ReplicationPeerConfig peerConfig = peer.getValue();
                sb.append("Peer: " + peer.getKey() + "\n");
                sb.append("    State: " + (replicationAdmin.getPeerState(peer.getKey()) ? "ENABLED" : "DISABLED") + "\n");
                sb.append("    Cluster Name: " + peerConfig.getClusterKey() + "\n");
                Map currentConf = peerConfig.getConfiguration();
                if (currentConf.size() > 1) {
                    sb.append("    Peer Configuration: " + currentConf + "\n");
                }
                sb.append("    Peer Table CFs: " + peerConfig.getTableCFsMap() + "\n");
            }
            catch (ReplicationException re) {
                sb.append("Got an exception while invoking ReplicationAdmin: " + (Object)((Object)re) + "\n");
            }
        }
        return sb.toString();
    }

    public String dumpQueues(ClusterConnection connection, Set<String> peerIds, ZooKeeperWatcher zkw, boolean hdfs) throws Exception {
        StringBuilder sb = new StringBuilder();
        ReplicationQueuesClient queuesClient = ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)zkw, (Configuration)this.getConf(), (Abortable)connection);
        queuesClient.init();
        ReplicationQueues replicationQueues = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)zkw, (Configuration)this.getConf(), (Abortable)connection);
        ReplicationPeers replicationPeers = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)zkw, (Configuration)this.getConf(), (ReplicationQueuesClient)queuesClient, (Abortable)connection);
        ReplicationTracker replicationTracker = ReplicationFactory.getReplicationTracker((ZooKeeperWatcher)zkw, (ReplicationPeers)replicationPeers, (Configuration)this.getConf(), (Abortable)new WarnOnlyAbortable(), (Stoppable)new WarnOnlyStoppable());
        List liveRegionServers = replicationTracker.getListOfRegionServers();
        try {
            List regionservers = queuesClient.getListOfReplicators();
            if (regionservers == null || regionservers.isEmpty()) {
                return sb.toString();
            }
            for (String regionserver : regionservers) {
                List queueIds = queuesClient.getAllQueues(regionserver);
                replicationQueues.init(regionserver);
                if (!liveRegionServers.contains(regionserver)) {
                    this.deadRegionServers.add(regionserver);
                }
                for (String queueId : queueIds) {
                    ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                    List wals = queuesClient.getLogsInQueue(regionserver, queueId);
                    if (!peerIds.contains(queueInfo.getPeerId())) {
                        this.deletedQueues.add(regionserver + "/" + queueId);
                        sb.append(this.formatQueue(regionserver, replicationQueues, queueInfo, queueId, wals, true, hdfs));
                        continue;
                    }
                    sb.append(this.formatQueue(regionserver, replicationQueues, queueInfo, queueId, wals, false, hdfs));
                }
            }
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
        return sb.toString();
    }

    private String formatQueue(String regionserver, ReplicationQueues replicationQueues, ReplicationQueueInfo queueInfo, String queueId, List<String> wals, boolean isDeleted, boolean hdfs) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Dumping replication queue info for RegionServer: [" + regionserver + "]" + "\n");
        sb.append("    Queue znode: " + queueId + "\n");
        sb.append("    PeerID: " + queueInfo.getPeerId() + "\n");
        sb.append("    Recovered: " + queueInfo.isQueueRecovered() + "\n");
        List deadServers = queueInfo.getDeadRegionServers();
        if (deadServers.isEmpty()) {
            sb.append("    No dead RegionServers found in this queue.\n");
        } else {
            sb.append("    Dead RegionServers: " + deadServers + "\n");
        }
        sb.append("    Was deleted: " + isDeleted + "\n");
        sb.append("    Number of WALs in replication queue: " + wals.size() + "\n");
        this.peersQueueSize.addAndGet((Object)queueInfo.getPeerId(), (long)wals.size());
        for (String wal : wals) {
            long position = replicationQueues.getLogPosition(queueInfo.getPeerId(), wal);
            sb.append("    Replication position for " + wal + ": " + (position > 0L ? Long.valueOf(position) : "0 (not started or nothing to replicate)") + "\n");
        }
        if (hdfs) {
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            sb.append("    Total size of WALs on HDFS for this queue: " + StringUtils.humanSize((double)this.getTotalWALSize(fs, wals, regionserver)) + "\n");
        }
        return sb.toString();
    }

    private long getTotalWALSize(FileSystem fs, List<String> wals, String server) throws IOException {
        long size = 0L;
        for (String wal : wals) {
            FileStatus fileStatus;
            try {
                fileStatus = new WALLink(this.getConf(), server, wal).getFileStatus(fs);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    ++this.numWalsNotFound;
                    LOG.warn((Object)("WAL " + wal + " couldn't be found, skipping"), (Throwable)e);
                    continue;
                }
                LOG.warn((Object)("Can't get file status of WAL " + wal + ", skipping"), (Throwable)e);
                continue;
            }
            size += fileStatus.getLen();
        }
        this.totalSizeOfWALs += size;
        return size;
    }

    private static class WarnOnlyStoppable
    implements Stoppable {
        private WarnOnlyStoppable() {
        }

        public void stop(String why) {
            LOG.warn((Object)("DumpReplicationQueue received stop, ignoring.  Reason: " + why));
        }

        public boolean isStopped() {
            return false;
        }
    }

    private static class WarnOnlyAbortable
    implements Abortable {
        private WarnOnlyAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.warn((Object)("DumpReplicationQueue received abort, ignoring.  Reason: " + why));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
        }

        public boolean isAborted() {
            return false;
        }
    }

    static class DumpOptions {
        boolean hdfs = false;
        boolean distributed = false;

        public DumpOptions() {
        }

        public DumpOptions(DumpOptions that) {
            this.hdfs = that.hdfs;
            this.distributed = that.distributed;
        }

        boolean isHdfs() {
            return this.hdfs;
        }

        boolean isDistributed() {
            return this.distributed;
        }

        void setHdfs(boolean hdfs) {
            this.hdfs = hdfs;
        }

        void setDistributed(boolean distributed) {
            this.distributed = distributed;
        }
    }
}

