/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionWindowFactory;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.ExponentialCompactionWindowFactory;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;

@InterfaceAudience.Private
public class CompactionConfiguration {
    private static final Log LOG = LogFactory.getLog(CompactionConfiguration.class);
    public static final String HBASE_HSTORE_COMPACTION_RATIO_KEY = "hbase.hstore.compaction.ratio";
    public static final String HBASE_HSTORE_COMPACTION_RATIO_OFFPEAK_KEY = "hbase.hstore.compaction.ratio.offpeak";
    public static final String HBASE_HSTORE_COMPACTION_MIN_KEY = "hbase.hstore.compaction.min";
    public static final String HBASE_HSTORE_COMPACTION_MIN_SIZE_KEY = "hbase.hstore.compaction.min.size";
    public static final String HBASE_HSTORE_COMPACTION_MAX_KEY = "hbase.hstore.compaction.max";
    public static final String HBASE_HSTORE_COMPACTION_DISCHARGER_THREAD_COUNT = "hbase.hstore.compaction.discharger.thread.count";
    public static final String HBASE_HSTORE_COMPACTION_MAX_SIZE_KEY = "hbase.hstore.compaction.max.size";
    public static final String HBASE_HSTORE_COMPACTION_MAX_SIZE_OFFPEAK_KEY = "hbase.hstore.compaction.max.size.offpeak";
    public static final String HBASE_HSTORE_OFFPEAK_END_HOUR = "hbase.offpeak.end.hour";
    public static final String HBASE_HSTORE_OFFPEAK_START_HOUR = "hbase.offpeak.start.hour";
    public static final String HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT = "hbase.hstore.min.locality.to.skip.major.compact";
    public static final String HBASE_HFILE_COMPACTION_DISCHARGER_THREAD_COUNT = "hbase.hfile.compaction.discharger.thread.count";
    public static final String HBASE_HFILE_COMPACTION_DISCHARGER_INTERVAL = "hbase.hfile.compaction.discharger.interval";
    public static final String DATE_TIERED_MAX_AGE_MILLIS_KEY = "hbase.hstore.compaction.date.tiered.max.storefile.age.millis";
    public static final String DATE_TIERED_INCOMING_WINDOW_MIN_KEY = "hbase.hstore.compaction.date.tiered.incoming.window.min";
    public static final String COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS_KEY = "hbase.hstore.compaction.date.tiered.window.policy.class";
    public static final String DATE_TIERED_SINGLE_OUTPUT_FOR_MINOR_COMPACTION_KEY = "hbase.hstore.compaction.date.tiered.single.output.for.minor.compaction";
    private static final Class<? extends RatioBasedCompactionPolicy> DEFAULT_COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS = ExploringCompactionPolicy.class;
    public static final String DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS_KEY = "hbase.hstore.compaction.date.tiered.window.factory.class";
    private static final Class<? extends CompactionWindowFactory> DEFAULT_DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS = ExponentialCompactionWindowFactory.class;
    Configuration conf;
    StoreConfigInformation storeConfigInfo;
    private final double offPeakCompactionRatio;
    private final long maxCompactSize;
    private final long offPeakMaxCompactSize;
    private final long minCompactSize;
    private int minFilesToCompact;
    private final int maxFilesToCompact;
    private final double compactionRatio;
    private final long throttlePoint;
    private final long majorCompactionPeriod;
    private final float majorCompactionJitter;
    private final float minLocalityToForceCompact;
    private final long dateTieredMaxStoreFileAgeMillis;
    private final int dateTieredIncomingWindowMin;
    private final String compactionPolicyForDateTieredWindow;
    private final boolean dateTieredSingleOutputForMinorCompaction;
    private final String dateTieredCompactionWindowFactory;

    CompactionConfiguration(Configuration conf, StoreConfigInformation storeConfigInfo) {
        this.conf = conf;
        this.storeConfigInfo = storeConfigInfo;
        this.maxCompactSize = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_SIZE_KEY, Long.MAX_VALUE);
        this.offPeakMaxCompactSize = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_SIZE_OFFPEAK_KEY, this.maxCompactSize);
        this.minCompactSize = conf.getLong(HBASE_HSTORE_COMPACTION_MIN_SIZE_KEY, storeConfigInfo.getMemstoreFlushSize());
        this.minFilesToCompact = Math.max(2, conf.getInt(HBASE_HSTORE_COMPACTION_MIN_KEY, conf.getInt("hbase.hstore.compactionThreshold", 3)));
        this.maxFilesToCompact = conf.getInt(HBASE_HSTORE_COMPACTION_MAX_KEY, 10);
        this.compactionRatio = conf.getFloat(HBASE_HSTORE_COMPACTION_RATIO_KEY, 1.2f);
        this.offPeakCompactionRatio = conf.getFloat(HBASE_HSTORE_COMPACTION_RATIO_OFFPEAK_KEY, 5.0f);
        this.throttlePoint = conf.getLong("hbase.regionserver.thread.compaction.throttle", (long)(2 * this.maxFilesToCompact) * storeConfigInfo.getMemstoreFlushSize());
        this.majorCompactionPeriod = conf.getLong("hbase.hregion.majorcompaction", 604800000L);
        this.majorCompactionJitter = conf.getFloat("hbase.hregion.majorcompaction.jitter", 0.5f);
        this.minLocalityToForceCompact = conf.getFloat(HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT, 0.0f);
        this.dateTieredMaxStoreFileAgeMillis = conf.getLong(DATE_TIERED_MAX_AGE_MILLIS_KEY, Long.MAX_VALUE);
        this.dateTieredIncomingWindowMin = conf.getInt(DATE_TIERED_INCOMING_WINDOW_MIN_KEY, 6);
        this.compactionPolicyForDateTieredWindow = conf.get(COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS_KEY, DEFAULT_COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS.getName());
        this.dateTieredSingleOutputForMinorCompaction = conf.getBoolean(DATE_TIERED_SINGLE_OUTPUT_FOR_MINOR_COMPACTION_KEY, true);
        this.dateTieredCompactionWindowFactory = conf.get(DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS_KEY, DEFAULT_DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS.getName());
        LOG.info((Object)this);
    }

    public String toString() {
        return String.format("size [%d, %d, %d); files [%d, %d); ratio %f; off-peak ratio %f; throttle point %d; major period %d, major jitter %f, min locality to compact %f; tiered compaction: max_age %d, incoming window min %d, compaction policy for tiered window %s, single output for minor %b, compaction window factory %s", this.minCompactSize, this.maxCompactSize, this.offPeakMaxCompactSize, this.minFilesToCompact, this.maxFilesToCompact, this.compactionRatio, this.offPeakCompactionRatio, this.throttlePoint, this.majorCompactionPeriod, Float.valueOf(this.majorCompactionJitter), Float.valueOf(this.minLocalityToForceCompact), this.dateTieredMaxStoreFileAgeMillis, this.dateTieredIncomingWindowMin, this.compactionPolicyForDateTieredWindow, this.dateTieredSingleOutputForMinorCompaction, this.dateTieredCompactionWindowFactory);
    }

    public long getMinCompactSize() {
        return this.minCompactSize;
    }

    public long getMaxCompactSize() {
        return this.maxCompactSize;
    }

    public int getMinFilesToCompact() {
        return this.minFilesToCompact;
    }

    public void setMinFilesToCompact(int threshold) {
        this.minFilesToCompact = threshold;
    }

    public int getMaxFilesToCompact() {
        return this.maxFilesToCompact;
    }

    public double getCompactionRatio() {
        return this.compactionRatio;
    }

    public double getCompactionRatioOffPeak() {
        return this.offPeakCompactionRatio;
    }

    public long getThrottlePoint() {
        return this.throttlePoint;
    }

    public long getMajorCompactionPeriod() {
        return this.majorCompactionPeriod;
    }

    public float getMajorCompactionJitter() {
        return this.majorCompactionJitter;
    }

    public float getMinLocalityToForceCompact() {
        return this.minLocalityToForceCompact;
    }

    public long getOffPeakMaxCompactSize() {
        return this.offPeakMaxCompactSize;
    }

    public long getMaxCompactSize(boolean mayUseOffpeak) {
        if (mayUseOffpeak) {
            return this.getOffPeakMaxCompactSize();
        }
        return this.getMaxCompactSize();
    }

    public long getDateTieredMaxStoreFileAgeMillis() {
        return this.dateTieredMaxStoreFileAgeMillis;
    }

    public int getDateTieredIncomingWindowMin() {
        return this.dateTieredIncomingWindowMin;
    }

    public String getCompactionPolicyForDateTieredWindow() {
        return this.compactionPolicyForDateTieredWindow;
    }

    public boolean useDateTieredSingleOutputForMinorCompaction() {
        return this.dateTieredSingleOutputForMinorCompaction;
    }

    public String getDateTieredCompactionWindowFactory() {
        return this.dateTieredCompactionWindowFactory;
    }
}

