/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestCoprocessorConfiguration {
    private static final Configuration CONF = HBaseConfiguration.create();
    private static final TableName TABLENAME;
    private static final HRegionInfo REGIONINFO;
    private static final HTableDescriptor TABLEDESC;
    private static final AtomicBoolean systemCoprocessorLoaded;
    private static final AtomicBoolean tableCoprocessorLoaded;

    @Test
    public void testRegionCoprocessorHostDefaults() throws Exception {
        Configuration conf = new Configuration(CONF);
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)region.getRegionInfo()).thenReturn((Object)REGIONINFO);
        Mockito.when((Object)region.getTableDesc()).thenReturn((Object)TABLEDESC);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        systemCoprocessorLoaded.set(false);
        tableCoprocessorLoaded.set(false);
        new RegionCoprocessorHost((Region)region, rsServices, conf);
        Assert.assertEquals((String)"System coprocessors loading default was not honored", (Object)systemCoprocessorLoaded.get(), (Object)true);
        Assert.assertEquals((String)"Table coprocessors loading default was not honored", (Object)tableCoprocessorLoaded.get(), (Object)true);
    }

    @Test
    public void testRegionServerCoprocessorHostDefaults() throws Exception {
        Configuration conf = new Configuration(CONF);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        systemCoprocessorLoaded.set(false);
        new RegionServerCoprocessorHost(rsServices, conf);
        Assert.assertEquals((String)"System coprocessors loading default was not honored", (Object)systemCoprocessorLoaded.get(), (Object)true);
    }

    @Test
    public void testMasterCoprocessorHostDefaults() throws Exception {
        Configuration conf = new Configuration(CONF);
        MasterServices masterServices = (MasterServices)Mockito.mock(MasterServices.class);
        systemCoprocessorLoaded.set(false);
        new MasterCoprocessorHost(masterServices, conf);
        Assert.assertEquals((String)"System coprocessors loading default was not honored", (Object)systemCoprocessorLoaded.get(), (Object)true);
    }

    @Test
    public void testRegionCoprocessorHostAllDisabled() throws Exception {
        Configuration conf = new Configuration(CONF);
        conf.setBoolean("hbase.coprocessor.enabled", false);
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)region.getRegionInfo()).thenReturn((Object)REGIONINFO);
        Mockito.when((Object)region.getTableDesc()).thenReturn((Object)TABLEDESC);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        systemCoprocessorLoaded.set(false);
        tableCoprocessorLoaded.set(false);
        new RegionCoprocessorHost((Region)region, rsServices, conf);
        Assert.assertFalse((String)"System coprocessors should not have been loaded", (boolean)systemCoprocessorLoaded.get());
        Assert.assertFalse((String)"Table coprocessors should not have been loaded", (boolean)tableCoprocessorLoaded.get());
    }

    @Test
    public void testRegionCoprocessorHostTableLoadingDisabled() throws Exception {
        Configuration conf = new Configuration(CONF);
        conf.setBoolean("hbase.coprocessor.enabled", true);
        conf.setBoolean("hbase.coprocessor.user.enabled", false);
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)region.getRegionInfo()).thenReturn((Object)REGIONINFO);
        Mockito.when((Object)region.getTableDesc()).thenReturn((Object)TABLEDESC);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        systemCoprocessorLoaded.set(false);
        tableCoprocessorLoaded.set(false);
        new RegionCoprocessorHost((Region)region, rsServices, conf);
        Assert.assertTrue((String)"System coprocessors should have been loaded", (boolean)systemCoprocessorLoaded.get());
        Assert.assertFalse((String)"Table coprocessors should not have been loaded", (boolean)tableCoprocessorLoaded.get());
    }

    static {
        CONF.setStrings("hbase.coprocessor.master.classes", new String[]{SystemCoprocessor.class.getName()});
        CONF.setStrings("hbase.coprocessor.regionserver.classes", new String[]{SystemCoprocessor.class.getName()});
        CONF.setStrings("hbase.coprocessor.region.classes", new String[]{SystemCoprocessor.class.getName()});
        TABLENAME = TableName.valueOf((String)"TestCoprocessorConfiguration");
        REGIONINFO = new HRegionInfo(TABLENAME);
        TABLEDESC = new HTableDescriptor(TABLENAME);
        try {
            TABLEDESC.addCoprocessor(TableCoprocessor.class.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        systemCoprocessorLoaded = new AtomicBoolean();
        tableCoprocessorLoaded = new AtomicBoolean();
    }

    public static class TableCoprocessor
    implements Coprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            tableCoprocessorLoaded.set(true);
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }
    }

    public static class SystemCoprocessor
    implements Coprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            systemCoprocessorLoaded.set(true);
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }
    }
}

