/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJob;
import org.apache.hadoop.hbase.mob.mapreduce.SweepReducer;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

@InterfaceAudience.Private
public class MemStoreWrapper {
    private static final Log LOG = LogFactory.getLog(MemStoreWrapper.class);
    private MemStore memstore;
    private long flushSize;
    private SweepReducer.SweepPartitionId partitionId;
    private Reducer.Context context;
    private Configuration conf;
    private HTable table;
    private HColumnDescriptor hcd;
    private Path mobFamilyDir;
    private FileSystem fs;
    private CacheConfig cacheConfig;

    public MemStoreWrapper(Reducer.Context context, FileSystem fs, HTable table, HColumnDescriptor hcd, MemStore memstore, CacheConfig cacheConfig) throws IOException {
        this.memstore = memstore;
        this.context = context;
        this.fs = fs;
        this.table = table;
        this.hcd = hcd;
        this.conf = context.getConfiguration();
        this.cacheConfig = cacheConfig;
        this.flushSize = this.conf.getLong("hbase.mob.sweep.tool.compaction.memstore.flush.size", 0x8000000L);
        this.mobFamilyDir = MobUtils.getMobFamilyPath(this.conf, table.getName(), hcd.getNameAsString());
    }

    public void setPartitionId(SweepReducer.SweepPartitionId partitionId) {
        this.partitionId = partitionId;
    }

    private void flushMemStoreIfNecessary() throws IOException {
        if (this.memstore.heapSize() >= this.flushSize) {
            this.flushMemStore();
        }
    }

    public void flushMemStore() throws IOException {
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.internalFlushCache(snapshot);
        this.memstore.clearSnapshot(snapshot.getId());
    }

    private void internalFlushCache(MemStoreSnapshot snapshot) throws IOException {
        if (snapshot.getCellsCount() == 0) {
            return;
        }
        String tempPathString = this.context.getConfiguration().get("mob.sweep.job.files.dir");
        StoreFile.Writer mobFileWriter = MobUtils.createWriter(this.conf, this.fs, this.hcd, this.partitionId.getDate(), new Path(tempPathString), (long)snapshot.getCellsCount(), this.hcd.getCompactionCompression(), this.partitionId.getStartKey(), this.cacheConfig);
        String relativePath = mobFileWriter.getPath().getName();
        LOG.info((Object)("Create files under a temp directory " + mobFileWriter.getPath().toString()));
        byte[] referenceValue = Bytes.toBytes((String)relativePath);
        KeyValueScanner scanner = snapshot.getScanner();
        Cell cell = null;
        while (null != (cell = scanner.next())) {
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
            mobFileWriter.append((Cell)kv);
        }
        scanner.close();
        mobFileWriter.appendMetadata(Long.MAX_VALUE, false, snapshot.getCellsCount());
        mobFileWriter.close();
        MobUtils.commitFile(this.conf, this.fs, mobFileWriter.getPath(), this.mobFamilyDir, this.cacheConfig);
        this.context.getCounter((Enum)SweepJob.SweepCounter.FILE_AFTER_MERGE_OR_CLEAN).increment(1L);
        scanner = snapshot.getScanner();
        scanner.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])HConstants.EMPTY_START_ROW));
        cell = null;
        Tag tableNameTag = new Tag(6, this.table.getTableName());
        while (null != (cell = scanner.next())) {
            KeyValue reference = MobUtils.createMobRefKeyValue(cell, referenceValue, tableNameTag);
            Put put = new Put(reference.getRowArray(), reference.getRowOffset(), (int)reference.getRowLength());
            put.add((Cell)reference);
            this.table.put(put);
            this.context.getCounter((Enum)SweepJob.SweepCounter.RECORDS_UPDATED).increment(1L);
        }
        this.table.flushCommits();
        scanner.close();
    }

    public void addToMemstore(KeyValue kv) throws IOException {
        this.memstore.add((Cell)kv);
        this.flushMemStoreIfNecessary();
    }
}

