/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureFairRunQueues;
import org.apache.hadoop.hbase.procedure2.ProcedureRunnableSet;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterProcedureQueue
implements ProcedureRunnableSet {
    private static final Log LOG = LogFactory.getLog(MasterProcedureQueue.class);
    private final ProcedureFairRunQueues<TableName, RunQueue> fairq;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitCond = this.lock.newCondition();
    private final TableLockManager lockManager;
    private final int metaTablePriority;
    private final int userTablePriority;
    private final int sysTablePriority;
    private int queueSize;

    public MasterProcedureQueue(Configuration conf, TableLockManager lockManager) {
        this.fairq = new ProcedureFairRunQueues(1);
        this.lockManager = lockManager;
        this.metaTablePriority = conf.getInt("hbase.master.procedure.queue.meta.table.priority", 3);
        this.sysTablePriority = conf.getInt("hbase.master.procedure.queue.system.table.priority", 2);
        this.userTablePriority = conf.getInt("hbase.master.procedure.queue.user.table.priority", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFront(Procedure proc) {
        this.lock.lock();
        try {
            this.getRunQueueOrCreate(proc).addFront(proc);
            ++this.queueSize;
            this.waitCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBack(Procedure proc) {
        this.lock.lock();
        try {
            this.getRunQueueOrCreate(proc).addBack(proc);
            ++this.queueSize;
            this.waitCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void yield(Procedure proc) {
        this.addFront(proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    public Long poll() {
        this.lock.lock();
        try {
            RunQueue queue;
            if (this.queueSize == 0) {
                this.waitCond.await();
                if (this.queueSize == 0) {
                    Long l = null;
                    return l;
                }
            }
            if ((queue = (RunQueue)this.fairq.poll()) != null && queue.isAvailable()) {
                --this.queueSize;
                Long l = queue.poll();
                return l;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Long l = null;
            return l;
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll() {
        this.lock.lock();
        try {
            this.waitCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.fairq.clear();
            this.queueSize = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.queueSize;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = "MasterProcedureQueue size=" + this.queueSize + ": " + this.fairq;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void completionCleanup(Procedure proc) {
        if (proc instanceof TableProcedureInterface) {
            boolean tableDeleted;
            TableProcedureInterface iProcTable = (TableProcedureInterface)proc;
            if (proc.hasException()) {
                IOException procEx = proc.getException().unwrapRemoteException();
                tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.CREATE ? !(procEx instanceof TableExistsException) : procEx instanceof TableNotFoundException;
            } else {
                boolean bl = tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.DELETE;
            }
            if (tableDeleted) {
                this.markTableAsDeleted(iProcTable.getTableName());
            }
        }
    }

    private RunQueue getRunQueueOrCreate(Procedure proc) {
        if (proc instanceof TableProcedureInterface) {
            TableName table = ((TableProcedureInterface)proc).getTableName();
            return this.getRunQueueOrCreate(table);
        }
        throw new UnsupportedOperationException("RQs for non-table procedures are not implemented yet");
    }

    private TableRunQueue getRunQueueOrCreate(TableName table) {
        TableRunQueue queue = this.getRunQueue(table);
        if (queue != null) {
            return queue;
        }
        return (TableRunQueue)this.fairq.add((Object)table, (ProcedureFairRunQueues.FairObject)this.createTableRunQueue(table));
    }

    private TableRunQueue createTableRunQueue(TableName table) {
        int priority = this.userTablePriority;
        if (table.equals((Object)TableName.META_TABLE_NAME)) {
            priority = this.metaTablePriority;
        } else if (table.isSystemTable()) {
            priority = this.sysTablePriority;
        }
        return new TableRunQueue(priority);
    }

    private TableRunQueue getRunQueue(TableName table) {
        return (TableRunQueue)this.fairq.get((Object)table);
    }

    public boolean tryAcquireTableRead(TableName table, String purpose) {
        return this.getRunQueueOrCreate(table).tryRead(this.lockManager, table, purpose);
    }

    public void releaseTableRead(TableName table) {
        this.getRunQueue(table).releaseRead(this.lockManager, table);
    }

    public boolean tryAcquireTableWrite(TableName table, String purpose) {
        return this.getRunQueueOrCreate(table).tryWrite(this.lockManager, table, purpose);
    }

    public void releaseTableWrite(TableName table) {
        this.getRunQueue(table).releaseWrite(this.lockManager, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean markTableAsDeleted(TableName table) {
        block7: {
            TableRunQueue queue = this.getRunQueue(table);
            if (queue != null) {
                this.lock.lock();
                try {
                    if (queue.isEmpty() && !queue.isLocked()) {
                        this.fairq.remove((Object)table);
                        try {
                            this.lockManager.tableDeleted(table);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)"Received exception from TableLockManager.tableDeleted:", (Throwable)e);
                        }
                        break block7;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return true;
    }

    private static class TableRunQueue
    implements RunQueue {
        private final Deque<Long> runnables = new ArrayDeque<Long>();
        private final int priority;
        private TableLockManager.TableLock tableLock = null;
        private boolean wlock = false;
        private int rlock = 0;

        public TableRunQueue(int priority) {
            this.priority = priority;
        }

        @Override
        public void addFront(Procedure proc) {
            this.runnables.addFirst(proc.getProcId());
        }

        @Override
        public void addBack(Procedure proc) {
            this.runnables.addLast(proc.getProcId());
        }

        @Override
        public Long poll() {
            return this.runnables.poll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAvailable() {
            TableRunQueue tableRunQueue = this;
            synchronized (tableRunQueue) {
                return !this.wlock && !this.runnables.isEmpty();
            }
        }

        public boolean isEmpty() {
            return this.runnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isLocked() {
            TableRunQueue tableRunQueue = this;
            synchronized (tableRunQueue) {
                return this.wlock || this.rlock > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryRead(TableLockManager lockManager, TableName tableName, String purpose) {
            TableRunQueue tableRunQueue = this;
            synchronized (tableRunQueue) {
                if (this.wlock) {
                    return false;
                }
                this.tableLock = lockManager.readLock(tableName, purpose);
                try {
                    this.tableLock.acquire();
                }
                catch (IOException e) {
                    LOG.error((Object)("failed acquire read lock on " + tableName), (Throwable)e);
                    this.tableLock = null;
                    return false;
                }
                ++this.rlock;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseRead(TableLockManager lockManager, TableName tableName) {
            TableRunQueue tableRunQueue = this;
            synchronized (tableRunQueue) {
                this.releaseTableLock(lockManager, this.rlock == 1);
                --this.rlock;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryWrite(TableLockManager lockManager, TableName tableName, String purpose) {
            TableRunQueue tableRunQueue = this;
            synchronized (tableRunQueue) {
                if (this.wlock || this.rlock > 0) {
                    return false;
                }
                this.tableLock = lockManager.writeLock(tableName, purpose);
                try {
                    this.tableLock.acquire();
                }
                catch (IOException e) {
                    LOG.error((Object)("failed acquire write lock on " + tableName), (Throwable)e);
                    this.tableLock = null;
                    return false;
                }
                this.wlock = true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseWrite(TableLockManager lockManager, TableName tableName) {
            TableRunQueue tableRunQueue = this;
            synchronized (tableRunQueue) {
                this.releaseTableLock(lockManager, true);
                this.wlock = false;
            }
        }

        private void releaseTableLock(TableLockManager lockManager, boolean reset) {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.tableLock.release();
                    if (!reset) break;
                    this.tableLock = null;
                    break;
                }
                catch (IOException e) {
                    LOG.warn((Object)"Could not release the table write-lock", (Throwable)e);
                    continue;
                }
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public String toString() {
            return this.runnables.toString();
        }
    }

    private static interface RunQueue
    extends ProcedureFairRunQueues.FairObject {
        public void addFront(Procedure var1);

        public void addBack(Procedure var1);

        public Long poll();

        public boolean isLocked();
    }
}

