/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.coordination.SplitTransactionCoordination;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZKSplitTransactionCoordination
implements SplitTransactionCoordination {
    private CoordinatedStateManager coordinationManager;
    private final ZooKeeperWatcher watcher;
    private static final Log LOG = LogFactory.getLog(ZKSplitTransactionCoordination.class);

    public ZKSplitTransactionCoordination(CoordinatedStateManager coordinationProvider, ZooKeeperWatcher watcher) {
        this.coordinationManager = coordinationProvider;
        this.watcher = watcher;
    }

    @Override
    public void startSplitTransaction(HRegion parent, ServerName serverName, HRegionInfo hri_a, HRegionInfo hri_b) throws IOException {
        HRegionInfo region = parent.getRegionInfo();
        try {
            LOG.debug((Object)this.watcher.prefix("Creating ephemeral node for " + region.getEncodedName() + " in PENDING_SPLIT state"));
            byte[] payload = HRegionInfo.toDelimitedByteArray((HRegionInfo[])new HRegionInfo[]{hri_a, hri_b});
            RegionTransition rt = RegionTransition.createRegionTransition((EventType)EventType.RS_ZK_REQUEST_REGION_SPLIT, (byte[])region.getRegionName(), (ServerName)serverName, (byte[])payload);
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)region.getEncodedName());
            if (!ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)this.watcher, (String)node, (byte[])rt.toByteArray())) {
                throw new IOException("Failed create of ephemeral " + node);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed creating PENDING_SPLIT znode on " + parent.getRegionInfo().getRegionNameAsString(), e);
        }
    }

    private int transitionSplittingNode(HRegionInfo parent, HRegionInfo a, HRegionInfo b, ServerName serverName, SplitTransactionCoordination.SplitTransactionDetails std, EventType beginState, EventType endState) throws IOException {
        ZkSplitTransactionDetails zstd = (ZkSplitTransactionDetails)std;
        byte[] payload = HRegionInfo.toDelimitedByteArray((HRegionInfo[])new HRegionInfo[]{a, b});
        try {
            return ZKAssign.transitionNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)parent, (ServerName)serverName, (EventType)beginState, (EventType)endState, (int)zstd.getZnodeVersion(), (byte[])payload);
        }
        catch (KeeperException e) {
            throw new IOException("Failed transition of splitting node " + parent.getRegionNameAsString(), e);
        }
    }

    @Override
    public void waitForSplitTransaction(RegionServerServices services, Region parent, HRegionInfo hri_a, HRegionInfo hri_b, SplitTransactionCoordination.SplitTransactionDetails sptd) throws IOException {
        ZkSplitTransactionDetails zstd = (ZkSplitTransactionDetails)sptd;
        try {
            int spins = 0;
            Stat stat = new Stat();
            ServerName expectedServer = this.coordinationManager.getServer().getServerName();
            String node = parent.getRegionInfo().getEncodedName();
            while (!this.coordinationManager.getServer().isStopped() && !services.isStopping()) {
                if (spins % 5 == 0) {
                    LOG.debug((Object)("Still waiting for master to process the pending_split for " + node));
                    SplitTransactionCoordination.SplitTransactionDetails temp = this.getDefaultDetails();
                    this.transitionSplittingNode(parent.getRegionInfo(), hri_a, hri_b, expectedServer, temp, EventType.RS_ZK_REQUEST_REGION_SPLIT, EventType.RS_ZK_REQUEST_REGION_SPLIT);
                }
                Thread.sleep(100L);
                ++spins;
                byte[] data = ZKAssign.getDataNoWatch((ZooKeeperWatcher)this.watcher, (String)node, (Stat)stat);
                if (data == null) {
                    throw new IOException("Data is null, splitting node " + node + " no longer exists");
                }
                RegionTransition rt = RegionTransition.parseFrom((byte[])data);
                EventType et = rt.getEventType();
                if (et == EventType.RS_ZK_REGION_SPLITTING) {
                    ServerName serverName = rt.getServerName();
                    if (!serverName.equals((Object)expectedServer)) {
                        throw new IOException("Splitting node " + node + " is for " + serverName + ", not us " + expectedServer);
                    }
                    byte[] payloadOfSplitting = rt.getPayload();
                    List splittingRegions = HRegionInfo.parseDelimitedFrom((byte[])payloadOfSplitting, (int)0, (int)payloadOfSplitting.length);
                    assert (splittingRegions.size() == 2);
                    HRegionInfo a = (HRegionInfo)splittingRegions.get(0);
                    HRegionInfo b = (HRegionInfo)splittingRegions.get(1);
                    if (!hri_a.equals((Object)a) || !hri_b.equals((Object)b)) {
                        throw new IOException("Splitting node " + node + " is for " + a + ", " + b + ", not expected daughters: " + hri_a + ", " + hri_b);
                    }
                    zstd.setZnodeVersion(stat.getVersion());
                    return;
                }
                if (et == EventType.RS_ZK_REQUEST_REGION_SPLIT) continue;
                throw new IOException("Splitting node " + node + " moved out of splitting to " + et);
            }
            throw new IOException("Server is " + (services.isStopping() ? "stopping" : "stopped"));
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed getting SPLITTING znode on " + parent.getRegionInfo().getRegionNameAsString(), e);
        }
    }

    @Override
    public void completeSplitTransaction(RegionServerServices services, Region a, Region b, SplitTransactionCoordination.SplitTransactionDetails std, Region parent) throws IOException {
        ZkSplitTransactionDetails zstd = (ZkSplitTransactionDetails)std;
        if (this.coordinationManager.getServer() != null) {
            try {
                zstd.setZnodeVersion(this.transitionSplittingNode(parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), this.coordinationManager.getServer().getServerName(), zstd, EventType.RS_ZK_REGION_SPLITTING, EventType.RS_ZK_REGION_SPLIT));
                int spins = 0;
                do {
                    if (spins % 10 == 0) {
                        LOG.debug((Object)("Still waiting on the master to process the split for " + parent.getRegionInfo().getEncodedName()));
                    }
                    Thread.sleep(100L);
                    zstd.setZnodeVersion(this.transitionSplittingNode(parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), this.coordinationManager.getServer().getServerName(), zstd, EventType.RS_ZK_REGION_SPLIT, EventType.RS_ZK_REGION_SPLIT));
                    ++spins;
                } while (zstd.getZnodeVersion() != -1 && !this.coordinationManager.getServer().isStopped() && !services.isStopping());
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException("Failed telling master about split", e);
            }
        }
    }

    @Override
    public void clean(HRegionInfo hri) {
        try {
            if (!ZKAssign.deleteNode((ZooKeeperWatcher)this.coordinationManager.getServer().getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REQUEST_REGION_SPLIT, (ServerName)this.coordinationManager.getServer().getServerName())) {
                ZKAssign.deleteNode((ZooKeeperWatcher)this.coordinationManager.getServer().getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REGION_SPLITTING, (ServerName)this.coordinationManager.getServer().getServerName());
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info((Object)("Failed cleanup zk node of " + hri.getRegionNameAsString()), (Throwable)e);
        }
        catch (KeeperException e) {
            this.coordinationManager.getServer().abort("Failed cleanup of " + hri.getRegionNameAsString(), e);
        }
    }

    @Override
    public SplitTransactionCoordination.SplitTransactionDetails getDefaultDetails() {
        ZkSplitTransactionDetails zstd = new ZkSplitTransactionDetails();
        zstd.setZnodeVersion(-1);
        return zstd;
    }

    @Override
    public int processTransition(HRegionInfo p, HRegionInfo hri_a, HRegionInfo hri_b, ServerName sn, SplitTransactionCoordination.SplitTransactionDetails std) throws IOException {
        return this.transitionSplittingNode(p, hri_a, hri_b, sn, std, EventType.RS_ZK_REQUEST_REGION_SPLIT, EventType.RS_ZK_REGION_SPLITTING);
    }

    public static class ZkSplitTransactionDetails
    implements SplitTransactionCoordination.SplitTransactionDetails {
        private int znodeVersion;

        public int getZnodeVersion() {
            return this.znodeVersion;
        }

        public void setZnodeVersion(int znodeVersion) {
            this.znodeVersion = znodeVersion;
        }
    }
}

