/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.log;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.log.LogLevel;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.net.NetUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.Log4jLoggerAdapter;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLogLevel {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogLevel.class);
    static final PrintStream out = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicLogLevel() throws Exception {
        String logName = TestLogLevel.class.getName();
        Logger testlog = LoggerFactory.getLogger((String)logName);
        if (testlog instanceof Log4jLoggerAdapter) {
            org.apache.log4j.Logger log = LogManager.getLogger((String)logName);
            log.debug((Object)"log.debug1");
            log.info((Object)"log.info1");
            log.error((Object)"log.error1");
            Assert.assertTrue((!Level.ERROR.equals((Object)log.getEffectiveLevel()) ? 1 : 0) != 0);
            HttpServer server = null;
            try {
                server = new HttpServer.Builder().setName("..").addEndpoint(new URI("http://localhost:0")).setFindPort(true).build();
                server.start();
                String authority = NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0));
                URL url = new URL("http://" + authority + "/logLevel?log=" + logName + "&level=" + Level.ERROR);
                out.println("*** Connecting to " + url);
                try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        out.println(line);
                    }
                }
                log.debug((Object)"log.debug2");
                log.info((Object)"log.info2");
                log.error((Object)"log.error2");
                Assert.assertTrue((boolean)Level.ERROR.equals((Object)log.getEffectiveLevel()));
                String[] args = new String[]{"-setlevel", authority, logName, Level.DEBUG.toString()};
                LogLevel.main((String[])args);
                log.debug((Object)"log.debug3");
                log.info((Object)"log.info3");
                log.error((Object)"log.error3");
                Assert.assertTrue((boolean)Level.DEBUG.equals((Object)log.getEffectiveLevel()));
            }
            finally {
                if (server != null) {
                    server.stop();
                }
            }
        }
        out.println(testlog.getClass() + " not tested.");
    }
}

