/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.Timer;

public class ExampleRegionObserverWithMetrics
extends BaseRegionObserver {
    private Counter preGetCounter;
    private Timer costlyOperationTimer;

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        super.preGetOp(e, get, results);
        this.preGetCounter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        super.postGetOp(e, get, results);
        long start = System.nanoTime();
        try {
            this.performCostlyOperation();
        }
        finally {
            this.costlyOperationTimer.updateNanos(System.nanoTime() - start);
        }
    }

    private void performCostlyOperation() {
        try {
            Thread.sleep(ThreadLocalRandom.current().nextLong(100L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        super.start(env);
        if (env instanceof RegionCoprocessorEnvironment) {
            MetricRegistry registry = ((RegionCoprocessorEnvironment)env).getMetricRegistryForRegionServer();
            if (this.preGetCounter == null) {
                this.preGetCounter = registry.counter("preGetRequests");
            }
            if (this.costlyOperationTimer == null) {
                this.costlyOperationTimer = registry.timer("costlyOperation");
            }
        }
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        super.stop(e);
    }
}

