/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xerial;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

@InterfaceAudience.Private
public class SnappyDecompressor
implements Decompressor {
    protected static final Logger LOG = LoggerFactory.getLogger(SnappyDecompressor.class);
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int inLen;
    protected boolean finished;

    SnappyDecompressor(int bufferSize) {
        this.inBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf.position(bufferSize);
    }

    public int decompress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            LOG.trace("decompress: {} bytes from outBuf", (Object)n);
            return n;
        }
        if (this.inBuf.position() > 0) {
            this.inBuf.flip();
            int remaining = this.inBuf.remaining();
            this.inLen -= remaining;
            this.outBuf.clear();
            int written = Snappy.uncompress((ByteBuffer)this.inBuf, (ByteBuffer)this.outBuf);
            this.inBuf.clear();
            LOG.trace("decompress: decompressed {} -> {}", (Object)remaining, (Object)written);
            int n = Math.min(written, len);
            this.outBuf.get(b, off, n);
            LOG.trace("decompress: {} bytes", (Object)n);
            return n;
        }
        LOG.trace("decompress: No output, finished");
        this.finished = true;
        return 0;
    }

    public void end() {
        LOG.trace("end");
    }

    public boolean finished() {
        LOG.trace("finished");
        return this.finished;
    }

    public int getRemaining() {
        LOG.trace("getRemaining: {}", (Object)this.inLen);
        return this.inLen;
    }

    public boolean needsDictionary() {
        LOG.trace("needsDictionary");
        return false;
    }

    public void reset() {
        LOG.trace("reset");
        this.inBuf.clear();
        this.inLen = 0;
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.finished = false;
    }

    public boolean needsInput() {
        boolean b = this.inBuf.position() == 0;
        LOG.trace("needsInput: {}", (Object)b);
        return b;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        LOG.trace("setInput: off={} len={}", (Object)off, (Object)len);
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            LOG.trace("setInput: resize inBuf {}", (Object)needed);
            ByteBuffer newBuf = ByteBuffer.allocateDirect(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.inLen += len;
        this.finished = false;
    }
}

