/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xerial;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.xerial.SnappyCodec;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.wal.CompressedWALTestBase;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALCompressionSnappy
extends CompressedWALTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALCompressionSnappy.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Assume.assumeTrue((boolean)SnappyCodec.isLoaded());
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.io.compress.snappy.codec", SnappyCodec.class.getCanonicalName());
        Compression.Algorithm.SNAPPY.reload(conf);
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        conf.setBoolean("hbase.regionserver.wal.value.enablecompression", true);
        conf.set("hbase.regionserver.wal.value.compression.type", Compression.Algorithm.SNAPPY.getName());
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

