/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class ClientIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ClientIdGenerator.class);

    private ClientIdGenerator() {
    }

    public static byte[] generateClientId() {
        byte[] selfBytes = ClientIdGenerator.getIpAddressBytes();
        Long pid = ClientIdGenerator.getPid();
        long tid = Thread.currentThread().getId();
        long ts = EnvironmentEdgeManager.currentTime();
        byte[] id = new byte[selfBytes.length + ((pid != null ? 1 : 0) + 2) * 8];
        int offset = Bytes.putBytes((byte[])id, (int)0, (byte[])selfBytes, (int)0, (int)selfBytes.length);
        if (pid != null) {
            offset = Bytes.putLong((byte[])id, (int)offset, (long)pid);
        }
        offset = Bytes.putLong((byte[])id, (int)offset, (long)tid);
        offset = Bytes.putLong((byte[])id, (int)offset, (long)ts);
        assert (offset == id.length);
        return id;
    }

    public static Long getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        List nameParts = Splitter.on((char)'@').splitToList((CharSequence)name);
        if (nameParts.size() == 2) {
            try {
                return Long.parseLong((String)Iterators.get(nameParts.iterator(), (int)0));
            }
            catch (NumberFormatException ex) {
                LOG.warn("Failed to get PID from [" + name + "]", (Throwable)ex);
            }
        } else {
            LOG.warn("Don't know how to get PID from [" + name + "]");
        }
        return null;
    }

    public static byte[] getIpAddressBytes() {
        try {
            return Addressing.getIpAddress().getAddress();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get IP address bytes", (Throwable)ex);
            return new byte[0];
        }
    }
}

