/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.client.AsyncRegionLocatorHelper;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncMetaRegionLocator {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncMetaRegionLocator.class);
    private final AsyncRegistry registry;
    private final AtomicReference<RegionLocations> metaRegionLocations = new AtomicReference();
    private final AtomicReference<CompletableFuture<RegionLocations>> metaRelocateFuture = new AtomicReference();

    AsyncMetaRegionLocator(AsyncRegistry registry) {
        this.registry = registry;
    }

    CompletableFuture<RegionLocations> getRegionLocations(int replicaId, boolean reload) {
        CompletableFuture<RegionLocations> future;
        while (true) {
            RegionLocations locs2;
            if (!reload && AsyncRegionLocatorHelper.isGood(locs2 = this.metaRegionLocations.get(), replicaId)) {
                return CompletableFuture.completedFuture(locs2);
            }
            LOG.trace("Meta region location cache is null, try fetching from registry.");
            if (this.metaRelocateFuture.compareAndSet(null, new CompletableFuture())) {
                LOG.debug("Start fetching meta region location from registry.");
                future = this.metaRelocateFuture.get();
                FutureUtils.addListener(this.registry.getMetaRegionLocation(), (locs, error) -> {
                    if (error != null) {
                        LOG.debug("Failed to fetch meta region location from registry", error);
                        ((CompletableFuture)this.metaRelocateFuture.getAndSet(null)).completeExceptionally((Throwable)error);
                        return;
                    }
                    LOG.debug("The fetched meta region location is {}" + locs);
                    this.metaRegionLocations.set((RegionLocations)locs);
                    this.metaRelocateFuture.set(null);
                    future.complete((RegionLocations)locs);
                });
                continue;
            }
            future = this.metaRelocateFuture.get();
            if (future != null) break;
        }
        return future;
    }

    private HRegionLocation getCacheLocation(HRegionLocation loc) {
        RegionLocations locs = this.metaRegionLocations.get();
        return locs != null ? locs.getRegionLocation(loc.getRegion().getReplicaId()) : null;
    }

    private void addLocationToCache(HRegionLocation loc) {
        RegionLocations newLocs;
        RegionLocations oldLocs;
        do {
            RegionLocations newLocs2;
            int replicaId = loc.getRegion().getReplicaId();
            oldLocs = this.metaRegionLocations.get();
            if (oldLocs == null && this.metaRegionLocations.compareAndSet(null, newLocs2 = AsyncRegionLocatorHelper.createRegionLocations(loc))) {
                return;
            }
            HRegionLocation oldLoc = oldLocs.getRegionLocation(replicaId);
            if (oldLoc == null || oldLoc.getSeqNum() <= loc.getSeqNum() && !oldLoc.getServerName().equals((Object)loc.getServerName())) continue;
            return;
        } while (!this.metaRegionLocations.compareAndSet(oldLocs, newLocs = AsyncRegionLocatorHelper.replaceRegionLocation(oldLocs, loc)));
    }

    private void removeLocationFromCache(HRegionLocation loc) {
        RegionLocations newLocs;
        RegionLocations oldLocs;
        do {
            if ((oldLocs = this.metaRegionLocations.get()) == null) {
                return;
            }
            HRegionLocation oldLoc = oldLocs.getRegionLocation(loc.getRegion().getReplicaId());
            if (AsyncRegionLocatorHelper.canUpdateOnError(loc, oldLoc)) continue;
            return;
        } while (!this.metaRegionLocations.compareAndSet(oldLocs, newLocs = AsyncRegionLocatorHelper.removeRegionLocation(oldLocs, loc.getRegion().getReplicaId())));
    }

    void updateCachedLocationOnError(HRegionLocation loc, Throwable exception) {
        AsyncRegionLocatorHelper.updateCachedLocationOnError(loc, exception, this::getCacheLocation, this::addLocationToCache, this::removeLocationFromCache);
    }

    void clearCache() {
        this.metaRegionLocations.set(null);
    }
}

