/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FuzzyRowFilter
extends FilterBase {
    private List<Pair<byte[], byte[]>> fuzzyKeysData;
    private boolean done = false;

    public FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData) {
        for (int i = 0; i < fuzzyKeysData.size(); ++i) {
            Pair<byte[], byte[]> p = fuzzyKeysData.get(i);
            if (((byte[])p.getFirst()).length == ((byte[])p.getSecond()).length) continue;
            Pair readable = new Pair((Object)Bytes.toStringBinary((byte[])((byte[])p.getFirst())), (Object)Bytes.toStringBinary((byte[])((byte[])p.getSecond())));
            throw new IllegalArgumentException("Fuzzy pair lengths do not match: " + readable);
        }
        this.fuzzyKeysData = fuzzyKeysData;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell cell) {
        SatisfiesCode bestOption = SatisfiesCode.NO_NEXT;
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            SatisfiesCode satisfiesCode = FuzzyRowFilter.satisfies(this.isReversed(), cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), (byte[])fuzzyData.getFirst(), (byte[])fuzzyData.getSecond());
            if (satisfiesCode == SatisfiesCode.YES) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (satisfiesCode != SatisfiesCode.NEXT_EXISTS) continue;
            bestOption = SatisfiesCode.NEXT_EXISTS;
        }
        if (bestOption == SatisfiesCode.NEXT_EXISTS) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        this.done = true;
        return Filter.ReturnCode.NEXT_ROW;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public Cell getNextCellHint(Cell curCell) {
        byte[] nextRowKey = null;
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            byte[] nextRowKeyCandidate = FuzzyRowFilter.getNextForFuzzyRule(this.isReversed(), curCell.getRowArray(), curCell.getRowOffset(), curCell.getRowLength(), (byte[])fuzzyData.getFirst(), (byte[])fuzzyData.getSecond());
            if (nextRowKeyCandidate == null || nextRowKey != null && (!this.reversed || Bytes.compareTo((byte[])nextRowKeyCandidate, (byte[])nextRowKey) <= 0) && (this.reversed || Bytes.compareTo((byte[])nextRowKeyCandidate, (byte[])nextRowKey) >= 0)) continue;
            nextRowKey = nextRowKeyCandidate;
        }
        if (!this.reversed && nextRowKey == null) {
            throw new IllegalStateException("No next row key that satisfies fuzzy exists when getNextKeyHint() is invoked. Filter: " + this.toString() + " currentKV: " + curCell);
        }
        return nextRowKey == null ? null : KeyValueUtil.createFirstOnRow(nextRowKey);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FuzzyRowFilter.Builder builder = FilterProtos.FuzzyRowFilter.newBuilder();
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            bbpBuilder.setFirst(ByteStringer.wrap((byte[])((byte[])fuzzyData.getFirst())));
            bbpBuilder.setSecond(ByteStringer.wrap((byte[])((byte[])fuzzyData.getSecond())));
            builder.addFuzzyKeysData(bbpBuilder);
        }
        return builder.build().toByteArray();
    }

    public static FuzzyRowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FuzzyRowFilter proto;
        try {
            proto = FilterProtos.FuzzyRowFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int count = proto.getFuzzyKeysDataCount();
        ArrayList<Pair<byte[], byte[]>> fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
        for (int i = 0; i < count; ++i) {
            HBaseProtos.BytesBytesPair current = proto.getFuzzyKeysData(i);
            byte[] keyBytes = current.getFirst().toByteArray();
            byte[] keyMeta = current.getSecond().toByteArray();
            fuzzyKeysData.add((Pair<byte[], byte[]>)new Pair((Object)keyBytes, (Object)keyMeta));
        }
        return new FuzzyRowFilter(fuzzyKeysData);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FuzzyRowFilter");
        sb.append("{fuzzyKeysData=");
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            sb.append('{').append(Bytes.toStringBinary((byte[])((byte[])fuzzyData.getFirst()))).append(":");
            sb.append(Bytes.toStringBinary((byte[])((byte[])fuzzyData.getSecond()))).append('}');
        }
        sb.append("}, ");
        return sb.toString();
    }

    @VisibleForTesting
    static SatisfiesCode satisfies(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @VisibleForTesting
    static SatisfiesCode satisfies(boolean reverse, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(reverse, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    private static SatisfiesCode satisfies(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        if (row == null) {
            return SatisfiesCode.YES;
        }
        Order order = Order.orderFor(reverse);
        boolean nextRowKeyCandidateExists = false;
        for (int i = 0; i < fuzzyKeyMeta.length && i < length; ++i) {
            boolean fixedByteIncorrect;
            boolean byteAtPositionFixed = fuzzyKeyMeta[i] == 0;
            boolean bl = fixedByteIncorrect = byteAtPositionFixed && fuzzyKeyBytes[i] != row[i + offset];
            if (fixedByteIncorrect) {
                boolean rowByteLessThanFixed;
                if (nextRowKeyCandidateExists) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                boolean bl2 = rowByteLessThanFixed = (row[i + offset] & 0xFF) < (fuzzyKeyBytes[i] & 0xFF);
                if (rowByteLessThanFixed && !reverse) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                if (!rowByteLessThanFixed && reverse) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                return SatisfiesCode.NO_NEXT;
            }
            if (fuzzyKeyMeta[i] != 1 || order.isMax(fuzzyKeyBytes[i])) continue;
            nextRowKeyCandidateExists = true;
        }
        return SatisfiesCode.YES;
    }

    @VisibleForTesting
    static byte[] getNextForFuzzyRule(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @VisibleForTesting
    static byte[] getNextForFuzzyRule(boolean reverse, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(reverse, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    private static byte[] getNextForFuzzyRule(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int i;
        byte[] result = Arrays.copyOf(fuzzyKeyBytes, length > fuzzyKeyBytes.length ? length : fuzzyKeyBytes.length);
        if (reverse && length > fuzzyKeyBytes.length) {
            for (int i2 = fuzzyKeyBytes.length; i2 < result.length; ++i2) {
                result[i2] = -1;
            }
        }
        int toInc = -1;
        Order order = Order.orderFor(reverse);
        boolean increased = false;
        for (i = 0; i < result.length; ++i) {
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] == 1) {
                result[i] = row[offset + i];
                if (order.isMax(row[i])) continue;
                toInc = i;
                continue;
            }
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] != 0) continue;
            if (order.lt(row[i + offset] & 0xFF, fuzzyKeyBytes[i] & 0xFF)) {
                increased = true;
                break;
            }
            if (order.gt(row[i + offset] & 0xFF, fuzzyKeyBytes[i] & 0xFF)) break;
        }
        if (!increased) {
            if (toInc < 0) {
                return null;
            }
            result[toInc] = order.inc(result[toInc]);
            for (i = toInc + 1; i < result.length; ++i) {
                if (i < fuzzyKeyMeta.length && fuzzyKeyMeta[i] != 1) continue;
                result[i] = order.min();
            }
        }
        return result;
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuzzyRowFilter)) {
            return false;
        }
        FuzzyRowFilter other = (FuzzyRowFilter)o;
        if (this.fuzzyKeysData.size() != other.fuzzyKeysData.size()) {
            return false;
        }
        for (int i = 0; i < this.fuzzyKeysData.size(); ++i) {
            Pair<byte[], byte[]> thisData = this.fuzzyKeysData.get(i);
            Pair<byte[], byte[]> otherData = other.fuzzyKeysData.get(i);
            if (Bytes.equals((byte[])((byte[])thisData.getFirst()), (byte[])((byte[])otherData.getFirst())) && Bytes.equals((byte[])((byte[])thisData.getSecond()), (byte[])((byte[])otherData.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private static enum Order {
        ASC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val + 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == -1;
            }

            @Override
            public byte min() {
                return 0;
            }
        }
        ,
        DESC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val - 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == 0;
            }

            @Override
            public byte min() {
                return -1;
            }
        };


        public static Order orderFor(boolean reverse) {
            return reverse ? DESC : ASC;
        }

        public abstract boolean lt(int var1, int var2);

        public abstract boolean gt(int var1, int var2);

        public abstract byte inc(byte var1);

        public abstract boolean isMax(byte var1);

        public abstract byte min();
    }

    static enum SatisfiesCode {
        YES,
        NEXT_EXISTS,
        NO_NEXT;

    }
}

