/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.ByteBufferStrategy;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSStripedInputStream;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Time;

abstract class StripeReader {
    private final Map<Future<StripedBlockUtil.BlockReadStats>, Integer> futures = new HashMap<Future<StripedBlockUtil.BlockReadStats>, Integer>();
    protected final StripedBlockUtil.AlignedStripe alignedStripe;
    private final CompletionService<StripedBlockUtil.BlockReadStats> service;
    protected final LocatedBlock[] targetBlocks;
    protected final DFSUtilClient.CorruptedBlocks corruptedBlocks;
    protected final BlockReaderInfo[] readerInfos;
    protected final ErasureCodingPolicy ecPolicy;
    protected final short dataBlkNum;
    protected final short parityBlkNum;
    protected final int cellSize;
    protected final RawErasureDecoder decoder;
    protected final DFSStripedInputStream dfsStripedInputStream;
    protected ECChunk[] decodeInputs;

    StripeReader(StripedBlockUtil.AlignedStripe alignedStripe, ErasureCodingPolicy ecPolicy, LocatedBlock[] targetBlocks, BlockReaderInfo[] readerInfos, DFSUtilClient.CorruptedBlocks corruptedBlocks, RawErasureDecoder decoder, DFSStripedInputStream dfsStripedInputStream) {
        this.alignedStripe = alignedStripe;
        this.ecPolicy = ecPolicy;
        this.dataBlkNum = (short)ecPolicy.getNumDataUnits();
        this.parityBlkNum = (short)ecPolicy.getNumParityUnits();
        this.cellSize = ecPolicy.getCellSize();
        this.targetBlocks = targetBlocks;
        this.readerInfos = readerInfos;
        this.corruptedBlocks = corruptedBlocks;
        this.decoder = decoder;
        this.dfsStripedInputStream = dfsStripedInputStream;
        this.service = new ExecutorCompletionService<StripedBlockUtil.BlockReadStats>(dfsStripedInputStream.getStripedReadsThreadPool());
    }

    abstract void prepareDecodeInputs();

    abstract boolean prepareParityChunk(int var1);

    abstract void decode() throws IOException;

    void close() {
    }

    void updateState4SuccessRead(StripedBlockUtil.StripingChunkReadResult result) {
        Preconditions.checkArgument((result.state == 1 ? 1 : 0) != 0);
        this.readerInfos[result.index].setOffset(this.alignedStripe.getOffsetInBlock() + this.alignedStripe.getSpanInBlock());
    }

    private void checkMissingBlocks() throws IOException {
        if (this.alignedStripe.missingChunksNum > this.parityBlkNum) {
            this.clearFutures();
            throw new IOException(this.alignedStripe.missingChunksNum + " missing blocks, the stripe is: " + this.alignedStripe + "; locatedBlocks is: " + this.dfsStripedInputStream.getLocatedBlocks());
        }
    }

    private void readDataForDecoding() throws IOException {
        this.prepareDecodeInputs();
        for (int i = 0; i < this.dataBlkNum; ++i) {
            Preconditions.checkNotNull((Object)this.alignedStripe.chunks[i]);
            if (this.alignedStripe.chunks[i].state != 8 || this.readChunk(this.targetBlocks[i], i)) continue;
            ++this.alignedStripe.missingChunksNum;
        }
        this.checkMissingBlocks();
    }

    void readParityChunks(int num) throws IOException {
        int j = 0;
        for (int i = this.dataBlkNum; i < this.dataBlkNum + this.parityBlkNum && j < num; ++i) {
            if (this.alignedStripe.chunks[i] != null) continue;
            if (this.prepareParityChunk(i) && this.readChunk(this.targetBlocks[i], i)) {
                ++j;
                continue;
            }
            ++this.alignedStripe.missingChunksNum;
        }
        this.checkMissingBlocks();
    }

    private ByteBufferStrategy[] getReadStrategies(StripedBlockUtil.StripingChunk chunk) {
        if (chunk.useByteBuffer()) {
            ByteBufferStrategy strategy = new ByteBufferStrategy(chunk.getByteBuffer(), this.dfsStripedInputStream.getReadStatistics(), this.dfsStripedInputStream.getDFSClient());
            return new ByteBufferStrategy[]{strategy};
        }
        ByteBufferStrategy[] strategies = new ByteBufferStrategy[chunk.getChunkBuffer().getSlices().size()];
        for (int i = 0; i < strategies.length; ++i) {
            ByteBuffer buffer = chunk.getChunkBuffer().getSlice(i);
            strategies[i] = new ByteBufferStrategy(buffer, this.dfsStripedInputStream.getReadStatistics(), this.dfsStripedInputStream.getDFSClient());
        }
        return strategies;
    }

    private int readToBuffer(BlockReader blockReader, DatanodeInfo currentNode, ByteBufferStrategy strategy, ExtendedBlock currentBlock) throws IOException {
        int targetLength = strategy.getTargetLength();
        try {
            int length;
            int ret;
            for (length = 0; length < targetLength; length += ret) {
                ret = strategy.readFromBlock(blockReader);
                if (ret >= 0) continue;
                throw new IOException("Unexpected EOS from the reader");
            }
            return length;
        }
        catch (ChecksumException ce) {
            DFSClient.LOG.warn("Found Checksum error for " + currentBlock + " from " + currentNode + " at " + ce.getPos());
            strategy.getReadBuffer().clear();
            this.corruptedBlocks.addCorruptedBlock(currentBlock, currentNode);
            throw ce;
        }
        catch (IOException e) {
            DFSClient.LOG.warn("Exception while reading from " + currentBlock + " of " + this.dfsStripedInputStream.getSrc() + " from " + currentNode, (Throwable)e);
            strategy.getReadBuffer().clear();
            throw e;
        }
    }

    private Callable<StripedBlockUtil.BlockReadStats> readCells(BlockReader reader, DatanodeInfo datanode, long currentReaderOffset, long targetReaderOffset, ByteBufferStrategy[] strategies, ExtendedBlock currentBlock) {
        return () -> {
            if (reader == null) {
                throw new IOException("The BlockReader is null. The BlockReader creation failed or the reader hit exception.");
            }
            Preconditions.checkState((currentReaderOffset <= targetReaderOffset ? 1 : 0) != 0);
            if (currentReaderOffset < targetReaderOffset) {
                long skipped = reader.skip(targetReaderOffset - currentReaderOffset);
                Preconditions.checkState((skipped == targetReaderOffset - currentReaderOffset ? 1 : 0) != 0);
            }
            int ret = 0;
            for (ByteBufferStrategy strategy : strategies) {
                int bytesReead = this.readToBuffer(reader, datanode, strategy, currentBlock);
                ret += bytesReead;
            }
            return new StripedBlockUtil.BlockReadStats(ret, reader.isShortCircuit(), reader.getNetworkDistance());
        };
    }

    boolean readChunk(LocatedBlock block, int chunkIndex) throws IOException {
        StripedBlockUtil.StripingChunk chunk = this.alignedStripe.chunks[chunkIndex];
        if (block == null) {
            chunk.state = 2;
            return false;
        }
        if (this.readerInfos[chunkIndex] == null) {
            if (!this.dfsStripedInputStream.createBlockReader(block, this.alignedStripe.getOffsetInBlock(), this.targetBlocks, this.readerInfos, chunkIndex)) {
                chunk.state = 2;
                return false;
            }
        } else if (this.readerInfos[chunkIndex].shouldSkip) {
            chunk.state = 2;
            return false;
        }
        chunk.state = 4;
        Callable<StripedBlockUtil.BlockReadStats> readCallable = this.readCells(this.readerInfos[chunkIndex].reader, this.readerInfos[chunkIndex].datanode, this.readerInfos[chunkIndex].blockReaderOffset, this.alignedStripe.getOffsetInBlock(), this.getReadStrategies(chunk), block.getBlock());
        Future<StripedBlockUtil.BlockReadStats> request = this.service.submit(readCallable);
        this.futures.put(request, chunkIndex);
        return true;
    }

    void readStripe() throws IOException {
        for (int i = 0; i < this.dataBlkNum; ++i) {
            if (this.alignedStripe.chunks[i] == null || this.alignedStripe.chunks[i].state == 15 || this.readChunk(this.targetBlocks[i], i)) continue;
            ++this.alignedStripe.missingChunksNum;
        }
        if (this.alignedStripe.missingChunksNum > 0) {
            this.checkMissingBlocks();
            this.readDataForDecoding();
            this.readParityChunks(this.alignedStripe.missingChunksNum);
        }
        while (!this.futures.isEmpty()) {
            try {
                StripedBlockUtil.StripingChunkReadResult r = StripedBlockUtil.getNextCompletedStripedRead(this.service, this.futures, 0L);
                this.dfsStripedInputStream.updateReadStats(r.getReadStats());
                if (DFSClient.LOG.isDebugEnabled()) {
                    DFSClient.LOG.debug("Read task returned: " + r + ", for stripe " + this.alignedStripe);
                }
                StripedBlockUtil.StripingChunk returnedChunk = this.alignedStripe.chunks[r.index];
                Preconditions.checkNotNull((Object)returnedChunk);
                Preconditions.checkState((returnedChunk.state == 4 ? 1 : 0) != 0);
                if (r.state == 1) {
                    returnedChunk.state = 1;
                    ++this.alignedStripe.fetchedChunksNum;
                    this.updateState4SuccessRead(r);
                    if (this.alignedStripe.fetchedChunksNum != this.dataBlkNum) continue;
                    this.clearFutures();
                    break;
                }
                returnedChunk.state = 2;
                this.dfsStripedInputStream.closeReader(this.readerInfos[r.index]);
                int missing = this.alignedStripe.missingChunksNum++;
                this.checkMissingBlocks();
                this.readDataForDecoding();
                this.readParityChunks(this.alignedStripe.missingChunksNum - missing);
            }
            catch (InterruptedException ie) {
                String err = "Read request interrupted";
                DFSClient.LOG.error(err);
                this.clearFutures();
                throw new InterruptedIOException(err);
            }
        }
        if (this.alignedStripe.missingChunksNum > 0) {
            this.decode();
        }
    }

    void finalizeDecodeInputs() {
        for (int i = 0; i < this.alignedStripe.chunks.length; ++i) {
            StripedBlockUtil.StripingChunk chunk = this.alignedStripe.chunks[i];
            if (chunk != null && chunk.state == 1) {
                if (chunk.useChunkBuffer()) {
                    chunk.getChunkBuffer().copyTo(this.decodeInputs[i].getBuffer());
                    continue;
                }
                chunk.getByteBuffer().flip();
                continue;
            }
            if (chunk == null || chunk.state != 15) continue;
            this.decodeInputs[i].setAllZero(true);
        }
    }

    void decodeAndFillBuffer(boolean fillBuffer) throws IOException {
        int[] decodeIndices = this.prepareErasedIndices();
        int decodeChunkNum = decodeIndices.length;
        ECChunk[] outputs = new ECChunk[decodeChunkNum];
        for (int i = 0; i < decodeChunkNum; ++i) {
            outputs[i] = this.decodeInputs[decodeIndices[i]];
            this.decodeInputs[decodeIndices[i]] = null;
        }
        long start = Time.monotonicNow();
        this.decoder.decode(this.decodeInputs, decodeIndices, outputs);
        if (fillBuffer) {
            for (int i = 0; i < decodeIndices.length; ++i) {
                int missingBlkIdx = decodeIndices[i];
                StripedBlockUtil.StripingChunk chunk = this.alignedStripe.chunks[missingBlkIdx];
                if (chunk.state != 2 || !chunk.useChunkBuffer()) continue;
                chunk.getChunkBuffer().copyFrom(outputs[i].getBuffer());
            }
        }
        long end = Time.monotonicNow();
        this.dfsStripedInputStream.readStatistics.addErasureCodingDecodingTime(end - start);
    }

    int[] prepareErasedIndices() {
        int[] decodeIndices = new int[this.parityBlkNum];
        int pos = 0;
        for (int i = 0; i < this.alignedStripe.chunks.length; ++i) {
            if (this.alignedStripe.chunks[i] == null || this.alignedStripe.chunks[i].state != 2) continue;
            decodeIndices[pos++] = i;
        }
        int[] erasedIndices = Arrays.copyOf(decodeIndices, pos);
        return erasedIndices;
    }

    void clearFutures() {
        for (Future<StripedBlockUtil.BlockReadStats> future : this.futures.keySet()) {
            future.cancel(false);
        }
        this.futures.clear();
    }

    boolean useDirectBuffer() {
        return this.decoder.preferDirectBuffer();
    }

    static class BlockReaderInfo {
        final BlockReader reader;
        final DatanodeInfo datanode;
        long blockReaderOffset;
        boolean shouldSkip = false;

        BlockReaderInfo(BlockReader reader, DatanodeInfo dn, long offset) {
            this.reader = reader;
            this.datanode = dn;
            this.blockReaderOffset = offset;
        }

        void setOffset(long offset) {
            this.blockReaderOffset = offset;
        }

        void skip() {
            this.shouldSkip = true;
        }
    }

    static class ReaderRetryPolicy {
        private int fetchEncryptionKeyTimes = 1;
        private int fetchTokenTimes = 1;

        ReaderRetryPolicy() {
        }

        void refetchEncryptionKey() {
            --this.fetchEncryptionKeyTimes;
        }

        void refetchToken() {
            --this.fetchTokenTimes;
        }

        boolean shouldRefetchEncryptionKey() {
            return this.fetchEncryptionKeyTimes > 0;
        }

        boolean shouldRefetchToken() {
            return this.fetchTokenTimes > 0;
        }
    }
}

