/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.GrailsReleaseType;
import grails.init.GrailsUpdater;
import grails.init.GrailsVersion;
import grails.proxy.SystemPropertiesAuthenticator;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class Start {
    public static void main(String[] args) {
        Authenticator.setDefault(new SystemPropertiesAuthenticator());
        try {
            GrailsVersion preferredGrailsVersion = Start.getPreferredGrailsVersion();
            LinkedHashSet<GrailsReleaseType> allowedTypes = Start.getAllowedReleaseTypes(preferredGrailsVersion);
            GrailsUpdater updater = new GrailsUpdater(allowedTypes, preferredGrailsVersion);
            boolean forceUpdate = args.length > 0 && args[0].trim().equals("update-wrapper");
            boolean updated = false;
            String[] adjustedArgs = args;
            if (forceUpdate || updater.needsUpdating()) {
                String allowTypesString = allowedTypes.stream().map(Enum::name).collect(Collectors.joining(","));
                System.out.printf("Updating Grails wrapper, allowed versions to update to are [%s]...%n", allowTypesString);
                updated = updater.update();
                if (forceUpdate) {
                    adjustedArgs = Arrays.copyOfRange(args, 1, args.length);
                }
            }
            if (updated) {
                System.out.println("Updated wrapper to version: " + updater.getSelectedVersion().toString());
            }
            URLClassLoader child = new URLClassLoader(new URL[]{updater.getExecutedJarFile().toURI().toURL()});
            Class<?> classToLoad = Class.forName("org.apache.grails.cli.DelegatingShellApplication", true, child);
            Method main = classToLoad.getMethod("main", String[].class);
            main.invoke(null, new Object[]{adjustedArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static GrailsVersion getPreferredGrailsVersion() {
        File gradleProperties = new File("gradle.properties");
        if (!gradleProperties.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(gradleProperties);){
            properties.load(in);
        }
        catch (Exception e) {
            System.err.println("Failed to load gradle.properties from " + String.valueOf(gradleProperties));
            e.printStackTrace();
            System.exit(1);
        }
        if (!properties.containsKey("grailsVersion")) {
            return null;
        }
        String grailsVersion = properties.getProperty("grailsVersion");
        if (grailsVersion == null) {
            System.out.println("gradle.properties does not contain grailsVersion; downloading latest Grails Version");
            String overrideGrailsVersion = System.getenv("PREFERRED_GRAILS_VERSION");
            if (overrideGrailsVersion != null) {
                try {
                    return new GrailsVersion(overrideGrailsVersion);
                }
                catch (Exception e) {
                    System.out.println("An invalid Grails Version [" + overrideGrailsVersion + "] was specified in PREFERRED_GRAILS_VERSION");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            return null;
        }
        try {
            return new GrailsVersion(grailsVersion);
        }
        catch (Exception e) {
            System.out.println("An invalid Grails Version [" + grailsVersion + "] was specified in gradle.properties");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static LinkedHashSet<GrailsReleaseType> getAllowedReleaseTypes(GrailsVersion preferredVersion) {
        String raw = System.getenv("GRAILS_WRAPPER_ALLOWED_TYPES");
        if (raw == null || raw.trim().isEmpty()) {
            if (preferredVersion != null) {
                return preferredVersion.releaseType.upTo();
            }
            String grailsVersion = Start.class.getPackage().getImplementationVersion();
            if (grailsVersion == null) {
                return new LinkedHashSet<GrailsReleaseType>(List.of(GrailsReleaseType.SNAPSHOT));
            }
            GrailsVersion myVersion = new GrailsVersion(grailsVersion);
            if (myVersion.releaseType != GrailsReleaseType.RELEASE) {
                return new LinkedHashSet<GrailsReleaseType>(List.of(GrailsReleaseType.values()));
            }
            return new LinkedHashSet<GrailsReleaseType>(List.of(GrailsReleaseType.RELEASE));
        }
        return new LinkedHashSet<GrailsReleaseType>(Arrays.stream(raw.split(",")).map(String::trim).map(GrailsReleaseType::valueOf).collect(Collectors.toList()));
    }
}

