/*
 * Decompiled with CFR 0.152.
 */
package org.grails.testing.runtime.support;

import grails.core.gsp.GrailsTagLibClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.plugins.web.GroovyPagesGrailsPlugin;
import org.grails.taglib.TagLibraryLookup;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ClassUtils;

public class LazyTagLibraryLookup
extends TagLibraryLookup {
    List<Class> tagLibClasses;
    private Map<String, GrailsTagLibClass> lazyLoadableTagLibs = new HashMap<String, GrailsTagLibClass>();

    public LazyTagLibraryLookup() {
        ArrayList<Class> mockedClasses = new ArrayList<Class>((List)new GroovyPagesGrailsPlugin().getProvidedArtefacts());
        ClassLoader classLoader = LazyTagLibraryLookup.class.getClassLoader();
        if (ClassUtils.isPresent((String)"org.apache.grails.web.layout.LayoutGrailsPlugin", (ClassLoader)classLoader)) {
            try {
                mockedClasses.add(Class.forName("org.grails.plugins.web.taglib.GrailsLayoutTagLib"));
                mockedClasses.add(Class.forName("org.grails.plugins.web.taglib.RenderGrailsLayoutTagLib"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"org.grails.plugins.sitemesh3.Sitemesh3GrailsPlugin", (ClassLoader)classLoader)) {
            try {
                mockedClasses.add(Class.forName("org.grails.plugins.web.taglib.SitemeshTagLib"));
                mockedClasses.add(Class.forName("org.grails.plugins.web.taglib.RenderSitemeshTagLib"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tagLibClasses = mockedClasses;
    }

    protected void registerTagLibraries() {
        super.registerTagLibraries();
        for (Class providedArtefact : this.tagLibClasses) {
            this.registerLazyLoadableTagLibClass(providedArtefact);
        }
    }

    public void cleanTagLibsMetaClass() {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class clazz : this.tagLibClasses) {
            registry.removeMetaClass(clazz);
        }
    }

    public void registerLazyLoadableTagLibClass(Class tagLibClass) {
        Class<?> defaultTagLibClass = null;
        GrailsTagLibClass grailsTagLibClass = null;
        try {
            defaultTagLibClass = Class.forName("org.grails.core.gsp.DefaultGrailsTagLibClass");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            grailsTagLibClass = (GrailsTagLibClass)defaultTagLibClass.getConstructor(Class.class).newInstance(tagLibClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.hasNamespace(grailsTagLibClass.getNamespace())) {
            this.registerNamespaceDispatcher(grailsTagLibClass.getNamespace());
        }
        for (String tagName : grailsTagLibClass.getTagNames()) {
            String tagKey = this.tagNameKey(grailsTagLibClass.getNamespace(), tagName);
            this.lazyLoadableTagLibs.put(tagKey, grailsTagLibClass);
        }
    }

    public GroovyObject lookupTagLibrary(String namespace, String tagName) {
        String tagKey;
        GrailsTagLibClass taglibClass;
        GroovyObject tagLibrary = super.lookupTagLibrary(namespace, tagName);
        if (tagLibrary == null && (taglibClass = this.lazyLoadableTagLibs.get(tagKey = this.tagNameKey(namespace, tagName))) != null) {
            if (!this.applicationContext.containsBean(taglibClass.getFullName())) {
                GenericBeanDefinition bd = new GenericBeanDefinition();
                bd.setBeanClass(taglibClass.getClazz());
                bd.setAutowireCandidate(true);
                bd.setAutowireMode(1);
                ((GenericApplicationContext)this.applicationContext).getDefaultListableBeanFactory().registerBeanDefinition(taglibClass.getFullName(), (BeanDefinition)bd);
            }
            this.registerTagLib(taglibClass);
            tagLibrary = super.lookupTagLibrary(namespace, tagName);
        }
        return tagLibrary;
    }

    protected String tagNameKey(String namespace, String tagName) {
        return namespace + ":" + tagName;
    }

    protected void putTagLib(Map<String, Object> tags, String name, GrailsTagLibClass taglib) {
        if (this.applicationContext.containsBean(taglib.getFullName())) {
            super.putTagLib(tags, name, taglib);
        }
    }
}

