/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.bson.codecs;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.datastore.bson.codecs.CodecExtensions;
import org.grails.datastore.bson.codecs.PropertyDecoder;
import org.grails.datastore.bson.codecs.PropertyEncoder;
import org.grails.datastore.bson.codecs.decoders.BasicCollectionTypeDecoder;
import org.grails.datastore.bson.codecs.decoders.CustomTypeDecoder;
import org.grails.datastore.bson.codecs.decoders.EmbeddedCollectionDecoder;
import org.grails.datastore.bson.codecs.decoders.EmbeddedDecoder;
import org.grails.datastore.bson.codecs.decoders.IdentityDecoder;
import org.grails.datastore.bson.codecs.decoders.SimpleDecoder;
import org.grails.datastore.bson.codecs.decoders.TenantIdDecoder;
import org.grails.datastore.bson.codecs.encoders.BasicCollectionTypeEncoder;
import org.grails.datastore.bson.codecs.encoders.CustomTypeEncoder;
import org.grails.datastore.bson.codecs.encoders.EmbeddedCollectionEncoder;
import org.grails.datastore.bson.codecs.encoders.EmbeddedEncoder;
import org.grails.datastore.bson.codecs.encoders.IdentityEncoder;
import org.grails.datastore.bson.codecs.encoders.SimpleEncoder;
import org.grails.datastore.bson.codecs.encoders.TenantIdEncoder;
import org.grails.datastore.gorm.schemaless.DynamicAttributes;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.config.GormProperties;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.springframework.core.convert.converter.Converter;

public class BsonPersistentEntityCodec
implements Codec,
GroovyObject {
    public static final EncoderContext DEFAULT_ENCODER_CONTEXT;
    public static final DecoderContext DEFAULT_DECODER_CONTEXT;
    private static final Map<Class<? extends PersistentProperty>, PropertyEncoder> ENCODERS;
    private static final Map<Class<? extends PersistentProperty>, PropertyDecoder> DECODERS;
    private final MappingContext mappingContext;
    private final PersistentEntity entity;
    private final CodecRegistry codecRegistry;
    private final boolean stateful;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public BsonPersistentEntityCodec(CodecRegistry codecRegistry, PersistentEntity entity, boolean stateful) {
        boolean bl;
        PersistentEntity persistentEntity;
        CodecRegistry codecRegistry2;
        MappingContext mappingContext;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.mappingContext = mappingContext = entity.getMappingContext();
        this.codecRegistry = codecRegistry2 = codecRegistry;
        this.entity = persistentEntity = entity;
        this.stateful = bl = stateful;
    }

    @Generated
    public BsonPersistentEntityCodec(CodecRegistry codecRegistry, PersistentEntity entity) {
        this(codecRegistry, entity, false);
    }

    static {
        Map map;
        Map map2;
        DecoderContext decoderContext;
        EncoderContext encoderContext;
        DEFAULT_ENCODER_CONTEXT = encoderContext = EncoderContext.builder().build();
        DEFAULT_DECODER_CONTEXT = decoderContext = DecoderContext.builder().build();
        ENCODERS = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        DECODERS = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        IdentityEncoder identityEncoder = new IdentityEncoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, ENCODERS, (String)"putAt", (Object[])new Object[]{Identity.class, identityEncoder});
        IdentityDecoder identityDecoder = new IdentityDecoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, DECODERS, (String)"putAt", (Object[])new Object[]{Identity.class, identityDecoder});
        TenantIdEncoder tenantIdEncoder = new TenantIdEncoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, ENCODERS, (String)"putAt", (Object[])new Object[]{TenantId.class, tenantIdEncoder});
        TenantIdDecoder tenantIdDecoder = new TenantIdDecoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, DECODERS, (String)"putAt", (Object[])new Object[]{TenantId.class, tenantIdDecoder});
        SimpleEncoder simpleEncoder = new SimpleEncoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, ENCODERS, (String)"putAt", (Object[])new Object[]{Simple.class, simpleEncoder});
        SimpleDecoder simpleDecoder = new SimpleDecoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, DECODERS, (String)"putAt", (Object[])new Object[]{Simple.class, simpleDecoder});
        EmbeddedEncoder embeddedEncoder = new EmbeddedEncoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, ENCODERS, (String)"putAt", (Object[])new Object[]{Embedded.class, embeddedEncoder});
        EmbeddedDecoder embeddedDecoder = new EmbeddedDecoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, DECODERS, (String)"putAt", (Object[])new Object[]{Embedded.class, embeddedDecoder});
        EmbeddedCollectionEncoder embeddedCollectionEncoder = new EmbeddedCollectionEncoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, ENCODERS, (String)"putAt", (Object[])new Object[]{EmbeddedCollection.class, embeddedCollectionEncoder});
        EmbeddedCollectionDecoder embeddedCollectionDecoder = new EmbeddedCollectionDecoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, DECODERS, (String)"putAt", (Object[])new Object[]{EmbeddedCollection.class, embeddedCollectionDecoder});
        CustomTypeEncoder customTypeEncoder = new CustomTypeEncoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, ENCODERS, (String)"putAt", (Object[])new Object[]{Custom.class, customTypeEncoder});
        CustomTypeDecoder customTypeDecoder = new CustomTypeDecoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, DECODERS, (String)"putAt", (Object[])new Object[]{Custom.class, customTypeDecoder});
        BasicCollectionTypeEncoder basicCollectionTypeEncoder = new BasicCollectionTypeEncoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, ENCODERS, (String)"putAt", (Object[])new Object[]{Basic.class, basicCollectionTypeEncoder});
        BasicCollectionTypeDecoder basicCollectionTypeDecoder = new BasicCollectionTypeDecoder();
        ScriptBytecodeAdapter.invokeMethodN(BsonPersistentEntityCodec.class, DECODERS, (String)"putAt", (Object[])new Object[]{Basic.class, basicCollectionTypeDecoder});
    }

    public static void registerEncoder(Class<? extends PersistentProperty> type, PropertyEncoder propertyEncoder) {
        ENCODERS.put(type, propertyEncoder);
    }

    public static void registerDecoder(Class<? extends PersistentProperty> type, PropertyDecoder propertyDecoder) {
        DECODERS.put(type, propertyDecoder);
    }

    public Object decode(BsonReader bsonReader, DecoderContext decoderContext) {
        bsonReader.readStartDocument();
        PersistentEntity persistentEntity = this.entity;
        Object instance = DefaultGroovyMethods.newInstance((Class)persistentEntity.getJavaClass());
        EntityAccess access = this.mappingContext.createEntityAccess(persistentEntity, instance);
        BsonType bsonType = bsonReader.readBsonType();
        boolean abortReading = false;
        boolean hasDynamicAttributes = instance instanceof DynamicAttributes;
        while (ScriptBytecodeAdapter.compareNotEqual((Object)bsonType, (Object)BsonType.END_OF_DOCUMENT)) {
            String name = bsonReader.readName();
            if (!abortReading) {
                if (this.isDiscriminatorProperty(name)) {
                    PersistentEntity childEntity = this.mappingContext.getChildEntityByDiscriminator(persistentEntity.getRootEntity(), bsonReader.readString());
                    if (childEntity != null) {
                        childEntity.newInstance();
                        EntityAccess newAccess = this.createEntityAccess(childEntity, instance);
                        newAccess.setIdentifierNoConversion(access.getIdentifier());
                    }
                    bsonReader.readBsonType();
                    continue;
                }
                if (this.isIdentifierProperty(name)) {
                    this.getPropertyDecoder(Identity.class).decode(bsonReader, (Identity)IndyInterface.bootstrap("cast", "()", 0, persistentEntity.getIdentity()), access, decoderContext, this.codecRegistry);
                    Object cachedInstance = this.retrieveCachedInstance(access);
                    if (cachedInstance != null) {
                        abortReading = true;
                    }
                } else {
                    PersistentProperty property = persistentEntity.getPropertyByName(name);
                    if (DefaultTypeTransformation.booleanUnbox((Object)property) && ScriptBytecodeAdapter.compareNotEqual((Object)bsonType, (Object)BsonType.NULL)) {
                        Class<?> propKind = property.getClass().getSuperclass();
                        if (CharSequence.class.isAssignableFrom(property.getType()) && ScriptBytecodeAdapter.compareEqual((Object)bsonType, (Object)BsonType.STRING)) {
                            access.setPropertyNoConversion(property.getName(), (Object)bsonReader.readString());
                        } else {
                            PropertyDecoder<?> propertyDecoder = this.getPropertyDecoder(propKind);
                            if (propertyDecoder != null) {
                                propertyDecoder.decode(bsonReader, property, access, decoderContext, this.codecRegistry);
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                        }
                    } else if (!abortReading && hasDynamicAttributes) {
                        this.readSchemaless(bsonReader, (DynamicAttributes)IndyInterface.bootstrap("cast", "()", 0, instance), name, decoderContext);
                    } else {
                        bsonReader.skipValue();
                    }
                }
            } else if (!abortReading) {
                this.readSchemaless(bsonReader, (DynamicAttributes)IndyInterface.bootstrap("cast", "()", 0, instance), name, decoderContext);
            } else {
                bsonReader.skipValue();
            }
            bsonReader.readBsonType();
        }
        bsonReader.readEndDocument();
        this.readingComplete(access);
        return instance;
    }

    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        this.encode(writer, value, encoderContext, true);
    }

    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext, boolean includeIdentifier) {
        List list;
        writer.writeStartDocument();
        EntityAccess access = this.createEntityAccess(value);
        PersistentEntity entity = access.getPersistentEntity();
        if (!entity.isRoot()) {
            String discriminatorName = this.getDiscriminatorAttributeName();
            String discriminator = entity.getDiscriminator();
            writer.writeName(discriminatorName);
            writer.writeString(discriminator);
        }
        if (includeIdentifier) {
            Object id = access.getIdentifier();
            if (id != null) {
                this.getPropertyEncoder(Identity.class).encode(writer, (Identity)IndyInterface.bootstrap("cast", "()", 0, entity.getIdentity()), id, access, encoderContext, this.codecRegistry);
            }
        }
        Iterator iterator = (list = entity.getPersistentProperties()) != null ? list.iterator() : null;
        CallSite prop = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Object v1;
                prop = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                Class<?> propKind = prop.getClass().getSuperclass();
                Object v = access.getProperty(prop.getName());
                if (!(v != null)) continue;
                PropertyEncoder<?> encoder = this.getPropertyEncoder(propKind);
                PropertyEncoder<?> propertyEncoder = encoder;
                if (propertyEncoder != null) {
                    propertyEncoder.encode(writer, (PersistentProperty)prop, v, access, encoderContext, this.codecRegistry);
                    v1 = null;
                    continue;
                }
                v1 = null;
            }
        }
        if (value instanceof DynamicAttributes) {
            Map attributes = IndyInterface.bootstrap("cast", "()", 0, value).attributes();
            this.writeAttributes(attributes, writer, encoderContext);
        }
        this.beforeFinishDocument(writer, access);
        writer.writeEndDocument();
        writer.flush();
        this.writingComplete(access);
    }

    public Bson encodeUpdate(Object value, EntityAccess access, EncoderContext encoderContext, boolean embedded) {
        BsonDocument update = new BsonDocument();
        PersistentEntity entity = access.getPersistentEntity();
        ProxyFactory proxyFactory = this.mappingContext.getProxyFactory();
        if (proxyFactory.isProxy(value)) {
            value = proxyFactory.unwrap(value);
        }
        if (value instanceof DirtyCheckable) {
            BsonDocumentWriter writer = new BsonDocumentWriter(update);
            writer.writeStartDocument();
            CallSite dirty = IndyInterface.bootstrap("cast", "()", 0, value);
            CallSite processed = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            List dirtyProperties = new ArrayList(dirty.listDirtyPropertyNames());
            boolean isNew = ((ArrayList)((Object)IndyInterface.bootstrap("cast", "()", 0, dirtyProperties))).isEmpty() && dirty.hasChanged();
            boolean isVersioned = entity.isVersioned();
            if (isNew) {
                dirtyProperties = entity.getPersistentPropertyNames();
                if (isVersioned) {
                    EntityPersister.incrementEntityVersion((EntityAccess)access);
                }
            } else if (entity.getPropertyByName(GormProperties.LAST_UPDATED) != null) {
                ((ArrayList)((Object)IndyInterface.bootstrap("cast", "()", 0, dirtyProperties))).add(GormProperties.LAST_UPDATED);
            }
            List list = dirtyProperties;
            Object propertyName = null;
            Iterator iterator = list != null ? list.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    propertyName = iterator.next();
                    PersistentProperty prop = entity.getPropertyByName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, propertyName)));
                    if (!(prop != null)) continue;
                    DefaultGroovyMethods.leftShift((Set)((Object)processed), propertyName);
                    Object v = access.getProperty(prop.getName());
                    if (v != null) {
                        Object v0;
                        if (prop instanceof Embedded) {
                            writer.writeName(IndyInterface.bootstrap("cast", "()", 0, prop).getName());
                            this.encodeUpdate(v, this.createEntityAccess(IndyInterface.bootstrap("cast", "()", 0, prop).getAssociatedEntity(), v), encoderContext, true);
                            continue;
                        }
                        if (prop instanceof EmbeddedCollection) continue;
                        Class<?> propKind = prop.getClass().getSuperclass();
                        if (!(prop instanceof PersistentProperty)) continue;
                        PropertyEncoder<?> propertyEncoder = this.getPropertyEncoder(propKind);
                        PropertyEncoder<?> propertyEncoder2 = propertyEncoder;
                        if (propertyEncoder2 != null) {
                            propertyEncoder2.encode((BsonWriter)writer, prop, v, access, encoderContext, this.codecRegistry);
                            v0 = null;
                            continue;
                        }
                        v0 = null;
                        continue;
                    }
                    if (!(embedded || !isNew)) continue;
                    writer.writeName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, propertyName)));
                    writer.writeNull();
                }
            }
            if (value instanceof DynamicAttributes) {
                Map attributes = IndyInterface.bootstrap("cast", "()", 0, value).attributes();
                Set set = attributes.keySet();
                Iterator iterator2 = set != null ? set.iterator() : null;
                Object attr = null;
                Iterator iterator3 = iterator2;
                if (iterator3 != null) {
                    while (iterator3.hasNext()) {
                        attr = iterator3.next();
                        Object v = attributes.get(attr);
                        if (v == null) {
                            writer.writeName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, attr)));
                            writer.writeNull();
                            continue;
                        }
                        writer.writeName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, attr)));
                        Codec codec = this.codecRegistry.get(v.getClass());
                        codec.encode((BsonWriter)writer, v, encoderContext);
                    }
                }
            }
            writer.writeEndDocument();
        }
        return update;
    }

    public Class getEncoderClass() {
        return this.entity.getJavaClass();
    }

    protected void writeAttributes(Map<String, Object> attributes, BsonWriter writer, EncoderContext encoderContext) {
        Set<String> set = attributes.keySet();
        Iterator<String> iterator = set != null ? set.iterator() : null;
        String name = null;
        Iterator<String> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                name = iterator2.next();
                writer.writeName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, name)));
                Object v = attributes.get(name);
                Codec codec = this.codecRegistry.get(v.getClass());
                codec.encode(writer, v, encoderContext);
            }
        }
    }

    protected Object retrieveCachedInstance(EntityAccess access) {
        return null;
    }

    protected boolean isIdentifierProperty(String name) {
        return ScriptBytecodeAdapter.compareEqual((Object)name, (Object)GormProperties.IDENTITY);
    }

    protected void beforeFinishDocument(BsonWriter bsonWriter, EntityAccess access) {
    }

    protected void writingComplete(EntityAccess entityAccess) {
    }

    protected void readingComplete(EntityAccess access) {
    }

    protected void readSchemaless(BsonReader bsonReader, DynamicAttributes dynamicAttributes, String name, DecoderContext decoderContext) {
        BsonType currentBsonType = bsonReader.getCurrentBsonType();
        Class targetClass = BsonValueCodecProvider.getClassForBsonType((BsonType)currentBsonType);
        Codec codec = this.codecRegistry.get(targetClass);
        BsonValue bsonValue = (BsonValue)codec.decode(bsonReader, decoderContext);
        if (bsonValue != null) {
            Converter converter = CodecExtensions.getBsonConverter(bsonValue.getClass());
            dynamicAttributes.putAt(name, converter != null ? converter.convert((Object)bsonValue) : bsonValue);
        }
    }

    protected EntityAccess createEntityAccess(Object instance) {
        PersistentEntity entity = this.mappingContext.getPersistentEntity(instance.getClass().getName());
        return this.createEntityAccess(entity, instance);
    }

    protected EntityAccess createEntityAccess(PersistentEntity entity, Object instance) {
        return this.mappingContext.createEntityAccess(entity, instance);
    }

    protected String getDiscriminatorAttributeName() {
        return GormProperties.CLASS;
    }

    protected boolean isDiscriminatorProperty(String name) {
        String discriminatorName = this.getDiscriminatorAttributeName();
        return discriminatorName != null && name.equals(discriminatorName);
    }

    protected <T extends PersistentProperty> PropertyEncoder<T> getPropertyEncoder(Class<T> type) {
        return IndyInterface.bootstrap("cast", "()", 0, ENCODERS.get(type));
    }

    protected <T extends PersistentProperty> PropertyDecoder<T> getPropertyDecoder(Class<T> type) {
        return IndyInterface.bootstrap("cast", "()", 0, DECODERS.get(type));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BsonPersistentEntityCodec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public Object decode(BsonReader bsonReader) {
        return this.decode(bsonReader, DEFAULT_DECODER_CONTEXT);
    }

    @Generated
    public void encode(BsonWriter writer, Object value) {
        this.encode(writer, value, DEFAULT_ENCODER_CONTEXT);
    }

    @Generated
    public Bson encodeUpdate(Object value, EntityAccess access, EncoderContext encoderContext) {
        return this.encodeUpdate(value, access, encoderContext, false);
    }

    @Generated
    public Bson encodeUpdate(Object value, EntityAccess access) {
        return this.encodeUpdate(value, access, DEFAULT_ENCODER_CONTEXT, false);
    }

    @Generated
    public Bson encodeUpdate(Object value) {
        return this.encodeUpdate(value, (EntityAccess)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createEntityAccess", 2, this, value)), DEFAULT_ENCODER_CONTEXT, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Generated
    public PersistentEntity getEntity() {
        return this.entity;
    }

    @Generated
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Generated
    public boolean getStateful() {
        return this.stateful;
    }

    @Generated
    public boolean isStateful() {
        return this.stateful;
    }
}

